/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.xplain;

import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINFactoryIF;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.execute.xplain.XPLAINDefaultVisitor;
import org.apache.derby.impl.sql.execute.xplain.XPLAINSystemTableVisitor;

public class XPLAINFactory
implements XPLAINFactoryIF {
    private XPLAINVisitor currentVisitor = new XPLAINDefaultVisitor();
    private String currentSchema = null;

    public XPLAINVisitor getXPLAINVisitor() throws StandardException {
        try {
            LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
            String string = languageConnectionContext.getXplainSchema();
            if (string != this.currentSchema) {
                this.currentSchema = string;
                this.currentVisitor = this.currentSchema == null ? new XPLAINDefaultVisitor() : new XPLAINSystemTableVisitor();
            }
        }
        catch (SQLException sQLException) {
            throw StandardException.plainWrapException(sQLException);
        }
        return this.currentVisitor;
    }

    public void freeResources() {
        this.currentVisitor = null;
        this.currentSchema = null;
    }
}

