/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.io.IOException;
import java.nio.channels.Selector;
import org.apache.coyote.http11.upgrade.AbstractServletOutputStream;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.NioSelectorPool;
import org.apache.tomcat.util.net.SocketWrapper;

public class NioServletOutputStream
extends AbstractServletOutputStream {
    private final NioChannel channel;
    private final NioSelectorPool pool;
    private final int maxWrite;

    public NioServletOutputStream(SocketWrapper<NioChannel> wrapper, NioSelectorPool pool) {
        this.channel = wrapper.getSocket();
        this.pool = pool;
        this.maxWrite = this.channel.getBufHandler().getWriteBuffer().capacity();
    }

    @Override
    protected int doWrite(boolean block, byte[] b, int off, int len) throws IOException {
        int writtenThisLoop;
        int count = 0;
        int offset = off;
        for (int leftToWrite = len; leftToWrite > 0; leftToWrite -= writtenThisLoop) {
            int writeThisLoop = leftToWrite > this.maxWrite ? this.maxWrite : leftToWrite;
            writtenThisLoop = this.doWriteInternal(block, b, offset, writeThisLoop);
            count += writtenThisLoop;
            offset += writtenThisLoop;
            if (writtenThisLoop >= writeThisLoop) continue;
            break;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doWriteInternal(boolean block, byte[] b, int off, int len) throws IOException {
        this.channel.getBufHandler().getWriteBuffer().clear();
        this.channel.getBufHandler().getWriteBuffer().put(b, off, len);
        this.channel.getBufHandler().getWriteBuffer().flip();
        int written = 0;
        NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)this.channel.getAttachment(false);
        if (att == null) {
            throw new IOException("Key must be cancelled");
        }
        long writeTimeout = att.getWriteTimeout();
        Selector selector = null;
        try {
            selector = this.pool.get();
        }
        catch (IOException x) {
            // empty catch block
        }
        try {
            written = this.pool.write(this.channel.getBufHandler().getWriteBuffer(), this.channel, selector, writeTimeout, block);
        }
        finally {
            if (selector != null) {
                this.pool.put(selector);
            }
        }
        if (written < len) {
            this.channel.getPoller().add(this.channel, 4);
        }
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFlush() throws IOException {
        NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)this.channel.getAttachment(false);
        if (att == null) {
            throw new IOException("Key must be cancelled");
        }
        long writeTimeout = att.getWriteTimeout();
        Selector selector = null;
        try {
            selector = this.pool.get();
        }
        catch (IOException x) {
            // empty catch block
        }
        try {
            while (!this.channel.flush(true, selector, writeTimeout)) {
            }
        }
        finally {
            if (selector != null) {
                this.pool.put(selector);
            }
        }
    }

    @Override
    protected void doClose() throws IOException {
        this.channel.close(true);
    }
}

