/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.detector;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import org.jolokia.detector.AbstractServerDetector;
import org.jolokia.detector.ServerHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassfishDetector
extends AbstractServerDetector {
    private static final Pattern GLASSFISH_VERSION = Pattern.compile("^.*GlassFish.*\\sv?(.*?)$", 2);
    private static final Pattern GLASSFISH_FULL_VERSION = Pattern.compile("^\\s*GlassFish.*?\\sv?([.\\d]+)\\s.*$?");

    @Override
    public ServerHandle detect(Set<MBeanServer> pMbeanServers) {
        String version = this.detectVersion(pMbeanServers);
        if (version != null) {
            return new GlassfishServerHandle(version, null, new HashMap<String, String>());
        }
        return null;
    }

    private String detectVersion(Set<MBeanServer> pMbeanServers) {
        String fullVersion = this.getSingleStringAttribute(pMbeanServers, "com.sun.appserv:j2eeType=J2EEServer,*", "serverVersion");
        String version = this.extractVersionFromFullVersion(fullVersion);
        if (fullVersion == null || "3".equals(version)) {
            String versionFromAmx = this.getSingleStringAttribute(pMbeanServers, "amx:type=domain-root,*", "ApplicationServerFullVersion");
            version = this.getVersionFromFullVersion(version, versionFromAmx != null ? versionFromAmx : System.getProperty("glassfish.version"));
        } else if (this.mBeanExists(pMbeanServers, "com.sun.appserver:type=Host,*")) {
            version = "3";
        }
        return version;
    }

    private String extractVersionFromFullVersion(String pFullVersion) {
        Matcher matcher;
        if (pFullVersion != null && (matcher = GLASSFISH_VERSION.matcher(pFullVersion)).matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private String getVersionFromFullVersion(String pOriginalVersion, String pFullVersion) {
        if (pFullVersion == null) {
            return pOriginalVersion;
        }
        Matcher v3Matcher = GLASSFISH_FULL_VERSION.matcher(pFullVersion);
        if (v3Matcher.matches()) {
            return v3Matcher.group(1);
        }
        return pOriginalVersion;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GlassfishServerHandle
    extends ServerHandle {
        public GlassfishServerHandle(String version, URL agentUrl, Map<String, String> extraInfo) {
            super("Sun", "glassfish", version, agentUrl, extraInfo);
        }

        @Override
        public Map<String, String> getExtraInfo(Set<? extends MBeanServerConnection> pServers) {
            Map<String, String> extra = super.getExtraInfo(pServers);
            if (extra != null && this.getVersion().startsWith("3")) {
                extra.put("amxBooted", Boolean.toString(GlassfishDetector.this.mBeanExists(pServers, "amx:type=domain-root,*")));
            }
            return extra;
        }
    }
}

