/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.enterprise.openejb.deployer;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.openejb.NoSuchApplicationException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.ResourceInfo;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;

public class VirgoUndeployerEjb {
    private final String modulePath;
    private AppInfo appForUndeploy = null;
    private static final String OPENEJB_RESOURCES_SUBCONTEXT_NAME = "openejb/Resource/";

    public VirgoUndeployerEjb(String modulePath) {
        this.modulePath = modulePath;
        Assembler assembler = (Assembler)SystemInstance.get().getComponent(org.apache.openejb.spi.Assembler.class);
        Collection apps = assembler.getDeployedApplications();
        for (AppInfo appInfo : apps) {
            if (!modulePath.equals(appInfo.path)) continue;
            this.appForUndeploy = appInfo;
            break;
        }
    }

    public void undeploy() throws NoSuchApplicationException {
        if (this.appForUndeploy == null) {
            throw new NoSuchApplicationException("Application with path " + this.modulePath + "cannot be found");
        }
        ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        Context context = containerSystem.getJNDIContext();
        if (this.appForUndeploy != null) {
            Set resources = this.appForUndeploy.resourceInfos;
            for (ResourceInfo resource : resources) {
                try {
                    context.unbind(resource.id);
                }
                catch (NamingException namingException) {}
            }
        }
    }

    public void clearResources(String moduleId) throws UndeployException, NoSuchApplicationException {
        if (this.appForUndeploy == null) {
            throw new NoSuchApplicationException("Application with path " + this.modulePath + "cannot be found");
        }
        OpenEjbConfiguration config = (OpenEjbConfiguration)SystemInstance.get().getComponent(OpenEjbConfiguration.class);
        List resources = config.facilities.resources;
        Iterator iResourceInfos = resources.iterator();
        while (iResourceInfos.hasNext()) {
            ResourceInfo resourceInfo = (ResourceInfo)iResourceInfos.next();
            if (!resourceInfo.id.contains(this.appForUndeploy.appId)) continue;
            iResourceInfos.remove();
        }
        Context context = ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getJNDIContext();
        try {
            context.unbind(OPENEJB_RESOURCES_SUBCONTEXT_NAME + this.appForUndeploy.appId);
        }
        catch (NamingException e) {
            throw new UndeployException("Failed to unbind resorce", (Throwable)e);
        }
    }
}

