/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrivilegedActions {
    private static String lineSeparator = null;
    private static String pathSeparator = null;

    public static final String getLineSeparator() {
        if (lineSeparator == null) {
            lineSeparator = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("line.separator");
                }
            });
        }
        return lineSeparator;
    }

    public static final String getPathSeparator() {
        if (pathSeparator == null) {
            pathSeparator = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("path.separator");
                }
            });
        }
        return pathSeparator;
    }

    public static <T> T newInstance(Class<T> cls) {
        return PrivilegedActions.newInstance(cls, IllegalArgumentException.class);
    }

    public static <T, E extends RuntimeException> T newInstance(final Class<T> cls, final Class<E> exception, final Class<?>[] paramTypes, final Object[] values) {
        return PrivilegedActions.run(new PrivilegedAction<T>(){

            @Override
            public T run() {
                try {
                    Constructor cons = cls.getConstructor(paramTypes);
                    if (!cons.isAccessible()) {
                        cons.setAccessible(true);
                    }
                    return cons.newInstance(values);
                }
                catch (Exception e) {
                    throw PrivilegedActions.newException("Cannot instantiate : " + cls, exception, e);
                }
            }
        });
    }

    public static <T, E extends RuntimeException> T newInstance(final Class<T> cls, final Class<E> exception) {
        return PrivilegedActions.run(new PrivilegedAction<T>(){

            @Override
            public T run() {
                try {
                    return cls.newInstance();
                }
                catch (Exception e) {
                    throw PrivilegedActions.newException("Cannot instantiate : " + cls, exception, e);
                }
            }
        });
    }

    private static <E extends RuntimeException> RuntimeException newException(String msg, Class<E> exception, Throwable e) {
        try {
            Constructor<E> co = exception.getConstructor(String.class, Throwable.class);
            try {
                return (RuntimeException)co.newInstance(msg, e);
            }
            catch (Exception e1) {
                return new RuntimeException(msg, e);
            }
        }
        catch (NoSuchMethodException e1) {
            return new RuntimeException(msg, e);
        }
    }

    public static <T> T run(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return action.run();
    }

    public static Object getAnnotationValue(final Annotation annotation, final String name) throws IllegalAccessException, InvocationTargetException {
        return PrivilegedActions.run(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Method valueMethod;
                try {
                    valueMethod = annotation.annotationType().getDeclaredMethod(name, new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    valueMethod = null;
                }
                if (null != valueMethod) {
                    try {
                        valueMethod.setAccessible(true);
                        return valueMethod.invoke((Object)annotation, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }
        });
    }

    public static ClassLoader getClassLoader(final Class<?> clazz) {
        return PrivilegedActions.run(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = clazz.getClassLoader();
                }
                return cl;
            }
        });
    }

    public static final String getProperty(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name);
            }
        });
    }
}

