/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.export;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.jarpackager.IJarExportRunnable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.virgo.ide.export.BundleExportUtils;
import org.eclipse.virgo.ide.export.BundleExportWizardPage;
import org.eclipse.virgo.ide.export.ServerExportPlugin;

public class BundleExportWizard
extends Wizard
implements IExportWizard {
    private BundleExportWizardPage wizardPage;
    private IStructuredSelection selection;
    private static final String TITLE = "Bundle Export Wizard";

    public void addPages() {
        this.wizardPage = new BundleExportWizardPage(this.selection);
        this.addPage((IWizardPage)this.wizardPage);
    }

    public boolean performFinish() {
        boolean overwrite;
        IJavaProject project = JavaCore.create((IProject)this.wizardPage.getSelectedProject());
        IPath jarLocation = this.wizardPage.getJarLocation();
        if (jarLocation.toFile().exists() && !this.wizardPage.getOverwrite() && !(overwrite = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Overwrite File", (String)("The file " + jarLocation.toOSString() + " already exists. Do you want to overwrite the existing file?")))) {
            return false;
        }
        ArrayList<IStatus> warnings = new ArrayList<IStatus>();
        IJarExportRunnable op = BundleExportUtils.createExportOperation(project, jarLocation, this.getShell(), warnings);
        return BundleExportUtils.executeExportOperation(op, true, (IRunnableContext)this.getContainer(), this.getShell(), warnings);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setWindowTitle(TITLE);
        this.setDefaultPageImageDescriptor(ServerExportPlugin.getImageDescriptor("full/wizban/wizban-bundle.png"));
        this.setNeedsProgressMonitor(true);
    }
}

