/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model.timegraph;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;

public interface ITimeGraphStateFilter {
    default public void applyFilterAndAddState(List<ITimeGraphState> stateList, ITimeGraphState timeGraphState, Long entryId, Map<Integer, Predicate<Multimap<String, Object>>> predicates, @Nullable IProgressMonitor monitor) {
        this.applyFilterAndAddState(stateList, timeGraphState, entryId, predicates, null, monitor);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    default public void applyFilterAndAddState(List<ITimeGraphState> stateList, ITimeGraphState timeGraphState, Long entryId, Map<Integer, Predicate<Multimap<String, Object>>> predicates, @Nullable List<Long> times, @Nullable IProgressMonitor monitor) {
        int index;
        long startTime = timeGraphState.getStartTime();
        long endTime = timeGraphState.getStartTime() + timeGraphState.getDuration();
        if (times != null && !stateList.isEmpty()) {
            ITimeGraphState lastState = (ITimeGraphState)Iterables.getLast(stateList);
            long lastStart = lastState.getStartTime();
            long lastEnd = lastStart + lastState.getDuration();
            int index2 = Collections.binarySearch(times, lastStart);
            if (index2 < 0) {
                if ((index2 = -index2 - 1) >= times.size()) {
                    return;
                }
                if (lastEnd < times.get(index2) && endTime <= times.get(index2)) {
                    return;
                }
            }
        }
        if (!predicates.isEmpty()) {
            @NonNull @NonNull HashMultimap input = HashMultimap.create();
            input.putAll(this.getFilterData(entryId, startTime, monitor));
            input.putAll(timeGraphState.getMetadata());
            for (Map.Entry<Integer, Predicate<Multimap<String, Object>>> mapEntry : predicates.entrySet()) {
                Predicate<Multimap<String, Object>> value = Objects.requireNonNull(mapEntry.getValue());
                boolean status = value.test((Multimap<String, Object>)input);
                Integer property = Objects.requireNonNull(mapEntry.getKey());
                if (property == 1 || property == 4) {
                    timeGraphState.setProperty(property, !status);
                    continue;
                }
                timeGraphState.setProperty(property, status);
            }
        }
        if (times != null && (timeGraphState.getActiveProperties() & 5) != 0 && (index = Collections.binarySearch(times, startTime)) < 0 && ((index = -index - 1) >= times.size() || endTime < times.get(index))) {
            return;
        }
        if (timeGraphState.isPropertyActive(4)) {
            TimeGraphState timeGraphState2 = new TimeGraphState(timeGraphState.getStartTime(), timeGraphState.getDuration(), Integer.MIN_VALUE);
            timeGraphState2.setActiveProperties(timeGraphState.getActiveProperties());
            stateList.add(timeGraphState2);
        } else {
            stateList.add(timeGraphState);
        }
    }

    default public Multimap<String, Object> getFilterData(long entryId, long time, @Nullable IProgressMonitor monitor) {
        return ImmutableMultimap.of();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SafeVarargs
    public static Multimap<String, Object> mergeMultimaps(Multimap<String, Object> ... maps) {
        @NonNull @NonNull HashMultimap data = HashMultimap.create();
        Multimap<String, Object>[] multimapArray = maps;
        int n = maps.length;
        int n2 = 0;
        while (n2 < n) {
            Multimap<String, Object> multimap = multimapArray[n2];
            data.putAll(multimap);
            ++n2;
        }
        return data;
    }
}

