/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.statesystem.mipmap;

import java.util.List;
import java.util.Random;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.core.statesystem.mipmap.TmfStateSystemOperations;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemFactory;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.tests.statesystem.mipmap.TmfMipmapStateProviderStub;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TmfMipmapStateProviderTest {
    private static final @NonNull String SSID = "mimap-test";
    private static final String TEST_ATTRIBUTE_NAME = "test_attribute";
    private static final int NB_LEVELS = 4;
    private static final long START_TIME = 1000L;
    private static final long END_TIME = 100000000L;
    private static final long INTERVAL = 1000L;
    private static final int RESOLUTION = 16;
    private static final double DELTA = 1.0E-4;
    private static final long TEST_TIMESTAMP = 12345000L;
    private static ITmfStateSystemBuilder ssq;

    @BeforeClass
    public static void init() {
        TmfMipmapStateProviderStub mmp = new TmfMipmapStateProviderStub(16, ITmfStateValue.Type.LONG);
        IStateHistoryBackend be = StateHistoryBackendFactory.createInMemoryBackend((String)SSID, (long)0L);
        ITmfStateSystemBuilder ssb = StateSystemFactory.newStateSystem((IStateHistoryBackend)be);
        mmp.assignTargetStateSystem(ssb);
        ssq = ssb;
        long time = 1000L;
        while (time <= 100000000L) {
            long value = time / 1000L;
            ITmfEvent event = mmp.createEvent(time, value);
            mmp.processEvent(event);
            time += 1000L;
        }
        mmp.dispose();
        ssq.waitUntilBuilt();
    }

    @Test
    public void testQuery() {
        Assert.assertNotNull((Object)ssq);
        try {
            Random rn = new Random();
            long time = Math.max(1000L, rn.nextLong() % 100000000L);
            List intervals = ssq.queryFullState(time);
            int mipmapQuark = ssq.getQuarkAbsolute(new String[]{TEST_ATTRIBUTE_NAME});
            ITmfStateInterval interval = (ITmfStateInterval)intervals.get(mipmapQuark);
            long valueLong = interval.getStateValue().unboxLong();
            Assert.assertEquals((long)(time / 1000L), (long)valueLong);
        }
        catch (TimeRangeException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateSystemDisposedException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testMaxLevel() {
        Assert.assertNotNull((Object)ssq);
        try {
            Random rn = new Random();
            long time = Math.max(1000L, rn.nextLong() % 100000000L);
            List intervals = ssq.queryFullState(time);
            int maxMipmapQuark = ssq.getQuarkAbsolute(new String[]{TEST_ATTRIBUTE_NAME, "max"});
            int nbLevelMax = ((ITmfStateInterval)intervals.get(maxMipmapQuark)).getStateValue().unboxInt();
            Assert.assertEquals((long)4L, (long)nbLevelMax);
            int minMipmapQuark = ssq.getQuarkAbsolute(new String[]{TEST_ATTRIBUTE_NAME, "min"});
            int nbLevelMin = ((ITmfStateInterval)intervals.get(minMipmapQuark)).getStateValue().unboxInt();
            Assert.assertEquals((long)4L, (long)nbLevelMin);
            int avgMipmapQuark = ssq.getQuarkAbsolute(new String[]{TEST_ATTRIBUTE_NAME, "avg"});
            int nbLevelAvg = ((ITmfStateInterval)intervals.get(avgMipmapQuark)).getStateValue().unboxInt();
            Assert.assertEquals((long)4L, (long)nbLevelAvg);
        }
        catch (TimeRangeException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateSystemDisposedException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testQueryEventField() {
        Assert.assertNotNull((Object)ssq);
        try {
            List intervals = ssq.queryFullState(12345000L);
            int eventFieldQuark = ssq.getQuarkAbsolute(new String[]{TEST_ATTRIBUTE_NAME});
            ITmfStateInterval interval = (ITmfStateInterval)intervals.get(eventFieldQuark);
            long valueLong = interval.getStateValue().unboxLong();
            Assert.assertEquals((long)12345L, (long)valueLong);
        }
        catch (TimeRangeException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateSystemDisposedException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testQueryMipMax() {
        Assert.assertNotNull((Object)ssq);
        try {
            List intervals = ssq.queryFullState(12345000L);
            int mipmapQuark = ssq.getQuarkAbsolute(new String[]{TEST_ATTRIBUTE_NAME, "max"});
            Assert.assertEquals((String)"max nblevels", (long)4L, (long)((ITmfStateInterval)intervals.get(mipmapQuark)).getStateValue().unboxInt());
            int level = 1;
            while (level < 4) {
                long width = (long)Math.pow(16.0, level);
                int levelQuark = ssq.getQuarkRelative(mipmapQuark, new String[]{String.valueOf(level)});
                ITmfStateInterval interval = (ITmfStateInterval)intervals.get(levelQuark);
                long valueLong = interval.getStateValue().unboxLong();
                Assert.assertEquals((String)("max value @ level " + level), (long)(width + 12344L / width * width), (long)valueLong);
                Assert.assertEquals((String)("max start time @ level " + level), (long)(1000L + 12344L / width * width * 1000L), (long)interval.getStartTime());
                Assert.assertEquals((String)("max end time @ level " + level), (long)(1000L + 1000L * width + 12344L / width * width * 1000L), (long)(interval.getEndTime() + 1L));
                ++level;
            }
        }
        catch (TimeRangeException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateSystemDisposedException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testQueryMipMin() {
        Assert.assertNotNull((Object)ssq);
        try {
            List intervals = ssq.queryFullState(12345000L);
            int mipmapQuark = ssq.getQuarkAbsolute(new String[]{TEST_ATTRIBUTE_NAME, "min"});
            Assert.assertEquals((String)"min nblevels", (long)4L, (long)((ITmfStateInterval)intervals.get(mipmapQuark)).getStateValue().unboxInt());
            int level = 1;
            while (level < 4) {
                long width = (long)Math.pow(16.0, level);
                int levelQuark = ssq.getQuarkRelative(mipmapQuark, new String[]{String.valueOf(level)});
                ITmfStateInterval interval = (ITmfStateInterval)intervals.get(levelQuark);
                long valueLong = interval.getStateValue().unboxLong();
                Assert.assertEquals((String)("min value @ level " + level), (long)(1L + 12344L / width * width), (long)valueLong);
                Assert.assertEquals((String)("min start time @ level " + level), (long)(1000L + 12344L / width * width * 1000L), (long)interval.getStartTime());
                Assert.assertEquals((String)("min end time @ level " + level), (long)(1000L + 1000L * width + 12344L / width * width * 1000L), (long)(interval.getEndTime() + 1L));
                ++level;
            }
        }
        catch (TimeRangeException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateSystemDisposedException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testQueryMipAvg() {
        Assert.assertNotNull((Object)ssq);
        try {
            List intervals = ssq.queryFullState(12345000L);
            int mipmapQuark = ssq.getQuarkAbsolute(new String[]{TEST_ATTRIBUTE_NAME, "avg"});
            Assert.assertEquals((String)"avg nblevels", (long)4L, (long)((ITmfStateInterval)intervals.get(mipmapQuark)).getStateValue().unboxInt());
            int level = 1;
            while (level < 4) {
                long width = (long)Math.pow(16.0, level);
                int levelQuark = ssq.getQuarkRelative(mipmapQuark, new String[]{String.valueOf(level)});
                ITmfStateInterval interval = (ITmfStateInterval)intervals.get(levelQuark);
                double valueDouble = interval.getStateValue().unboxDouble();
                Assert.assertEquals((String)("avg value @ level " + level), (double)(0.5 + (double)(width / 2L) + (double)(12344L / width * width)), (double)valueDouble, (double)1.0E-4);
                Assert.assertEquals((String)("avg start time @ level " + level), (long)(1000L + 12344L / width * width * 1000L), (long)interval.getStartTime());
                Assert.assertEquals((String)("avg end time @ level " + level), (long)(1000L + 1000L * width + 12344L / width * width * 1000L), (long)(interval.getEndTime() + 1L));
                ++level;
            }
        }
        catch (TimeRangeException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateSystemDisposedException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testQueryValuesOnStart() {
        Assert.assertNotNull((Object)ssq);
        try {
            List intervals = ssq.queryFullState(1000L);
            int baseQuark = ssq.getQuarkAbsolute(new String[]{TEST_ATTRIBUTE_NAME});
            Assert.assertEquals((long)1L, (long)((ITmfStateInterval)intervals.get(baseQuark)).getStateValue().unboxLong());
            int maxMipmapQuark = ssq.getQuarkRelative(baseQuark, new String[]{"max"});
            Assert.assertEquals((String)"max nblevels", (long)4L, (long)((ITmfStateInterval)intervals.get(maxMipmapQuark)).getStateValue().unboxInt());
            int quark = ssq.getQuarkRelative(maxMipmapQuark, new String[]{String.valueOf(1)});
            Assert.assertEquals((String)"max value @ level 1", (long)((long)Math.pow(16.0, 1.0)), (long)((ITmfStateInterval)intervals.get(quark)).getStateValue().unboxLong());
            quark = ssq.getQuarkRelative(maxMipmapQuark, new String[]{String.valueOf(2)});
            Assert.assertEquals((String)"max value @ level 2", (long)((long)Math.pow(16.0, 2.0)), (long)((ITmfStateInterval)intervals.get(quark)).getStateValue().unboxLong());
            quark = ssq.getQuarkRelative(maxMipmapQuark, new String[]{String.valueOf(3)});
            Assert.assertEquals((String)"max value @ level 3", (long)((long)Math.pow(16.0, 3.0)), (long)((ITmfStateInterval)intervals.get(quark)).getStateValue().unboxLong());
            quark = ssq.getQuarkRelative(maxMipmapQuark, new String[]{String.valueOf(4)});
            Assert.assertEquals((String)"max value @ level 4", (long)((long)Math.pow(16.0, 4.0)), (long)((ITmfStateInterval)intervals.get(quark)).getStateValue().unboxLong());
            int minMipmapQuark = ssq.getQuarkRelative(baseQuark, new String[]{"min"});
            Assert.assertEquals((String)"min nblevels", (long)4L, (long)((ITmfStateInterval)intervals.get(minMipmapQuark)).getStateValue().unboxInt());
            quark = ssq.getQuarkRelative(minMipmapQuark, new String[]{String.valueOf(1)});
            Assert.assertEquals((String)"min value @ level 1", (long)1L, (long)((ITmfStateInterval)intervals.get(quark)).getStateValue().unboxLong());
            quark = ssq.getQuarkRelative(minMipmapQuark, new String[]{String.valueOf(2)});
            Assert.assertEquals((String)"min value @ level 2", (long)1L, (long)((ITmfStateInterval)intervals.get(quark)).getStateValue().unboxLong());
            quark = ssq.getQuarkRelative(minMipmapQuark, new String[]{String.valueOf(3)});
            Assert.assertEquals((String)"min value @ level 3", (long)1L, (long)((ITmfStateInterval)intervals.get(quark)).getStateValue().unboxLong());
            quark = ssq.getQuarkRelative(minMipmapQuark, new String[]{String.valueOf(4)});
            Assert.assertEquals((String)"min value @ level 4", (long)1L, (long)((ITmfStateInterval)intervals.get(quark)).getStateValue().unboxLong());
            int avgMipmapQuark = ssq.getQuarkRelative(baseQuark, new String[]{"avg"});
            Assert.assertEquals((String)"avg nblevels", (long)4L, (long)((ITmfStateInterval)intervals.get(avgMipmapQuark)).getStateValue().unboxInt());
            quark = ssq.getQuarkRelative(avgMipmapQuark, new String[]{String.valueOf(1)});
            Assert.assertEquals((String)"avg value @ level 1", (double)(0.5 + Math.pow(16.0, 1.0) / 2.0), (double)((ITmfStateInterval)intervals.get(quark)).getStateValue().unboxDouble(), (double)1.0E-4);
            quark = ssq.getQuarkRelative(avgMipmapQuark, new String[]{String.valueOf(2)});
            Assert.assertEquals((String)"avg value @ level 2", (double)(0.5 + Math.pow(16.0, 2.0) / 2.0), (double)((ITmfStateInterval)intervals.get(quark)).getStateValue().unboxDouble(), (double)1.0E-4);
            quark = ssq.getQuarkRelative(avgMipmapQuark, new String[]{String.valueOf(3)});
            Assert.assertEquals((String)"avg value @ level 3", (double)(0.5 + Math.pow(16.0, 3.0) / 2.0), (double)((ITmfStateInterval)intervals.get(quark)).getStateValue().unboxDouble(), (double)1.0E-4);
            quark = ssq.getQuarkRelative(avgMipmapQuark, new String[]{String.valueOf(4)});
            Assert.assertEquals((String)"avg value @ level 4", (double)(0.5 + Math.pow(16.0, 4.0) / 2.0), (double)((ITmfStateInterval)intervals.get(quark)).getStateValue().unboxDouble(), (double)1.0E-4);
        }
        catch (TimeRangeException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateSystemDisposedException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testQueryValuesOnClose() {
        Assert.assertNotNull((Object)ssq);
        try {
            List intervals = ssq.queryFullState(100000000L);
            int baseQuark = ssq.getQuarkAbsolute(new String[]{TEST_ATTRIBUTE_NAME});
            Assert.assertEquals((long)100000L, (long)((ITmfStateInterval)intervals.get(baseQuark)).getStateValue().unboxLong());
            int maxMipmapQuark = ssq.getQuarkRelative(baseQuark, new String[]{"max"});
            Assert.assertEquals((String)"max nblevels", (long)4L, (long)((ITmfStateInterval)intervals.get(maxMipmapQuark)).getStateValue().unboxInt());
            int quark = ssq.getQuarkRelative(maxMipmapQuark, new String[]{String.valueOf(1)});
            Assert.assertEquals((String)"max value @ level 1", (long)100000L, (long)((ITmfStateInterval)intervals.get(quark)).getStateValue().unboxLong());
            quark = ssq.getQuarkRelative(maxMipmapQuark, new String[]{String.valueOf(2)});
            Assert.assertEquals((String)"max value @ level 2", (long)100000L, (long)((ITmfStateInterval)intervals.get(quark)).getStateValue().unboxLong());
            quark = ssq.getQuarkRelative(maxMipmapQuark, new String[]{String.valueOf(3)});
            Assert.assertEquals((String)"max value @ level 3", (long)100000L, (long)((ITmfStateInterval)intervals.get(quark)).getStateValue().unboxLong());
            quark = ssq.getQuarkRelative(maxMipmapQuark, new String[]{String.valueOf(4)});
            Assert.assertEquals((String)"max value @ level 4", (long)100000L, (long)((ITmfStateInterval)intervals.get(quark)).getStateValue().unboxLong());
            int minMipmapQuark = ssq.getQuarkRelative(baseQuark, new String[]{"min"});
            Assert.assertEquals((String)"min nblevels", (long)4L, (long)((ITmfStateInterval)intervals.get(minMipmapQuark)).getStateValue().unboxInt());
            quark = ssq.getQuarkRelative(minMipmapQuark, new String[]{String.valueOf(1)});
            Assert.assertEquals((String)"min value @ level 1", (long)(100000L - 99999L % (long)Math.pow(16.0, 1.0)), (long)((ITmfStateInterval)intervals.get(quark)).getStateValue().unboxLong());
            quark = ssq.getQuarkRelative(minMipmapQuark, new String[]{String.valueOf(2)});
            Assert.assertEquals((String)"min value @ level 2", (long)(100000L - 99999L % (long)Math.pow(16.0, 2.0)), (long)((ITmfStateInterval)intervals.get(quark)).getStateValue().unboxLong());
            quark = ssq.getQuarkRelative(minMipmapQuark, new String[]{String.valueOf(3)});
            Assert.assertEquals((String)"min value @ level 3", (long)(100000L - 99999L % (long)Math.pow(16.0, 3.0)), (long)((ITmfStateInterval)intervals.get(quark)).getStateValue().unboxLong());
            quark = ssq.getQuarkRelative(minMipmapQuark, new String[]{String.valueOf(4)});
            Assert.assertEquals((String)"min value @ level 4", (long)(100000L - 99999L % (long)Math.pow(16.0, 4.0)), (long)((ITmfStateInterval)intervals.get(quark)).getStateValue().unboxLong());
            int avgMipmapQuark = ssq.getQuarkRelative(baseQuark, new String[]{"avg"});
            Assert.assertEquals((String)"avg nblevels", (long)4L, (long)((ITmfStateInterval)intervals.get(avgMipmapQuark)).getStateValue().unboxInt());
            quark = ssq.getQuarkRelative(avgMipmapQuark, new String[]{String.valueOf(1)});
            Assert.assertEquals((String)"avg value @ level 1", (double)((long)(100000.0 - (double)(99999L % (long)Math.pow(16.0, 1.0)) / 2.0)), (double)((ITmfStateInterval)intervals.get(quark)).getStateValue().unboxDouble(), (double)1.0E-4);
            quark = ssq.getQuarkRelative(avgMipmapQuark, new String[]{String.valueOf(2)});
            Assert.assertEquals((String)"avg value @ level 2", (double)((long)(100000.0 - (double)(99999L % (long)Math.pow(16.0, 2.0)) / 2.0)), (double)((ITmfStateInterval)intervals.get(quark)).getStateValue().unboxDouble(), (double)1.0E-4);
            quark = ssq.getQuarkRelative(avgMipmapQuark, new String[]{String.valueOf(3)});
            Assert.assertEquals((String)"avg value @ level 3", (double)((long)(100000.0 - (double)(99999L % (long)Math.pow(16.0, 3.0)) / 2.0)), (double)((ITmfStateInterval)intervals.get(quark)).getStateValue().unboxDouble(), (double)1.0E-4);
            quark = ssq.getQuarkRelative(avgMipmapQuark, new String[]{String.valueOf(4)});
            Assert.assertEquals((String)"avg value @ level 4", (double)((long)(100000.0 - (double)(99999L % (long)Math.pow(16.0, 4.0)) / 2.0)), (double)((ITmfStateInterval)intervals.get(quark)).getStateValue().unboxDouble(), (double)1.0E-4);
        }
        catch (TimeRangeException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateSystemDisposedException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testQueryMipmapRangeMax() {
        Assert.assertNotNull((Object)ssq);
        try {
            int quark = ssq.getQuarkAbsolute(new String[]{TEST_ATTRIBUTE_NAME});
            long max = TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssq, (long)0L, (long)1000L, (int)quark).unboxLong();
            Assert.assertEquals((long)1L, (long)max);
            max = TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssq, (long)1000L, (long)1000L, (int)quark).unboxLong();
            Assert.assertEquals((long)1L, (long)max);
            max = TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssq, (long)1000L, (long)50000000L, (int)quark).unboxLong();
            Assert.assertEquals((long)50000L, (long)max);
            max = TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssq, (long)0L, (long)100000000L, (int)quark).unboxLong();
            Assert.assertEquals((long)100000L, (long)max);
            max = TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssq, (long)50000000L, (long)100000000L, (int)quark).unboxLong();
            Assert.assertEquals((long)100000L, (long)max);
            max = TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssq, (long)500L, (long)50000500L, (int)quark).unboxLong();
            Assert.assertEquals((long)50000L, (long)max);
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (TimeRangeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testQueryMipmapRangeMin() {
        Assert.assertNotNull((Object)ssq);
        try {
            int quark = ssq.getQuarkAbsolute(new String[]{TEST_ATTRIBUTE_NAME});
            long min = TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssq, (long)0L, (long)1000L, (int)quark).unboxLong();
            Assert.assertEquals((long)1L, (long)min);
            min = TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssq, (long)1000L, (long)1000L, (int)quark).unboxLong();
            Assert.assertEquals((long)1L, (long)min);
            min = TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssq, (long)1000L, (long)50000000L, (int)quark).unboxLong();
            Assert.assertEquals((long)1L, (long)min);
            min = TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssq, (long)0L, (long)100000000L, (int)quark).unboxLong();
            Assert.assertEquals((long)1L, (long)min);
            min = TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssq, (long)50000000L, (long)100000000L, (int)quark).unboxLong();
            Assert.assertEquals((long)50000L, (long)min);
            min = TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssq, (long)500L, (long)50000500L, (int)quark).unboxLong();
            Assert.assertEquals((long)1L, (long)min);
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (TimeRangeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testQueryMipmapRangeAvg() {
        Assert.assertNotNull((Object)ssq);
        try {
            int quark = ssq.getQuarkAbsolute(new String[]{TEST_ATTRIBUTE_NAME});
            double avg = TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssq, (long)0L, (long)1000L, (int)quark);
            Assert.assertEquals((double)0.0, (double)avg, (double)1.0E-4);
            avg = TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssq, (long)1000L, (long)1000L, (int)quark);
            Assert.assertEquals((double)1.0, (double)avg, (double)1.0E-4);
            avg = TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssq, (long)1000L, (long)50000000L, (int)quark);
            Assert.assertEquals((double)25000.0, (double)avg, (double)1.0E-4);
            avg = TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssq, (long)0L, (long)100000000L, (int)quark);
            Assert.assertEquals((double)49999.5, (double)avg, (double)1.0E-4);
            avg = TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssq, (long)50000000L, (long)100000000L, (int)quark);
            Assert.assertEquals((double)74999.5, (double)avg, (double)1.0E-4);
            avg = TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssq, (long)500L, (long)50000500L, (int)quark);
            Assert.assertEquals((double)25000.0, (double)avg, (double)1.0E-4);
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (TimeRangeException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

