/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.datastore.core.tests.historytree;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.datastore.core.interval.HTInterval;
import org.eclipse.tracecompass.datastore.core.tests.historytree.HtTestUtils;
import org.eclipse.tracecompass.datastore.core.tests.stubs.historytree.HistoryTreeStub;
import org.eclipse.tracecompass.internal.datastore.core.historytree.HtIo;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.HTNode;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.IHTNode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HtIoTest {
    private static final int BLOCKSIZE = 4096;
    private static final int NB_CHILDREN = 3;
    private @Nullable HtIo<HTInterval, HTNode<HTInterval>> fHtIo;
    private @Nullable File fStateFile;

    @Before
    public void setUp() throws IOException {
        File file = File.createTempFile("tmp", null);
        Assert.assertNotNull((Object)file);
        this.fStateFile = file;
        this.fHtIo = new HtIo(file, 4096, 3, true, HtTestUtils.READ_FACTORY, HistoryTreeStub.NODE_FACTORY);
    }

    @After
    public void cleanUp() {
        HtIo<HTInterval, HTNode<HTInterval>> htIo = this.fHtIo;
        if (htIo != null) {
            htIo.deleteFile();
        }
    }

    private static HTNode<HTInterval> createCoreNode(int seqNum, int parentNum) {
        HTNode node = HistoryTreeStub.NODE_FACTORY.createNode(IHTNode.NodeType.CORE, 4096, 3, seqNum, parentNum, 0L);
        return node;
    }

    private static HTNode<HTInterval> createLeafNode(int seqNum, int parentNum) {
        HTNode node = HistoryTreeStub.NODE_FACTORY.createNode(IHTNode.NodeType.LEAF, 4096, 3, seqNum, parentNum, 0L);
        return node;
    }

    @Test
    public void testReadWriteNode() throws IOException {
        HtIo htio = this.fHtIo;
        Assert.assertNotNull(htio);
        int coreNodeSeqNum = 0;
        int leafNodeSeqNum = 1;
        HTNode<HTInterval> coreNode = HtIoTest.createCoreNode(coreNodeSeqNum, -1);
        Assert.assertFalse((boolean)HtIo.isInCache(htio, (int)coreNodeSeqNum));
        htio.writeNode(coreNode);
        Assert.assertTrue((boolean)HtIo.isInCache(htio, (int)coreNodeSeqNum));
        HTNode<HTInterval> leafNode = HtIoTest.createLeafNode(leafNodeSeqNum, coreNodeSeqNum);
        Assert.assertFalse((boolean)HtIo.isInCache(htio, (int)leafNodeSeqNum));
        htio.writeNode(leafNode);
        Assert.assertTrue((boolean)HtIo.isInCache(htio, (int)leafNodeSeqNum));
        HTNode coreRead = htio.readNode(coreNodeSeqNum);
        Assert.assertEquals(coreNode, (Object)coreRead);
        HTNode leafRead = htio.readNode(leafNodeSeqNum);
        Assert.assertEquals(leafNode, (Object)leafRead);
        HtIo.clearCache();
        Assert.assertFalse((boolean)HtIo.isInCache(htio, (int)coreNodeSeqNum));
        coreRead = htio.readNode(coreNodeSeqNum);
        Assert.assertEquals(coreNode, (Object)coreRead);
        Assert.assertTrue((boolean)HtIo.isInCache(htio, (int)coreNodeSeqNum));
        Assert.assertFalse((boolean)HtIo.isInCache(htio, (int)leafNodeSeqNum));
        leafRead = htio.readNode(leafNodeSeqNum);
        Assert.assertEquals(leafNode, (Object)leafRead);
        Assert.assertTrue((boolean)HtIo.isInCache(htio, (int)leafNodeSeqNum));
        htio.closeFile();
        Assert.assertNotNull((Object)this.fStateFile);
        this.fHtIo = htio = new HtIo(this.fStateFile, 4096, 3, false, HtTestUtils.READ_FACTORY, HistoryTreeStub.NODE_FACTORY);
        Assert.assertFalse((boolean)HtIo.isInCache((HtIo)htio, (int)coreNodeSeqNum));
        coreRead = htio.readNode(coreNodeSeqNum);
        Assert.assertEquals(coreNode, (Object)coreRead);
        Assert.assertFalse((boolean)HtIo.isInCache((HtIo)htio, (int)leafNodeSeqNum));
        leafRead = htio.readNode(leafNodeSeqNum);
        Assert.assertEquals(leafNode, (Object)leafRead);
        Assert.assertTrue((boolean)HtIo.isInCache((HtIo)htio, (int)coreNodeSeqNum));
        coreRead = htio.readNode(coreNodeSeqNum);
        Assert.assertEquals(coreNode, (Object)coreRead);
        Assert.assertTrue((boolean)HtIo.isInCache((HtIo)htio, (int)leafNodeSeqNum));
        leafRead = htio.readNode(leafNodeSeqNum);
        Assert.assertEquals(leafNode, (Object)leafRead);
    }

    @Test
    public void testExtraDataSave() throws IOException {
        this.writeBufferAtNodePos(2);
    }

    @Test
    public void testHeaderDataSave() throws IOException {
        this.writeBufferAtNodePos(-1);
    }

    @Test
    public void testTooFarData() throws IOException {
        this.writeBufferAtNodePos(6);
    }

    private void writeBufferAtNodePos(int nodeOffset) throws IOException {
        HtIo htio = this.fHtIo;
        Assert.assertNotNull(htio);
        int coreNodeSeqNum = 0;
        int leafNodeSeqNum = 1;
        HTNode<HTInterval> coreNode = HtIoTest.createCoreNode(coreNodeSeqNum, -1);
        Assert.assertFalse((boolean)HtIo.isInCache(htio, (int)coreNodeSeqNum));
        htio.writeNode(coreNode);
        Assert.assertTrue((boolean)HtIo.isInCache(htio, (int)coreNodeSeqNum));
        HTNode<HTInterval> leafNode = HtIoTest.createLeafNode(leafNodeSeqNum, coreNodeSeqNum);
        Assert.assertFalse((boolean)HtIo.isInCache(htio, (int)leafNodeSeqNum));
        htio.writeNode(leafNode);
        Assert.assertTrue((boolean)HtIo.isInCache(htio, (int)leafNodeSeqNum));
        ByteBuffer buffer = ByteBuffer.allocate(12);
        buffer.putInt(32);
        buffer.putInt(33);
        buffer.putInt(232);
        buffer.flip();
        Throwable throwable = null;
        Object var9_10 = null;
        try (FileOutputStream fcOut = htio.getFileWriter(nodeOffset);){
            fcOut.write(buffer.array());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        htio.closeFile();
        Assert.assertNotNull((Object)this.fStateFile);
        this.fHtIo = htio = new HtIo(this.fStateFile, 4096, 3, false, HtTestUtils.READ_FACTORY, HistoryTreeStub.NODE_FACTORY);
        byte[] bytes = new byte[12];
        htio.supplyATReader(nodeOffset).read(bytes);
        buffer = ByteBuffer.wrap(bytes);
        Assert.assertEquals((long)32L, (long)buffer.getInt());
        Assert.assertEquals((long)33L, (long)buffer.getInt());
        Assert.assertEquals((long)232L, (long)buffer.getInt());
    }
}

