/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.trace.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;

public class TextTraceEventContent
implements ITmfEventField {
    private final @NonNull String fName;
    private final @NonNull List<TextTraceEventContent> fFields;
    private @Nullable Object fValue;

    public TextTraceEventContent(String @NonNull [] fieldNames) {
        this.fName = ":root:";
        this.fValue = null;
        this.fFields = new ArrayList<TextTraceEventContent>(fieldNames.length);
        String[] stringArray = fieldNames;
        int n = fieldNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            if (fieldName == null) {
                throw new IllegalArgumentException("Null field name not allowed");
            }
            this.fFields.add(new TextTraceEventContent(fieldName));
            ++n2;
        }
    }

    public TextTraceEventContent(int initialCapacity) {
        this.fName = ":root:";
        this.fValue = null;
        this.fFields = new ArrayList<TextTraceEventContent>(initialCapacity);
    }

    private TextTraceEventContent(@NonNull String fieldName) {
        this.fName = fieldName;
        this.fValue = null;
        this.fFields = Collections.emptyList();
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public Object getValue() {
        return this.fValue;
    }

    public List<String> getFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>(this.fFields.size());
        for (TextTraceEventContent field : this.fFields) {
            fieldNames.add(field.getName());
        }
        return fieldNames;
    }

    public List<TextTraceEventContent> getFields() {
        return new ArrayList<TextTraceEventContent>(this.fFields);
    }

    @Override
    public ITmfEventField getField(String ... path) {
        if (path.length == 0) {
            return this;
        }
        if (path.length == 1) {
            for (TextTraceEventContent field : this.fFields) {
                if (!field.getName().equals(path[0])) continue;
                return field;
            }
        }
        return null;
    }

    @Override
    public String getFormattedValue() {
        Object value = this.fValue;
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public String getFieldName(int index) {
        if (index >= 0 && index < this.fFields.size()) {
            return this.fFields.get(index).getName();
        }
        return null;
    }

    public ITmfEventField getField(int index) {
        if (index >= 0 && index < this.fFields.size()) {
            return this.fFields.get(index);
        }
        return null;
    }

    public Object getFieldValue(@NonNull String name) {
        int i = 0;
        while (i < this.fFields.size()) {
            if (this.fFields.get(i).getName().equals(name)) {
                return this.fFields.get(i).getValue();
            }
            ++i;
        }
        return null;
    }

    public Object getFieldValue(int index) {
        if (index >= 0 && index < this.fFields.size()) {
            return this.fFields.get(index).getValue();
        }
        return null;
    }

    public void setValue(Object value) {
        this.fValue = value;
    }

    public void setFieldValue(@NonNull String name, Object value) {
        TextTraceEventContent field = null;
        int i = 0;
        while (i < this.fFields.size()) {
            if (this.fFields.get(i).getName().equals(name)) {
                field = this.fFields.get(i);
                field.setValue(value);
            }
            ++i;
        }
        if (field == null) {
            field = new TextTraceEventContent(name);
            field.setValue(value);
            this.fFields.add(field);
        }
    }

    public void setFieldValue(int index, Object value) {
        if (index >= 0 && index < this.fFields.size()) {
            this.fFields.get((int)index).fValue = value;
        }
    }

    public void addField(@NonNull String name, Object value) {
        TextTraceEventContent field = new TextTraceEventContent(name);
        field.setValue(value);
        this.fFields.add(field);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fFields.hashCode();
        result = 31 * result + this.fName.hashCode();
        int tmpHash = 0;
        Object value = this.fValue;
        if (value != null) {
            tmpHash = value instanceof StringBuffer ? value.toString().hashCode() : value.hashCode();
        }
        result = 31 * result + tmpHash;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextTraceEventContent other = (TextTraceEventContent)obj;
        if (!this.fFields.equals(other.fFields)) {
            return false;
        }
        if (!this.fName.equals(other.fName)) {
            return false;
        }
        Object value = this.fValue;
        if (value == null) {
            if (other.fValue != null) {
                return false;
            }
        } else if (value instanceof StringBuffer && other.fValue instanceof StringBuffer) {
            Object otherValue = other.getValue();
            if (otherValue == null) {
                return false;
            }
            if (!value.toString().equals(otherValue.toString())) {
                return false;
            }
        } else if (!value.equals(other.fValue)) {
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.fName == ":root:") {
            int i = 0;
            while (i < this.getFields().size()) {
                ITmfEventField field = (ITmfEventField)this.getFields().get(i);
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(field.toString());
                ++i;
            }
        } else {
            sb.append(this.fName);
            sb.append('=');
            sb.append(this.fValue);
        }
        return sb.toString();
    }
}

