/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ExclusionInclusionDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.RemoveLinkedFolderDialog;
import org.eclipse.wst.jsdt.ui.wizards.BuildPathDialogAccess;

public class ClasspathModifierQueries {
    public static IInclusionExclusionQuery getDefaultInclusionExclusionQuery(final Shell shell) {
        return new IInclusionExclusionQuery(){
            protected IPath[] fInclusionPattern;
            protected IPath[] fExclusionPattern;

            @Override
            public boolean doQuery(final CPListElement element, final boolean focusOnExcluded) {
                final boolean[] result = new boolean[1];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell sh = shell != null ? shell : JavaScriptPlugin.getActiveWorkbenchShell();
                        ExclusionInclusionDialog dialog = new ExclusionInclusionDialog(sh, element, focusOnExcluded);
                        result[0] = dialog.open() == 0;
                        fInclusionPattern = dialog.getInclusionPattern();
                        fExclusionPattern = dialog.getExclusionPattern();
                    }
                });
                return result[0];
            }

            @Override
            public IPath[] getInclusionPattern() {
                return this.fInclusionPattern;
            }

            @Override
            public IPath[] getExclusionPattern() {
                return this.fExclusionPattern;
            }
        };
    }

    public static IAddArchivesQuery getDefaultArchivesQuery(final Shell shell) {
        return new IAddArchivesQuery(){

            @Override
            public IPath[] doQuery() {
                final IPath[][] selected = new IPath[1][];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell sh = shell != null ? shell : JavaScriptPlugin.getActiveWorkbenchShell();
                        selected[0] = BuildPathDialogAccess.chooseExternalJAREntries(sh);
                    }
                });
                if (selected[0] == null) {
                    return new IPath[0];
                }
                return selected[0];
            }
        };
    }

    public static IRemoveLinkedFolderQuery getDefaultRemoveLinkedFolderQuery(final Shell shell) {
        return new IRemoveLinkedFolderQuery(){

            @Override
            public final int doQuery(final IFolder folder) {
                final int[] result = new int[]{1};
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public final void run() {
                        RemoveLinkedFolderDialog dialog = new RemoveLinkedFolderDialog(shell != null ? shell : JavaScriptPlugin.getActiveWorkbenchShell(), folder);
                        int status = dialog.open();
                        result[0] = status == 0 ? dialog.getRemoveStatus() : 0;
                    }
                });
                return result[0];
            }
        };
    }

    public static IAddLibrariesQuery getDefaultLibrariesQuery(final Shell shell) {
        return new IAddLibrariesQuery(){

            @Override
            public IIncludePathEntry[] doQuery(final IJavaScriptProject project, final IIncludePathEntry[] entries) {
                final IIncludePathEntry[][] selected = new IIncludePathEntry[1][];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell sh = shell != null ? shell : JavaScriptPlugin.getActiveWorkbenchShell();
                        selected[0] = BuildPathDialogAccess.chooseContainerEntries(sh, project, entries);
                    }
                });
                if (selected[0] == null) {
                    return new IIncludePathEntry[0];
                }
                return selected[0];
            }
        };
    }

    public static ICreateFolderQuery getDefaultCreateFolderQuery(final Shell shell, final IJavaScriptProject project) {
        return new ICreateFolderQuery(){
            private IFolder fNewFolder;

            @Override
            public boolean doQuery() {
                final boolean[] isOK = new boolean[1];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell sh = shell != null ? shell : JavaScriptPlugin.getActiveWorkbenchShell();
                        NewFolderDialog dialog = new NewFolderDialog(sh, (IContainer)project.getProject());
                        boolean bl = isOK[0] = dialog.open() == 0;
                        if (isOK[0]) {
                            IResource sourceContainer = (IResource)dialog.getResult()[0];
                            if (sourceContainer instanceof IFolder) {
                                fNewFolder = (IFolder)sourceContainer;
                            } else {
                                fNewFolder = null;
                            }
                        }
                    }
                });
                return isOK[0];
            }

            @Override
            public boolean isSourceFolder() {
                return true;
            }

            @Override
            public IFolder getCreatedFolder() {
                return this.fNewFolder;
            }
        };
    }

    public static interface IAddArchivesQuery {
        public IPath[] doQuery();
    }

    public static interface IAddLibrariesQuery {
        public IIncludePathEntry[] doQuery(IJavaScriptProject var1, IIncludePathEntry[] var2);
    }

    public static interface ICreateFolderQuery {
        public boolean doQuery();

        public boolean isSourceFolder();

        public IFolder getCreatedFolder();
    }

    public static interface IInclusionExclusionQuery {
        public boolean doQuery(CPListElement var1, boolean var2);

        public IPath[] getInclusionPattern();

        public IPath[] getExclusionPattern();
    }

    public static interface IRemoveLinkedFolderQuery {
        public static final int REMOVE_CANCEL = 0;
        public static final int REMOVE_BUILD_PATH = 1;
        public static final int REMOVE_BUILD_PATH_AND_FOLDER = 2;

        public int doQuery(IFolder var1);
    }
}

