/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.ui;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.internal.operations.IOperationHandler;
import org.eclipse.wst.common.frameworks.internal.ui.ListMessageDialog;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;

public class UIOperationHandler
implements IOperationHandler {
    protected Shell parentShell;
    public static final String DEFAULT_INFORMATION = "Information";
    public static final String DEFAULT_ERROR = "Error";
    public static final String DEFAULT_CONFIRM = "Confirm";
    protected String informationTitle = "Information";
    protected String confirmTitle = "Confirm";
    protected String errorTitle = "Error";

    public UIOperationHandler() {
    }

    public UIOperationHandler(Shell parent) {
        this.parentShell = parent;
    }

    public boolean canContinue(String message) {
        return MessageDialog.openQuestion((Shell)this.getParentShell(), (String)this.getConfirmTitle(), (String)message);
    }

    public boolean canContinue(String message, String[] items) {
        return ListMessageDialog.openQuestion(this.getParentShell(), this.getConfirmTitle(), message, items);
    }

    public int canContinueWithAllCheck(String message) {
        MessageDialog dialog = new MessageDialog(this.getParentShell(), this.getConfirmTitle(), null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL}, 1);
        return dialog.open();
    }

    public int canContinueWithAllCheckAllowCancel(String message) {
        MessageDialog dialog = new MessageDialog(this.getParentShell(), this.getConfirmTitle(), null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
        return dialog.open();
    }

    public void error(String message) {
        MessageDialog.openError((Shell)this.getParentShell(), (String)this.getErrorTitle(), (String)message);
    }

    public String getConfirmTitle() {
        return this.confirmTitle;
    }

    public String getErrorTitle() {
        return this.errorTitle;
    }

    public String getInformationTitle() {
        return this.informationTitle;
    }

    public Shell getParentShell() {
        if (this.parentShell == null) {
            this.parentShell = WTPUIPlugin.getPluginWorkbench().getActiveWorkbenchWindow().getShell();
        }
        return this.parentShell;
    }

    public void inform(String message) {
        MessageDialog.openInformation((Shell)this.getParentShell(), (String)this.getInformationTitle(), (String)message);
    }

    public void setConfirmTitle(String newConfirmTitle) {
        this.confirmTitle = newConfirmTitle;
    }

    public void setErrorTitle(String newErrorTitle) {
        this.errorTitle = newErrorTitle;
    }

    public void setInformationTitle(String newInformationTitle) {
        this.informationTitle = newInformationTitle;
    }

    public Object getContext() {
        return this.getParentShell();
    }
}

