/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.model.BinaryContainerInfo;
import org.eclipse.cdt.internal.core.model.BinaryRunner;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CProject;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.util.MementoTokenizer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class BinaryContainer
extends Openable
implements IBinaryContainer {
    public BinaryContainer(CProject cProject) {
        super(cProject, null, CCorePlugin.getResourceString("CoreModel.BinaryContainer.Binaries"), 30);
    }

    void sync() {
        BinaryRunner runner = CModelManager.getDefault().getBinaryRunner(this.getCProject());
        if (runner != null) {
            runner.waitIfRunning();
        }
    }

    @Override
    public IBinary[] getBinaries() throws CModelException {
        this.sync();
        ICElement[] e = this.getChildren();
        ArrayList<IBinary> list = new ArrayList<IBinary>(e.length);
        ICElement[] iCElementArray = e;
        int n = e.length;
        int n2 = 0;
        while (n2 < n) {
            IBinary bin;
            ICElement element = iCElementArray[n2];
            if (element instanceof IBinary && (bin = (IBinary)element).showInBinaryContainer()) {
                list.add(bin);
            }
            ++n2;
        }
        IBinary[] b = new IBinary[list.size()];
        list.toArray(b);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CElementInfo getElementInfo(IProgressMonitor monitor) throws CModelException {
        CModelManager manager;
        CModelManager cModelManager = manager = CModelManager.getDefault();
        synchronized (cModelManager) {
            CElementInfo info = (CElementInfo)manager.getInfo(this);
            if (info != null) {
                return info;
            }
            info = this.createElementInfo();
            this.openWhenClosed(info, monitor);
            return info;
        }
    }

    @Override
    public CElementInfo createElementInfo() {
        return new BinaryContainerInfo(this);
    }

    @Override
    protected boolean buildStructure(OpenableInfo info, IProgressMonitor pm, Map<ICElement, CElementInfo> newElements, IResource underlyingResource) throws CModelException {
        CModelManager.getDefault().getBinaryRunner(this.getCProject());
        return true;
    }

    @Override
    public ICElement getHandleFromMemento(String token, MementoTokenizer memento) {
        return null;
    }

    @Override
    public String getHandleMemento() {
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        Assert.isTrue((boolean)false, (String)"Should not be called");
        return '\u0000';
    }
}

