/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.commands.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.core.commands.ITerminateHandler;
import org.eclipse.debug.internal.core.commands.Request;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.ui.actions.DebugCommandAction;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class TerminateAndRemoveAction
extends DebugCommandAction {
    private boolean fCanTerminate = false;
    private IWorkbenchPart fMyPart = null;

    @Override
    public String getText() {
        return ActionMessages.TerminateAndRemoveAction_0;
    }

    @Override
    public String getHelpContextId() {
        return "org.eclipse.debug.ui.terminate_and_remove_action_context";
    }

    @Override
    public String getId() {
        return "org.eclipse.debug.ui.debugview.popupMenu.terminateAndRemove";
    }

    @Override
    public String getToolTipText() {
        return ActionMessages.TerminateAndRemoveAction_3;
    }

    @Override
    public ImageDescriptor getDisabledImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_DLCL_TERMINATE_AND_REMOVE");
    }

    @Override
    public ImageDescriptor getHoverImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_ELCL_TERMINATE_AND_REMOVE");
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_ELCL_TERMINATE_AND_REMOVE");
    }

    protected Class<ITerminateHandler> getCommandType() {
        return ITerminateHandler.class;
    }

    @Override
    public void debugContextChanged(DebugContextEvent event) {
        boolean isAllTerminated = true;
        ISelection context = event.getContext();
        if (context instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)context) {
                if (this.isTerminated(element)) continue;
                isAllTerminated = false;
                break;
            }
        }
        boolean bl = this.fCanTerminate = !isAllTerminated;
        if (isAllTerminated) {
            this.setEnabled(!context.isEmpty());
        } else {
            super.debugContextChanged(event);
        }
    }

    protected boolean isTerminated(Object element) {
        ILaunch launch = DebugUIPlugin.getLaunch(element);
        if (launch != null) {
            return launch.isTerminated();
        }
        return false;
    }

    @Override
    protected void postExecute(IRequest request, Object[] targets) {
        IStatus status = request.getStatus();
        if (status == null || status.isOK()) {
            Object[] objectArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                Object target = objectArray[n2];
                ILaunch launch = DebugUIPlugin.getLaunch(target);
                if (launch != null) {
                    DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                }
                ++n2;
            }
        }
    }

    @Override
    public void runWithEvent(Event event) {
        if (this.fCanTerminate) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null && !MessageDialog.openQuestion((Shell)window.getShell(), (String)DebugUIViewsMessages.LaunchView_Terminate_and_Remove_1, (String)DebugUIViewsMessages.LaunchView_Terminate_and_remove_selected__2)) {
                return;
            }
            super.runWithEvent(event);
        } else {
            ISelection sel = null;
            sel = this.fMyPart != null ? this.getDebugContextService().getActiveContext(this.fMyPart.getSite().getId()) : this.getDebugContextService().getActiveContext();
            if (sel instanceof IStructuredSelection) {
                IStructuredSelection ss = (IStructuredSelection)sel;
                this.postExecute((IRequest)new Request(), ss.toArray());
            }
        }
    }

    @Override
    public void init(IWorkbenchPart part) {
        super.init(part);
        this.fMyPart = part;
    }
}

