/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.ast.tag;

import org.eclipse.cdt.core.dom.ast.tag.IWritableTag;

public class Tag
implements IWritableTag {
    private final String taggerId;
    private final byte[] buff;

    public Tag(String taggerId, int dataLen) {
        this.taggerId = taggerId;
        this.buff = new byte[dataLen];
    }

    @Override
    public String getTaggerId() {
        return this.taggerId;
    }

    @Override
    public int getDataLen() {
        return this.buff.length;
    }

    private boolean isInBounds(int offset, int len) {
        return offset >= 0 && offset < this.buff.length && offset + len <= this.buff.length;
    }

    @Override
    public boolean putByte(int offset, byte b) {
        if (!this.isInBounds(offset, 1)) {
            return false;
        }
        this.buff[offset] = b;
        return true;
    }

    @Override
    public boolean putBytes(int offset, byte[] data, int len) {
        int n = len = len >= 0 ? len : data.length;
        if (!this.isInBounds(offset, len)) {
            return false;
        }
        System.arraycopy(data, 0, this.buff, offset, len);
        return true;
    }

    @Override
    public int getByte(int offset) {
        return this.isInBounds(offset, 1) ? this.buff[offset] : -1;
    }

    @Override
    public byte[] getBytes(int offset, int len) {
        int n = len = len >= 0 ? len : this.buff.length - offset;
        if (!this.isInBounds(offset, len)) {
            return null;
        }
        byte[] data = new byte[len];
        System.arraycopy(this.buff, offset, data, 0, len);
        return data;
    }
}

