/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser;

import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.format.DecimalUnitFormat;
import org.eclipse.tracecompass.common.core.format.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.FilterSimpleExpression;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.FilterSimpleExpressionNotCu;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.IFilterCu;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterAspectNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterCompareNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterContainsNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterEqualsNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterMatchesNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterOrNode;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class FilterSimpleExpressionCu
implements IFilterCu {
    private static final Format DECIMAL_FORMAT = new DecimalUnitFormat();
    private final String fField;
    private final String fOperator;
    private final @Nullable String fValue;

    public FilterSimpleExpressionCu(String field, String op, @Nullable String value) {
        this.fField = field;
        this.fOperator = op;
        this.fValue = value;
    }

    protected String getField() {
        return this.fField;
    }

    protected String getOperator() {
        return this.fOperator;
    }

    protected @Nullable String getValue() {
        return this.fValue;
    }

    public static @Nullable FilterSimpleExpressionCu compile(CommonTree tree) {
        if (tree.getToken() == null) {
            return null;
        }
        int childCount = tree.getChildCount();
        switch (tree.getToken().getType()) {
            case 4: 
            case 15: {
                StringBuilder paragraph = new StringBuilder();
                FilterSimpleExpressionCu.extractParagraph(tree, paragraph, 0, childCount);
                return new FilterSimpleExpressionCu("*", "matches", paragraph.toString().trim());
            }
            case 7: {
                String left = Objects.requireNonNull(tree.getChild(0).getText());
                String op = Objects.requireNonNull(tree.getChild(1).getText());
                String right = tree.getChild(2).getText();
                return new FilterSimpleExpressionCu(left, op, right);
            }
            case 8: {
                String left1 = Objects.requireNonNull(tree.getChild(0).getText());
                String op1 = Objects.requireNonNull(tree.getChild(1).getText());
                String right1 = null;
                return new FilterSimpleExpressionCu(left1, op1, right1);
            }
            case 9: 
            case 11: 
            case 12: {
                StringBuilder builder = new StringBuilder();
                int index = FilterSimpleExpressionCu.extractParagraph(tree, builder, 0, childCount);
                String left2 = builder.toString().trim();
                String op2 = Objects.requireNonNull(tree.getChild(index++).getText());
                builder = new StringBuilder();
                FilterSimpleExpressionCu.extractParagraph(tree, builder, index, childCount);
                String right2 = builder.toString().trim();
                return new FilterSimpleExpressionCu(left2, op2, right2);
            }
            case 10: {
                StringBuilder builder1 = new StringBuilder();
                int index1 = FilterSimpleExpressionCu.extractParagraph(tree, builder1, 0, childCount);
                String left3 = builder1.toString().trim();
                String op3 = Objects.requireNonNull(tree.getChild(index1).getText());
                String right3 = null;
                return new FilterSimpleExpressionCu(left3, op3, right3);
            }
            case 17: {
                if (childCount == 0 || childCount == 2 && tree.getChild(1).getType() != 4) {
                    return null;
                }
                boolean negate = tree.getChild(0).getText().equals("!");
                CommonTree expression = Objects.requireNonNull((CommonTree)tree.getChild(childCount - 1));
                FilterSimpleExpressionCu compiled = negate ? FilterSimpleExpressionNotCu.compile(expression) : FilterSimpleExpressionCu.compile(expression);
                return compiled;
            }
        }
        return null;
    }

    private static int extractParagraph(CommonTree tree, StringBuilder builder, int index, int count) {
        String separator = " ";
        boolean stop = false;
        int i = index;
        while (i < count && !stop) {
            Tree child = tree.getChild(i);
            if (child.getType() != 19) {
                stop = true;
            } else {
                builder.append(child.getText());
                builder.append(separator);
            }
            ++i;
        }
        return --i;
    }

    public FilterSimpleExpression generate() {
        return new FilterSimpleExpression(this.fField, FilterSimpleExpressionCu.getConditionOperator(this.fOperator), this.fValue);
    }

    protected static ConditionOperator getConditionOperator(String equationType) {
        switch (equationType) {
            case "==": {
                return ConditionOperator.EQ;
            }
            case "!=": {
                return ConditionOperator.NE;
            }
            case "matches": {
                return ConditionOperator.MATCHES;
            }
            case "contains": {
                return ConditionOperator.CONTAINS;
            }
            case "present": {
                return ConditionOperator.PRESENT;
            }
            case ">": {
                return ConditionOperator.GT;
            }
            case "<": {
                return ConditionOperator.LT;
            }
        }
        throw new IllegalArgumentException("FilterSimpleExpression: invalid comparison operator.");
    }

    @Override
    public ITmfFilterTreeNode getEventFilter(ITmfTrace trace) {
        if (this.fField.equals("*")) {
            TmfFilterOrNode orNode = new TmfFilterOrNode(null);
            for (ITmfEventAspect<?> aspect : trace.getEventAspects()) {
                TmfFilterMatchesNode node = new TmfFilterMatchesNode(null);
                node.setEventAspect(aspect);
                node.setRegex(this.fValue);
                orNode.addChild(node);
            }
            orNode.setNot(this.getNot());
            return orNode;
        }
        ITmfEventAspect<Object> filterAspect = null;
        for (ITmfEventAspect<?> aspect : trace.getEventAspects()) {
            if (!aspect.getName().equals(this.fField)) continue;
            filterAspect = aspect;
            break;
        }
        if (filterAspect == null) {
            filterAspect = TmfBaseAspects.getContentsAspect().forField(this.fField);
        }
        TmfFilterAspectNode conditionNode = this.createConditionNode();
        conditionNode.setEventAspect(filterAspect);
        return conditionNode;
    }

    private TmfFilterAspectNode createConditionNode() {
        switch (this.fOperator) {
            case "==": {
                TmfFilterEqualsNode equalsNode = new TmfFilterEqualsNode(null);
                equalsNode.setValue(this.fValue);
                equalsNode.setNot(this.getNot());
                return equalsNode;
            }
            case "!=": {
                TmfFilterEqualsNode notEqualsNode = new TmfFilterEqualsNode(null);
                notEqualsNode.setValue(this.fValue);
                notEqualsNode.setNot(!this.getNot());
                return notEqualsNode;
            }
            case "matches": {
                TmfFilterMatchesNode matchesNode = new TmfFilterMatchesNode(null);
                matchesNode.setRegex(this.fValue);
                matchesNode.setNot(this.getNot());
                return matchesNode;
            }
            case "contains": {
                TmfFilterContainsNode containsNode = new TmfFilterContainsNode(null);
                containsNode.setValue(this.fValue);
                containsNode.setNot(this.getNot());
                return containsNode;
            }
            case "present": {
                TmfFilterMatchesNode presentNode = new TmfFilterMatchesNode(null);
                presentNode.setRegex(".*");
                presentNode.setNot(this.getNot());
                return presentNode;
            }
            case ">": {
                TmfFilterCompareNode gtNode = new TmfFilterCompareNode(null);
                gtNode.setResult(1);
                gtNode.setValue(this.fValue);
                gtNode.setNot(this.getNot());
                return gtNode;
            }
            case "<": {
                TmfFilterCompareNode ltNode = new TmfFilterCompareNode(null);
                ltNode.setResult(-1);
                ltNode.setValue(this.fValue);
                ltNode.setNot(this.getNot());
                return ltNode;
            }
        }
        throw new IllegalArgumentException("FilterSimpleExpression: invalid comparison operator.");
    }

    protected boolean getNot() {
        return false;
    }

    protected static enum ConditionOperator implements BiPredicate<Object, Object>
    {
        EQ((i, j) -> ConditionOperator.equals(i, j)),
        NE((i, j) -> !ConditionOperator.equals(i, j)),
        MATCHES(ConditionOperator.matchFunc()),
        CONTAINS((i, j) -> String.valueOf(i).contains(String.valueOf(j))),
        LT((i, j) -> ConditionOperator.numericalCompare(i, j) < 0),
        GT((i, j) -> ConditionOperator.numericalCompare(i, j) > 0),
        PRESENT((i, j) -> true);

        private final BiFunction<Object, Object, Boolean> fCmpFunction;

        private ConditionOperator(BiFunction<Object, Object, Boolean> cmpFunction) {
            this.fCmpFunction = cmpFunction;
        }

        private static BiFunction<Object, Object, Boolean> matchFunc() {
            return (i, j) -> {
                Pattern filterPattern = null;
                Object value = j;
                if (j instanceof Pair) {
                    Pair pair = (Pair)j;
                    if (pair.getFirst() instanceof Pattern) {
                        filterPattern = (Pattern)pair.getFirst();
                    }
                    value = pair.getSecond();
                }
                if (value instanceof Number && ConditionOperator.equals(i, value)) {
                    return true;
                }
                if (filterPattern != null) {
                    return filterPattern.matcher(String.valueOf(i)).find();
                }
                return false;
            };
        }

        private static boolean equals(Object i, Object j) {
            if (Objects.equals(i, j)) {
                return true;
            }
            if (Objects.equals(String.valueOf(i), String.valueOf(j))) {
                return true;
            }
            Number number1 = ConditionOperator.toNumber(i);
            if (number1 == null) {
                return false;
            }
            Number number2 = ConditionOperator.toNumber(j);
            if (number2 == null) {
                return false;
            }
            if (number1 instanceof Double || number2 instanceof Double || number1 instanceof Float || number2 instanceof Float) {
                return number1.doubleValue() == number2.doubleValue();
            }
            return number1.longValue() == number2.longValue();
        }

        private static int numericalCompare(Object i, Object j) {
            Number number1 = ConditionOperator.toNumber(i);
            Number number2 = ConditionOperator.toNumber(j);
            if (number2 == null || number1 == null) {
                return String.valueOf(i).compareTo(String.valueOf(j));
            }
            if (number1 instanceof Double || number2 instanceof Double || number1 instanceof Float || number2 instanceof Float) {
                return Double.compare(number1.doubleValue(), number2.doubleValue());
            }
            return Long.compare(number1.longValue(), number2.longValue());
        }

        private static @Nullable Number toNumber(Object value) {
            if (value instanceof Number) {
                return (Number)value;
            }
            String val = String.valueOf(value);
            try {
                return Long.decode(val);
            }
            catch (NumberFormatException numberFormatException) {
                ParsePosition pos = new ParsePosition(0);
                Number parsed = NumberFormat.getInstance().parse(val, pos);
                if (pos.getErrorIndex() < 0 && pos.getIndex() == val.length()) {
                    return parsed;
                }
                pos = new ParsePosition(0);
                Object parsedObj = DECIMAL_FORMAT.parseObject(val, pos);
                if (pos.getErrorIndex() < 0 && pos.getIndex() == val.length() && parsedObj instanceof Number) {
                    return (Number)parsedObj;
                }
                pos = new ParsePosition(0);
                parsedObj = SubSecondTimeWithUnitFormat.getInstance().parseObject(val, pos);
                if (pos.getErrorIndex() < 0 && pos.getIndex() == val.length() && parsedObj instanceof Number) {
                    return (Number)parsedObj;
                }
                try {
                    return TmfTimestampFormat.getDefaulTimeFormat().parseValue(val);
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
        }

        @Override
        public boolean test(Object arg0, Object arg1) {
            return Objects.requireNonNull(this.fCmpFunction.apply(arg0, arg1));
        }

        public static @Nullable Object prepareValue(ConditionOperator operator, @Nullable String value) {
            if (value == null) {
                return null;
            }
            Object parsedValue = value;
            Number number = ConditionOperator.toNumber(value);
            if (number != null) {
                parsedValue = number;
            }
            Pattern pattern = null;
            if (operator == MATCHES) {
                try {
                    pattern = Pattern.compile(String.valueOf(value));
                }
                catch (PatternSyntaxException patternSyntaxException) {}
                if (pattern != null) {
                    return new Pair<Pattern, Object>(pattern, parsedValue);
                }
            }
            return parsedValue;
        }
    }
}

