/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.verify;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.trace4cps.analysis.mtl.MtlFormula;
import org.eclipse.trace4cps.analysis.mtl.MtlResult;
import org.eclipse.trace4cps.tl.VerificationResult;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.ui.view.verify.ParameterizedCheckNode;

public class CheckNode {
    private final TraceView view;
    private long checkTime;
    private VerificationResult result;
    private MtlFormula phi;
    private String name;
    private boolean isParameterized;
    private List<ParameterizedCheckNode> subChecks = new ArrayList<ParameterizedCheckNode>();

    public CheckNode(TraceView v) {
        this.view = v;
    }

    public TraceView getTraceView() {
        return this.view;
    }

    public boolean isParameterized() {
        return this.isParameterized;
    }

    public String getCheckName() {
        return this.name;
    }

    public long getCheckTime() {
        return this.checkTime;
    }

    public MtlFormula getFormula() {
        if (this.isParameterized()) {
            throw new IllegalStateException();
        }
        return this.phi;
    }

    public List<ParameterizedCheckNode> getSubChecks() {
        if (!this.isParameterized()) {
            throw new IllegalStateException();
        }
        return this.subChecks;
    }

    public MtlResult getMTLresult() {
        if (this.isParameterized()) {
            throw new IllegalStateException();
        }
        return this.result.getResult(this.phi);
    }

    public VerificationResult getResult() {
        if (this.isParameterized()) {
            throw new IllegalStateException();
        }
        return this.result;
    }

    public void set(long timeStamp, MtlFormula phi, VerificationResult res) {
        this.checkTime = timeStamp;
        this.name = res.getName(phi);
        this.isParameterized = res.isQuantifiedCheck(phi);
        if (!res.isQuantifiedCheck(phi)) {
            this.phi = phi;
            this.result = res;
        } else {
            this.subChecks.add(new ParameterizedCheckNode(phi, res, this.view));
            Collections.sort(this.subChecks, new Comparator<ParameterizedCheckNode>(){

                @Override
                public int compare(ParameterizedCheckNode o1, ParameterizedCheckNode o2) {
                    return o1.getCheckName().compareTo(o2.getCheckName());
                }
            });
        }
    }
}

