/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.javadoc;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.eclipse.jdt.core.manipulation.internal.javadoc.CoreJavaDoc2HTMLTextReader;

abstract class AbstractJavaDocConverter {
    private CoreJavaDoc2HTMLTextReader reader;
    private boolean read;
    private String result;

    public AbstractJavaDocConverter(Reader reader) {
        this.setJavaDoc2HTMLTextReader(reader);
    }

    public AbstractJavaDocConverter(String javadoc) {
        this.setJavaDoc2HTMLTextReader(javadoc == null ? null : new StringReader(javadoc));
    }

    private void setJavaDoc2HTMLTextReader(Reader reader) {
        this.reader = reader == null || reader instanceof CoreJavaDoc2HTMLTextReader ? (CoreJavaDoc2HTMLTextReader)reader : this.createHTMLTextReader(reader);
    }

    private CoreJavaDoc2HTMLTextReader createHTMLTextReader(Reader r) {
        return new CoreJavaDoc2HTMLTextReader(r){

            protected String getPrintSingleDefinitionStartTags() {
                return "<li>";
            }

            protected String getPrintSingleDefinitionEndTags() {
                return "</li>";
            }

            protected void print(StringBuilder buffer, String tag, List<String> elements, boolean firstword) {
                if (!elements.isEmpty()) {
                    buffer.append("<li><b>");
                    buffer.append(tag);
                    buffer.append("</b><ul>");
                    this.printDefinitions(buffer, elements, firstword);
                    buffer.append("</ul></li>");
                }
            }

            protected void print(StringBuilder buffer, String tag, String content) {
                if (content != null) {
                    buffer.append("<li><b>");
                    buffer.append(tag);
                    buffer.append("</b><ul><li>");
                    buffer.append(content);
                    buffer.append("</li></ul></li>");
                }
            }

            protected void printRest(StringBuilder buffer, List<CoreJavaDoc2HTMLTextReader.Pair> rest) {
                if (!rest.isEmpty()) {
                    for (CoreJavaDoc2HTMLTextReader.Pair p : rest) {
                        buffer.append("<li>");
                        if (p.fTag() != null) {
                            buffer.append(p.fTag());
                        }
                        buffer.append("<ul><li>");
                        if (p.fContent() != null) {
                            buffer.append(p.fContent());
                        }
                        buffer.append("</li></ul></li>");
                    }
                }
            }

            protected String printSimpleTag(List<CoreJavaDoc2HTMLTextReader.Pair> rest) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("<ul>");
                this.printTagAttributes(buffer);
                this.printRest(buffer, rest);
                buffer.append("</ul>");
                return buffer.toString();
            }
        };
    }

    public String getAsString() throws IOException {
        if (!this.read && this.reader != null) {
            String rawHtml = this.reader.getString();
            this.result = this.convert(rawHtml);
        }
        return this.result;
    }

    public Reader getAsReader() throws IOException {
        String m = this.getAsString();
        return m == null ? null : new StringReader(m);
    }

    abstract String convert(String var1);
}

