/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.gradle.plugin;

import com.microsoft.java.bs.gradle.model.SupportedLanguages;
import com.microsoft.java.bs.gradle.plugin.JavaLanguageModelBuilder;
import com.microsoft.java.bs.gradle.plugin.LanguageModelBuilder;
import com.microsoft.java.bs.gradle.plugin.ScalaLanguageModelBuilder;
import com.microsoft.java.bs.gradle.plugin.SourceSetsModelBuilder;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class GradleBuildServerPlugin
implements Plugin<Project> {
    public static final List<LanguageModelBuilder> SUPPORTED_LANGUAGE_BUILDERS = new LinkedList<LanguageModelBuilder>();
    private final ToolingModelBuilderRegistry registry;

    @Inject
    public GradleBuildServerPlugin(ToolingModelBuilderRegistry registry) {
        this.registerSupportedLanguages();
        this.registry = registry;
    }

    public void apply(Project project) {
        this.registry.register((ToolingModelBuilder)new SourceSetsModelBuilder());
    }

    private void registerSupportedLanguages() {
        String supportedLanguagesProps = System.getProperty("bsp.gradle.supportedLanguages");
        if (supportedLanguagesProps != null) {
            String[] supportedLanguages;
            for (String language : supportedLanguages = supportedLanguagesProps.split(",")) {
                if (language.equalsIgnoreCase(SupportedLanguages.JAVA.getBspName())) {
                    SUPPORTED_LANGUAGE_BUILDERS.add(new JavaLanguageModelBuilder());
                    continue;
                }
                if (!language.equalsIgnoreCase(SupportedLanguages.SCALA.getBspName())) continue;
                SUPPORTED_LANGUAGE_BUILDERS.add(new ScalaLanguageModelBuilder());
            }
        }
    }
}

