/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gradle.compile;

import com.microsoft.gradle.compile.GradleCompilationUnit;
import com.microsoft.gradle.utils.LSPUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.SymbolKind;

public class DocumentSymbolVisitor {
    private URI currentUri;
    private Map<URI, List<DocumentSymbol>> documentSymbols = new HashMap<URI, List<DocumentSymbol>>();
    private Map<URI, List<DocumentSymbol>> dependencies = new HashMap<URI, List<DocumentSymbol>>();

    public List<DocumentSymbol> getDocumentSymbols(URI uri) {
        return this.documentSymbols.get(uri);
    }

    public List<DocumentSymbol> getDependencies(URI uri) {
        return this.dependencies.get(uri);
    }

    public void visitCompilationUnit(URI uri, GradleCompilationUnit compilationUnit) {
        this.currentUri = uri;
        compilationUnit.iterator().forEachRemaining(unit -> this.visitSourceUnit(uri, (SourceUnit)unit));
    }

    public void visitSourceUnit(URI uri, SourceUnit unit) {
        ModuleNode moduleNode = unit.getAST();
        if (moduleNode != null) {
            this.documentSymbols.put(uri, new ArrayList());
            this.dependencies.put(uri, new ArrayList());
            this.visitModule(moduleNode);
        }
    }

    public void visitModule(ModuleNode node) {
        BlockStatement blockStatement = node.getStatementBlock();
        List statements = blockStatement.getStatements();
        for (Statement statement : statements) {
            DocumentSymbol symbol;
            if (!(statement instanceof ExpressionStatement) || (symbol = this.getDocumentSymbol((ExpressionStatement)statement)) == null) continue;
            this.documentSymbols.get(this.currentUri).add(symbol);
        }
    }

    public DocumentSymbol getDocumentSymbol(ExpressionStatement statement) {
        Expression expression = statement.getExpression();
        DocumentSymbol symbol = null;
        if (expression instanceof MethodCallExpression) {
            symbol = this.getDocumentSymbol((MethodCallExpression)expression);
        } else if (expression instanceof BinaryExpression) {
            symbol = this.getDocumentSymbol((BinaryExpression)expression);
        }
        if (symbol == null || symbol.getName() == null) {
            return null;
        }
        return symbol;
    }

    private DocumentSymbol getDocumentSymbol(BinaryExpression expression) {
        Expression left = expression.getLeftExpression();
        Expression right = expression.getRightExpression();
        DocumentSymbol symbol = new DocumentSymbol();
        symbol.setName(left.getText());
        if (right instanceof ConstantExpression) {
            symbol.setDetail(right.getText());
        }
        symbol.setKind(SymbolKind.Property);
        symbol.setRange(LSPUtils.toRange((Expression)expression));
        symbol.setSelectionRange(LSPUtils.toRange((Expression)expression));
        return symbol;
    }

    private DocumentSymbol getDocumentSymbol(MethodCallExpression expression) {
        DocumentSymbol symbol = new DocumentSymbol();
        symbol.setKind(SymbolKind.Function);
        String name = this.getSymbolName(expression);
        if (name == null) {
            return null;
        }
        symbol.setName(name);
        String detail = this.getSymbolDetail(expression);
        if (detail != null) {
            symbol.setDetail(detail);
        }
        symbol.setSelectionRange(LSPUtils.toRange((Expression)expression));
        symbol.setRange(LSPUtils.toRange((Expression)expression));
        if (expression.getMethodAsString().equals("dependencies")) {
            List<DocumentSymbol> dependencySymbols = this.getDependencies(expression);
            symbol.setChildren(dependencySymbols);
            this.dependencies.get(this.currentUri).addAll(dependencySymbols);
        }
        return symbol;
    }

    private String getSymbolName(MethodCallExpression expression) {
        Expression objectExpression = expression.getObjectExpression();
        if (objectExpression instanceof VariableExpression) {
            StringBuilder builder = new StringBuilder();
            String objectText = objectExpression.getText();
            if (!objectText.equals("this")) {
                builder.append(objectText);
                builder.append(".");
            }
            builder.append(expression.getMethodAsString());
            Expression arguments = expression.getArguments();
            if (arguments instanceof ArgumentListExpression) {
                List expressions = ((ArgumentListExpression)arguments).getExpressions();
                for (Expression exp : expressions) {
                    if (!(exp instanceof MethodCallExpression)) continue;
                    builder.append(" ");
                    builder.append(this.getSymbolName((MethodCallExpression)exp));
                }
            }
            return builder.toString();
        }
        if (objectExpression instanceof PropertyExpression) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getSymbolName((PropertyExpression)objectExpression));
            builder.append(".");
            builder.append(expression.getMethodAsString());
            return builder.toString();
        }
        return null;
    }

    private String getSymbolName(PropertyExpression expression) {
        Expression objectExpression = expression.getObjectExpression();
        Expression property = expression.getProperty();
        StringBuilder builder = new StringBuilder();
        if (objectExpression instanceof PropertyExpression) {
            builder.append(this.getSymbolName((PropertyExpression)objectExpression));
        } else if (objectExpression instanceof VariableExpression) {
            builder.append(objectExpression.getText());
        }
        if (property instanceof ConstantExpression) {
            builder.append(".");
            builder.append(property.getText());
        }
        return builder.toString();
    }

    private String getSymbolDetail(MethodCallExpression expression) {
        List arguments;
        Expression argument = expression.getArguments();
        if (argument instanceof ArgumentListExpression) {
            List arguments2 = ((ArgumentListExpression)argument).getExpressions();
            if (!arguments2.isEmpty() && arguments2.get(0) instanceof ConstantExpression) {
                return ((Expression)arguments2.get(0)).getText();
            }
            return null;
        }
        if (argument instanceof TupleExpression && !(arguments = ((TupleExpression)argument).getExpressions()).isEmpty() && arguments.get(0) instanceof NamedArgumentListExpression) {
            MapEntryExpression firstExpression;
            NamedArgumentListExpression namedArgumentListExpression = (NamedArgumentListExpression)arguments.get(0);
            List mapEntryExpressions = namedArgumentListExpression.getMapEntryExpressions();
            if (!mapEntryExpressions.isEmpty() && (firstExpression = (MapEntryExpression)mapEntryExpressions.get(0)).getValueExpression() instanceof ConstantExpression) {
                StringBuilder detail = new StringBuilder();
                detail.append(firstExpression.getKeyExpression().getText());
                detail.append(": ");
                detail.append(firstExpression.getValueExpression().getText());
                return detail.toString();
            }
            return null;
        }
        return null;
    }

    private List<DocumentSymbol> getDependencies(MethodCallExpression expression) {
        Expression argument = expression.getArguments();
        if (expression.getMethodAsString().equals("dependencies")) {
            return this.getDependencies((ArgumentListExpression)argument);
        }
        ArrayList<DocumentSymbol> results = new ArrayList<DocumentSymbol>();
        DocumentSymbol symbol = new DocumentSymbol();
        String name = expression.getMethodAsString();
        symbol.setName(name);
        String detail = this.getDetail(expression);
        if (detail != null) {
            symbol.setDetail(detail);
        }
        symbol.setKind(SymbolKind.Constant);
        symbol.setRange(LSPUtils.toRange((Expression)expression));
        symbol.setSelectionRange(LSPUtils.toRange((Expression)expression));
        results.add(symbol);
        return results;
    }

    private List<DocumentSymbol> getDependencies(ArgumentListExpression argumentListExpression) {
        List expressions = argumentListExpression.getExpressions();
        ArrayList<DocumentSymbol> symbols = new ArrayList<DocumentSymbol>();
        for (Expression expression : expressions) {
            if (expression instanceof ClosureExpression) {
                symbols.addAll(this.getDependencies((ClosureExpression)expression));
                continue;
            }
            if (!(expression instanceof MethodCallExpression)) continue;
            symbols.addAll(this.getDependencies((MethodCallExpression)expression));
        }
        return symbols;
    }

    private List<DocumentSymbol> getDependencies(ClosureExpression expression) {
        Statement code = expression.getCode();
        if (code instanceof BlockStatement) {
            return this.getDependencies((BlockStatement)code);
        }
        return Collections.emptyList();
    }

    private List<DocumentSymbol> getDependencies(BlockStatement blockStatement) {
        List statements = blockStatement.getStatements();
        ArrayList<DocumentSymbol> symbols = new ArrayList<DocumentSymbol>();
        for (Statement statement : statements) {
            if (!(statement instanceof ExpressionStatement)) continue;
            symbols.addAll(this.getDependencies((ExpressionStatement)statement));
        }
        return symbols;
    }

    private List<DocumentSymbol> getDependencies(ExpressionStatement expressionStatement) {
        Expression expression = expressionStatement.getExpression();
        ArrayList<DocumentSymbol> symbols = new ArrayList<DocumentSymbol>();
        if (expression instanceof MethodCallExpression) {
            symbols.addAll(this.getDependencies((MethodCallExpression)expression));
        }
        return symbols;
    }

    private String getDetail(MethodCallExpression node) {
        Expression arguments = node.getArguments();
        if (arguments instanceof ArgumentListExpression) {
            List expressions = ((ArgumentListExpression)arguments).getExpressions();
            for (Expression expression : expressions) {
                if (expression instanceof MethodCallExpression) {
                    return this.getDetail((MethodCallExpression)expression);
                }
                if (!(expression instanceof GStringExpression) && !(expression instanceof ConstantExpression)) continue;
                return expression.getText();
            }
        }
        return null;
    }
}

