/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;

public class JavacCompilationResult
extends CompilationResult {
    private Set<String[]> javacQualifiedReferences = new TreeSet<String[]>((a, b) -> Arrays.compare((Comparable[])a, (Comparable[])b));
    private Set<String> javacSimpleNameReferences = new TreeSet<String>();
    private Set<String> javacRootReferences = new TreeSet<String>();
    private boolean isMigrated = false;
    private List<CategorizedProblem> unusedMembers = null;
    private List<CategorizedProblem> unusedImports = null;

    public JavacCompilationResult(ICompilationUnit compilationUnit) {
        this(compilationUnit, 0, 0, Integer.MAX_VALUE);
    }

    public JavacCompilationResult(ICompilationUnit compilationUnit, int unitIndex, int totalUnitsKnown, int maxProblemPerUnit) {
        super(compilationUnit, unitIndex, totalUnitsKnown, maxProblemPerUnit);
    }

    public boolean addQualifiedReference(String[] qualifiedReference) {
        return this.javacQualifiedReferences.add(qualifiedReference);
    }

    public boolean addSimpleNameReference(String simpleNameReference) {
        return this.javacSimpleNameReferences.add(simpleNameReference);
    }

    public boolean addRootReference(String rootReference) {
        return this.javacRootReferences.add(rootReference);
    }

    public void migrateReferenceInfo() {
        if (this.isMigrated) {
            return;
        }
        this.simpleNameReferences = (char[][])this.javacSimpleNameReferences.stream().map(String::toCharArray).toArray(x$0 -> new char[x$0][]);
        this.rootReferences = (char[][])this.javacRootReferences.stream().map(String::toCharArray).toArray(x$0 -> new char[x$0][]);
        this.qualifiedReferences = (char[][][])this.javacQualifiedReferences.stream().map(qualifiedNames -> (char[][])Stream.of(qualifiedNames).map(String::toCharArray).toArray(x$0 -> new char[x$0][])).toArray(x$0 -> new char[x$0][][]);
        this.javacSimpleNameReferences.clear();
        this.javacRootReferences.clear();
        this.javacQualifiedReferences.clear();
        this.isMigrated = true;
    }

    public void setUnusedImports(List<CategorizedProblem> newUnusedImports) {
        this.unusedImports = newUnusedImports;
    }

    public void addUnusedMembers(List<CategorizedProblem> problems) {
        if (this.unusedMembers == null) {
            this.unusedMembers = new ArrayList<CategorizedProblem>();
        }
        this.unusedMembers.addAll(problems);
    }

    public List<CategorizedProblem> getAdditionalProblems() {
        if (this.unusedMembers == null && this.unusedImports == null) {
            return null;
        }
        ArrayList<CategorizedProblem> problems = new ArrayList<CategorizedProblem>();
        if (this.unusedImports != null) {
            problems.addAll(this.unusedImports);
        }
        if (this.unusedMembers != null) {
            problems.addAll(this.unusedMembers);
        }
        return problems;
    }
}

