/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.internal.preferences.PersistentModel;
import org.eclipse.buildship.core.internal.util.file.FileUtils;
import org.eclipse.buildship.core.internal.workspace.PersistentModelBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.gradle.tooling.model.eclipse.EclipseLinkedResource;

final class LinkedResourcesUpdater {
    private final IProject project;
    private final ImmutableList<EclipseLinkedResource> resources;
    private final ImmutableSet<IPath> resourcePaths;

    private LinkedResourcesUpdater(IProject project, List<EclipseLinkedResource> list) {
        this.project = (IProject)Preconditions.checkNotNull((Object)project);
        ImmutableList.Builder resources = ImmutableList.builder();
        ImmutableSet.Builder resourcePaths = ImmutableSet.builder();
        for (EclipseLinkedResource linkedResource : list) {
            if (!LinkedResourcesUpdater.isSupportedLinkedResource(linkedResource)) continue;
            resources.add((Object)linkedResource);
            resourcePaths.add((Object)new Path(linkedResource.getLocation()));
        }
        this.resources = resources.build();
        this.resourcePaths = resourcePaths.build();
    }

    private static boolean isSupportedLinkedResource(EclipseLinkedResource linkedResource) {
        return linkedResource.getLocation() != null;
    }

    private void updateLinkedResources(PersistentModelBuilder persistentModel, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        this.removeOutdatedLinkedResources(persistentModel, progress.newChild(1));
        this.createLinkedResources(persistentModel, progress.newChild(1));
    }

    private void removeOutdatedLinkedResources(PersistentModelBuilder persistentModel, SubMonitor progress) throws CoreException {
        PersistentModel previousModel = persistentModel.getPrevious();
        Collection<Object> linkedPaths = previousModel.isPresent() ? previousModel.getLinkedResources() : Collections.emptyList();
        progress.setWorkRemaining(linkedPaths.size());
        for (IPath iPath : linkedPaths) {
            SubMonitor childProgress = progress.newChild(1);
            IResource linkedResource = this.project.findMember(iPath);
            if (!this.shouldDelete(linkedResource)) continue;
            linkedResource.delete(false, (IProgressMonitor)childProgress);
        }
    }

    private boolean shouldDelete(IResource resource) {
        return resource != null && this.linkedWithValidLocation(resource) && !this.partOfCurrentGradleModel(resource);
    }

    private boolean linkedWithValidLocation(IResource resource) {
        return resource.exists() && resource.isLinked() && resource.getLocation() != null;
    }

    private boolean partOfCurrentGradleModel(IResource resource) {
        return this.resourcePaths.contains((Object)resource.getProjectRelativePath());
    }

    private void createLinkedResources(PersistentModelBuilder persistentModel, SubMonitor progress) throws CoreException {
        progress.setWorkRemaining(this.resources.size());
        HashSet linkedPaths = Sets.newHashSet();
        for (EclipseLinkedResource linkedFile : this.resources) {
            SubMonitor childProgress = progress.newChild(1);
            IResource file = this.createLinkedResource(linkedFile, childProgress);
            linkedPaths.add(file.getProjectRelativePath());
        }
        persistentModel.linkedResources(linkedPaths);
    }

    private IResource createLinkedResource(EclipseLinkedResource linkedResource, SubMonitor progress) throws CoreException {
        String name = linkedResource.getName();
        String type = linkedResource.getType();
        Path path = new Path(linkedResource.getLocation());
        if ("1".equals(type)) {
            IFile file = this.project.getFile(name);
            FileUtils.ensureParentFolderHierarchyExists((IResource)file);
            file.createLink((IPath)path, 400, (IProgressMonitor)progress);
            return file;
        }
        if ("2".equals(type)) {
            IFolder folder = this.project.getFolder(name);
            FileUtils.ensureParentFolderHierarchyExists((IResource)folder);
            folder.createLink((IPath)path, 400, (IProgressMonitor)progress);
            return folder;
        }
        throw new GradlePluginsRuntimeException("Unknows linked resource type: " + type);
    }

    public static void update(IProject project, List<EclipseLinkedResource> linkedResources, PersistentModelBuilder persistentModel, IProgressMonitor monitor) throws CoreException {
        LinkedResourcesUpdater updater = new LinkedResourcesUpdater(project, linkedResources);
        updater.updateLinkedResources(persistentModel, monitor);
    }
}

