/*
 * Decompiled with CFR 0.152.
 */
package com.github.badsyntax.gradle.handlers;

import com.github.badsyntax.gradle.ErrorMessageBuilder;
import com.github.badsyntax.gradle.StopDaemonReply;
import com.github.badsyntax.gradle.StopDaemonRequest;
import com.github.badsyntax.gradle.process.Process;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopDaemonHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)StopDaemonHandler.class.getName());
    private StopDaemonRequest req;
    private StreamObserver<StopDaemonReply> responseObserver;

    public StopDaemonHandler(StopDaemonRequest req, StreamObserver<StopDaemonReply> responseObserver) {
        this.req = req;
        this.responseObserver = responseObserver;
    }

    public void run() {
        try {
            Process.kill(this.req.getPid());
            this.replyWithSuccess(String.format("Killed daemon with PID %s", this.req.getPid()));
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            this.replyWithError(e);
        }
    }

    private void replyWithError(Exception e) {
        this.responseObserver.onError((Throwable)ErrorMessageBuilder.build(e));
    }

    private void replyWithSuccess(String message) {
        this.responseObserver.onNext((Object)StopDaemonReply.newBuilder().setMessage(message).build());
        this.responseObserver.onCompleted();
    }
}

