/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildoption;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.cli.CommandLineOption;
import org.gradle.cli.CommandLineParser;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.Origin;
import org.gradle.internal.buildoption.PropertyOrigin;

public abstract class AbstractBuildOption<T, V extends CommandLineOptionConfiguration>
implements BuildOption<T> {
    protected final PropertyOrigin propertyOrigin;
    protected final String property;
    protected final List<V> commandLineOptionConfigurations;
    protected final String deprecatedProperty;

    public AbstractBuildOption(String property) {
        this(property, (String)null, PropertyOrigin.GRADLE_PROPERTIES, Collections.emptyList());
    }

    public AbstractBuildOption(String property, String deprecatedProperty, V ... commandLineOptionConfiguration) {
        this(property, deprecatedProperty, PropertyOrigin.GRADLE_PROPERTIES, commandLineOptionConfiguration != null ? Arrays.asList(commandLineOptionConfiguration) : Collections.emptyList());
    }

    public AbstractBuildOption(String property, V ... commandLineOptionConfiguration) {
        this(property, (String)null, PropertyOrigin.GRADLE_PROPERTIES, commandLineOptionConfiguration != null ? Arrays.asList(commandLineOptionConfiguration) : Collections.emptyList());
    }

    public AbstractBuildOption(String property, PropertyOrigin propertyOrigin) {
        this(property, (String)null, propertyOrigin, Collections.emptyList());
    }

    public AbstractBuildOption(String property, String deprecatedProperty, PropertyOrigin propertyOrigin, V ... commandLineOptionConfiguration) {
        this(property, deprecatedProperty, propertyOrigin, commandLineOptionConfiguration != null ? Arrays.asList(commandLineOptionConfiguration) : Collections.emptyList());
    }

    public AbstractBuildOption(String property, PropertyOrigin propertyOrigin, V ... commandLineOptionConfiguration) {
        this(property, (String)null, propertyOrigin, commandLineOptionConfiguration != null ? Arrays.asList(commandLineOptionConfiguration) : Collections.emptyList());
    }

    private AbstractBuildOption(String property, String deprecatedProperty, PropertyOrigin propertyOrigin, List<V> commandLineOptionConfigurations) {
        this.property = property;
        this.deprecatedProperty = deprecatedProperty;
        this.propertyOrigin = propertyOrigin;
        this.commandLineOptionConfigurations = commandLineOptionConfigurations;
    }

    @Override
    public String getProperty() {
        return this.property;
    }

    @Override
    public String getDeprecatedProperty() {
        return this.deprecatedProperty;
    }

    protected boolean isTrue(String value) {
        return value != null && value.trim().equalsIgnoreCase("true");
    }

    protected CommandLineOption configureCommandLineOption(CommandLineParser parser, String[] options, String description, boolean deprecated, boolean incubating) {
        CommandLineOption option = parser.option(options).hasDescription(description);
        if (deprecated) {
            option.deprecated();
        }
        if (incubating) {
            option.incubating();
        }
        return option;
    }

    protected OptionValue<String> getFromProperties(Map<String, String> properties) {
        String value = properties.get(this.property);
        if (value != null) {
            return new OptionValue<String>(value, this.property, this.propertyOrigin);
        }
        if (this.deprecatedProperty != null && (value = properties.get(this.deprecatedProperty)) != null) {
            return new OptionValue<String>(value, this.deprecatedProperty, this.propertyOrigin);
        }
        return new OptionValue<Object>(null, null, this.propertyOrigin);
    }

    protected static class OptionValue<T> {
        private final T value;
        private final Origin origin;

        public OptionValue(T value, String property, PropertyOrigin propertyOrigin) {
            this.value = value;
            this.origin = propertyOrigin.toOrigin(property);
        }

        public T getValue() {
            return this.value;
        }

        public Origin getOrigin() {
            return this.origin;
        }
    }
}

