/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;

public class EqualityVisitor
extends ClassCodeVisitorSupport {
    private final ASTNode nodeToLookFor;
    private boolean nodeFound;

    public EqualityVisitor(ASTNode nodeToLookFor) {
        this.nodeToLookFor = nodeToLookFor;
    }

    public boolean doVisit(ASTNode toVisit) {
        toVisit.visit(this);
        return this.nodeFound;
    }

    @Override
    public void visitFieldExpression(FieldExpression expression) {
        if (this.nodeToLookFor == expression) {
            this.nodeFound = true;
        } else {
            super.visitFieldExpression(expression);
        }
    }

    @Override
    public void visitVariableExpression(VariableExpression expression) {
        if (this.nodeToLookFor == expression) {
            this.nodeFound = true;
        } else {
            super.visitVariableExpression(expression);
        }
    }

    @Override
    public void visitConstantExpression(ConstantExpression expression) {
        if (this.nodeToLookFor == expression) {
            this.nodeFound = true;
        } else {
            super.visitConstantExpression(expression);
        }
    }

    public static boolean checkForAssignment(ASTNode node, BinaryExpression binaryExpr) {
        return binaryExpr != null && new EqualityVisitor(node).doVisit(binaryExpr.getLeftExpression());
    }
}

