/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Stream;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTagElement;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ExportsDirective;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.ImplicitTypeDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.ModuleModifier;
import org.eclipse.jdt.core.dom.ModulePackageAccess;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.OpensDirective;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.ProvidesDirective;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.RequiresDirective;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.UsesDirective;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.compiler.env.IElementInfo;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.RecoveryScanner;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.core.AnnotatableInfo;
import org.eclipse.jdt.internal.core.Annotation;
import org.eclipse.jdt.internal.core.AnnotationInfo;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.jdt.internal.core.ImportContainer;
import org.eclipse.jdt.internal.core.ImportContainerInfo;
import org.eclipse.jdt.internal.core.ImportDeclaration;
import org.eclipse.jdt.internal.core.ImportDeclarationElementInfo;
import org.eclipse.jdt.internal.core.Initializer;
import org.eclipse.jdt.internal.core.InitializerWithChildrenInfo;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.MemberValuePair;
import org.eclipse.jdt.internal.core.ModuleDescriptionInfo;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageDeclaration;
import org.eclipse.jdt.internal.core.SourceAnnotationMethodInfo;
import org.eclipse.jdt.internal.core.SourceConstructorWithChildrenInfo;
import org.eclipse.jdt.internal.core.SourceField;
import org.eclipse.jdt.internal.core.SourceFieldElementInfo;
import org.eclipse.jdt.internal.core.SourceFieldWithChildrenInfo;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.core.SourceMethodElementInfo;
import org.eclipse.jdt.internal.core.SourceMethodWithChildrenInfo;
import org.eclipse.jdt.internal.core.SourceModule;
import org.eclipse.jdt.internal.core.SourceRefElement;
import org.eclipse.jdt.internal.core.SourceRefElementInfo;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.TypeParameter;
import org.eclipse.jdt.internal.core.TypeParameterElementInfo;
import org.eclipse.jdt.internal.core.util.Util;

public class DOMToModelPopulator
extends ASTVisitor {
    private final Map<IJavaElement, IElementInfo> toPopulate;
    private final Stack<JavaElement> elements = new Stack();
    private final Stack<JavaElementInfo> infos = new Stack();
    private final Set<String> currentTypeParameters = new HashSet<String>();
    private final Map<SourceType, Integer> nestedTypesCount = new HashMap<SourceType, Integer>();
    private final CompilationUnitElementInfo unitInfo;
    private ImportContainer importContainer;
    private ImportContainerInfo importContainerInfo;
    private final CompilationUnit root;
    private Boolean alternativeDeprecated = null;

    public DOMToModelPopulator(Map<IJavaElement, IElementInfo> newElements, CompilationUnit root, CompilationUnitElementInfo unitInfo) {
        this.toPopulate = newElements;
        this.elements.push(root);
        this.infos.push(unitInfo);
        this.root = root;
        this.unitInfo = unitInfo;
    }

    private void addAsChild(JavaElementInfo parentInfo, IJavaElement childElement) {
        if (childElement instanceof SourceRefElement) {
            IJavaElement parent;
            SourceType anonymousType;
            SourceRefElement element = (SourceRefElement)childElement;
            while (Stream.of(parentInfo.getChildren()).filter(other -> other.getElementType() == element.getElementType()).filter(other -> Objects.equals(other.getHandleIdentifier(), element.getHandleIdentifier())).findAny().isPresent()) {
                element.incOccurrenceCount();
            }
            if (childElement instanceof SourceType && (anonymousType = (SourceType)childElement).isAnonymous() && (parent = element.getParent().getAncestor(7)) instanceof SourceType) {
                SourceType nestType = (SourceType)parent;
                anonymousType.localOccurrenceCount = this.nestedTypesCount.compute(nestType, (nest, currentCount) -> currentCount == null ? 1 : currentCount + 1);
            }
        }
        if (parentInfo instanceof AnnotatableInfo) {
            AnnotatableInfo annotable = (AnnotatableInfo)parentInfo;
            if (childElement instanceof IAnnotation) {
                IAnnotation annotation = (IAnnotation)childElement;
                if (Stream.of(annotable.annotations).noneMatch(annotation::equals)) {
                    IAnnotation[] newAnnotations = Arrays.copyOf(annotable.annotations, annotable.annotations.length + 1);
                    newAnnotations[newAnnotations.length - 1] = annotation;
                    annotable.annotations = newAnnotations;
                }
                return;
            }
        }
        if (childElement instanceof TypeParameter) {
            TypeParameter typeParam = (TypeParameter)childElement;
            if (parentInfo instanceof SourceTypeElementInfo) {
                SourceTypeElementInfo type = (SourceTypeElementInfo)parentInfo;
                type.typeParameters = Arrays.copyOf(type.typeParameters, type.typeParameters.length + 1);
                type.typeParameters[type.typeParameters.length - 1] = typeParam;
                return;
            }
            if (parentInfo instanceof SourceMethodElementInfo) {
                SourceMethodElementInfo method = (SourceMethodElementInfo)parentInfo;
                method.typeParameters = Arrays.copyOf(method.typeParameters, method.typeParameters.length + 1);
                method.typeParameters[method.typeParameters.length - 1] = typeParam;
                return;
            }
        }
        if (parentInfo instanceof ImportContainerInfo) {
            ImportContainerInfo current = (ImportContainerInfo)parentInfo;
            if (childElement instanceof ImportDeclaration) {
                ImportDeclaration importDecl = (ImportDeclaration)childElement;
                IJavaElement[] newImports = Arrays.copyOf(current.getChildren(), current.getChildren().length + 1);
                newImports[newImports.length - 1] = importDecl;
                current.children = newImports;
                return;
            }
        }
        if (parentInfo instanceof SourceTypeElementInfo) {
            SourceTypeElementInfo type = (SourceTypeElementInfo)parentInfo;
            type.children = Arrays.copyOf(type.children, type.children.length + 1);
            type.children[type.children.length - 1] = childElement;
            return;
        }
        if (parentInfo instanceof OpenableElementInfo) {
            OpenableElementInfo openable = (OpenableElementInfo)parentInfo;
            openable.addChild(childElement);
            return;
        }
        if (parentInfo instanceof SourceMethodElementInfo) {
            LocalVariable variable;
            SourceMethodElementInfo method = (SourceMethodElementInfo)parentInfo;
            if (childElement instanceof LocalVariable && (variable = (LocalVariable)childElement).isParameter()) {
                ILocalVariable[] parameters = method.arguments != null ? Arrays.copyOf(method.arguments, method.arguments.length + 1) : new ILocalVariable[1];
                parameters[parameters.length - 1] = variable;
                method.arguments = parameters;
                return;
            }
        }
        if (parentInfo instanceof SourceMethodWithChildrenInfo) {
            SourceMethodWithChildrenInfo method = (SourceMethodWithChildrenInfo)parentInfo;
            IJavaElement[] newElements = Arrays.copyOf(method.children, method.children.length + 1);
            newElements[newElements.length - 1] = childElement;
            method.children = newElements;
            return;
        }
        if (parentInfo instanceof SourceFieldWithChildrenInfo) {
            SourceFieldWithChildrenInfo field = (SourceFieldWithChildrenInfo)parentInfo;
            IJavaElement[] newElements = Arrays.copyOf(field.children, field.children.length + 1);
            newElements[newElements.length - 1] = childElement;
            field.children = newElements;
            return;
        }
        if (parentInfo instanceof SourceConstructorWithChildrenInfo) {
            SourceConstructorWithChildrenInfo constructor = (SourceConstructorWithChildrenInfo)parentInfo;
            IJavaElement[] newElements = Arrays.copyOf(constructor.children, constructor.children.length + 1);
            newElements[newElements.length - 1] = childElement;
            constructor.children = newElements;
            return;
        }
        if (parentInfo instanceof InitializerWithChildrenInfo) {
            InitializerWithChildrenInfo info = (InitializerWithChildrenInfo)parentInfo;
            IJavaElement[] newElements = Arrays.copyOf(info.getChildren(), info.getChildren().length + 1);
            newElements[newElements.length - 1] = childElement;
            info.children = newElements;
            return;
        }
    }

    @Override
    public boolean visit(org.eclipse.jdt.core.dom.CompilationUnit node) {
        this.unitInfo.setSourceLength(node.getLength());
        return true;
    }

    @Override
    public boolean visit(org.eclipse.jdt.core.dom.PackageDeclaration node) {
        PackageDeclaration newElement = new PackageDeclaration(this.root, node.getName().toString());
        this.elements.push(newElement);
        this.addAsChild(this.infos.peek(), newElement);
        AnnotatableInfo newInfo = new AnnotatableInfo();
        DOMToModelPopulator.setSourceRange(newInfo, node);
        newInfo.setNameSourceStart(node.getName().getStartPosition());
        newInfo.setNameSourceEnd(node.getName().getStartPosition() + node.getName().getLength() - 1);
        this.infos.push(newInfo);
        this.toPopulate.put(newElement, newInfo);
        return true;
    }

    @Override
    public void endVisit(org.eclipse.jdt.core.dom.PackageDeclaration decl) {
        this.elements.pop();
        this.infos.pop();
    }

    @Override
    public boolean visit(org.eclipse.jdt.core.dom.ImportDeclaration node) {
        if (this.importContainer == null) {
            this.importContainer = this.root.getImportContainer();
            this.importContainerInfo = new ImportContainerInfo();
            JavaElementInfo parentInfo = this.infos.peek();
            this.addAsChild(parentInfo, this.importContainer);
            this.toPopulate.put(this.importContainer, this.importContainerInfo);
        }
        ImportDeclaration newElement = new ImportDeclaration(this.importContainer, node.getName().toString(), node.isOnDemand());
        this.elements.push(newElement);
        this.addAsChild(this.importContainerInfo, newElement);
        ImportDeclarationElementInfo newInfo = new ImportDeclarationElementInfo();
        DOMToModelPopulator.setSourceRange(newInfo, node);
        newInfo.setNameSourceStart(node.getName().getStartPosition());
        int nameSourceEnd = node.getName().getStartPosition() + node.getName().getLength() - 1;
        if (node.isOnDemand()) {
            nameSourceEnd = node.getStartPosition() + node.getLength() - 1;
            char[] contents = this.root.getContents();
            List comments = DOMToModelPopulator.domUnit(node).getCommentList();
            boolean changed = false;
            while (true) {
                if (contents[nameSourceEnd] == ';' || Character.isWhitespace(contents[nameSourceEnd])) {
                    --nameSourceEnd;
                    changed = true;
                    continue;
                }
                int currentEnd = nameSourceEnd;
                int newEnd = comments.stream().filter(comment -> comment.getStartPosition() <= currentEnd && comment.getStartPosition() + comment.getLength() >= currentEnd).findAny().map(comment -> comment.getStartPosition() - 1).orElse(currentEnd);
                changed = currentEnd != newEnd;
                nameSourceEnd = newEnd;
                if (nameSourceEnd <= 0 || !changed) break;
            }
        }
        newInfo.setNameSourceEnd(nameSourceEnd);
        newInfo.setFlags(node.isStatic() ? 8 : 0);
        this.infos.push(newInfo);
        this.toPopulate.put(newElement, newInfo);
        return true;
    }

    @Override
    public void endVisit(org.eclipse.jdt.core.dom.ImportDeclaration decl) {
        this.elements.pop();
        this.infos.pop();
    }

    @Override
    public boolean visit(ImplicitTypeDeclaration node) {
        SourceType newElement = new SourceType(this.elements.peek(), this.root.getElementName().endsWith(".java") ? this.root.getElementName().substring(0, this.root.getElementName().length() - 5) : this.root.getElementName());
        this.elements.push(newElement);
        this.addAsChild(this.infos.peek(), newElement);
        SourceTypeElementInfo newInfo = new SourceTypeElementInfo();
        newInfo.setFlags(0x20000000);
        DOMToModelPopulator.setSourceRange(newInfo, node);
        newInfo.setHandle(newElement);
        this.infos.push(newInfo);
        this.toPopulate.put(newElement, newInfo);
        return true;
    }

    @Override
    public void endVisit(ImplicitTypeDeclaration node) {
        this.elements.pop();
        this.infos.pop();
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        char[][] permitted;
        char[][] superInterfaces;
        if ("module-info.java".equals(this.root.getElementName())) {
            return false;
        }
        if (node.getAST().apiLevel() > 2) {
            node.typeParameters().stream().map(org.eclipse.jdt.core.dom.TypeParameter::getName).map(Name::getFullyQualifiedName).forEach(this.currentTypeParameters::add);
        }
        SourceType newElement = new SourceType(this.elements.peek(), node.getName().toString());
        this.elements.push(newElement);
        this.addAsChild(this.infos.peek(), newElement);
        SourceTypeElementInfo newInfo = new SourceTypeElementInfo();
        boolean isDeprecated = this.isNodeDeprecated(node);
        char[][] categories = this.getCategories(node);
        newInfo.addCategories(newElement, categories);
        JavaElementInfo toPopulateCategories = this.infos.peek();
        while (toPopulateCategories != null) {
            if (!(toPopulateCategories instanceof SourceTypeElementInfo)) break;
            SourceTypeElementInfo parentTypeInfo = (SourceTypeElementInfo)toPopulateCategories;
            parentTypeInfo.addCategories(newElement, categories);
            toPopulateCategories = (JavaElementInfo)parentTypeInfo.getEnclosingType();
        }
        if (node.getAST().apiLevel() > 2 && (superInterfaces = (char[][])node.superInterfaceTypes().stream().map(ASTNode::toString).map(String::toCharArray).toArray(n -> new char[n][])).length > 0) {
            newInfo.setSuperInterfaceNames(superInterfaces);
        }
        if (node.getAST().apiLevel() > 2 && node.getSuperclassType() != null) {
            newInfo.setSuperclassName(node.getSuperclassType().toString().toCharArray());
        }
        if (node.getAST().apiLevel() >= 17 && (permitted = (char[][])node.permittedTypes().stream().map(ASTNode::toString).map(String::toCharArray).toArray(n -> new char[n][])).length > 0) {
            newInfo.setPermittedSubtypeNames(permitted);
        }
        DOMToModelPopulator.setSourceRange(newInfo, node);
        newInfo.setFlags(DOMToModelPopulator.toModelFlags(node.getModifiers(), isDeprecated) | (node.isInterface() ? 512 : 0));
        newInfo.setHandle(newElement);
        newInfo.setNameSourceStart(node.getName().getStartPosition());
        newInfo.setNameSourceEnd(node.getName().getStartPosition() + node.getName().getLength() - 1);
        this.infos.push(newInfo);
        this.toPopulate.put(newElement, newInfo);
        return true;
    }

    @Override
    public void endVisit(TypeDeclaration decl) {
        this.elements.pop();
        this.infos.pop();
        if (decl.getAST().apiLevel() > 2) {
            decl.typeParameters().stream().map(org.eclipse.jdt.core.dom.TypeParameter::getName).map(Name::getFullyQualifiedName).forEach(this.currentTypeParameters::remove);
        }
    }

    @Override
    public boolean visit(AnnotationTypeDeclaration node) {
        SourceType newElement = new SourceType(this.elements.peek(), node.getName().toString());
        this.elements.push(newElement);
        this.addAsChild(this.infos.peek(), newElement);
        SourceTypeElementInfo newInfo = new SourceTypeElementInfo();
        DOMToModelPopulator.setSourceRange(newInfo, node);
        char[][] categories = this.getCategories(node);
        newInfo.addCategories(newElement, categories);
        JavaElementInfo toPopulateCategories = this.infos.peek();
        while (toPopulateCategories != null) {
            if (!(toPopulateCategories instanceof SourceTypeElementInfo)) break;
            SourceTypeElementInfo parentTypeInfo = (SourceTypeElementInfo)toPopulateCategories;
            parentTypeInfo.addCategories(newElement, categories);
            toPopulateCategories = (JavaElementInfo)parentTypeInfo.getEnclosingType();
        }
        boolean isDeprecated = this.isNodeDeprecated(node);
        newInfo.setFlags(DOMToModelPopulator.toModelFlags(node.getModifiers(), isDeprecated) | 0x200 | 0x2000);
        newInfo.setHandle(newElement);
        newInfo.setNameSourceStart(node.getName().getStartPosition());
        newInfo.setNameSourceEnd(node.getName().getStartPosition() + node.getName().getLength() - 1);
        this.infos.push(newInfo);
        this.toPopulate.put(newElement, newInfo);
        return true;
    }

    @Override
    public void endVisit(AnnotationTypeDeclaration decl) {
        this.elements.pop();
        this.infos.pop();
    }

    @Override
    public boolean visit(EnumDeclaration node) {
        SourceType newElement = new SourceType(this.elements.peek(), node.getName().toString());
        this.elements.push(newElement);
        this.addAsChild(this.infos.peek(), newElement);
        SourceTypeElementInfo newInfo = new SourceTypeElementInfo();
        DOMToModelPopulator.setSourceRange(newInfo, node);
        char[][] categories = this.getCategories(node);
        newInfo.addCategories(newElement, categories);
        JavaElementInfo toPopulateCategories = this.infos.peek();
        while (toPopulateCategories != null) {
            if (!(toPopulateCategories instanceof SourceTypeElementInfo)) break;
            SourceTypeElementInfo parentTypeInfo = (SourceTypeElementInfo)toPopulateCategories;
            parentTypeInfo.addCategories(newElement, categories);
            toPopulateCategories = (JavaElementInfo)parentTypeInfo.getEnclosingType();
        }
        boolean isDeprecated = this.isNodeDeprecated(node);
        newInfo.setFlags(DOMToModelPopulator.toModelFlags(node.getModifiers(), isDeprecated) | 0x4000);
        newInfo.setHandle(newElement);
        newInfo.setNameSourceStart(node.getName().getStartPosition());
        newInfo.setNameSourceEnd(node.getName().getStartPosition() + node.getName().getLength() - 1);
        newInfo.setSuperInterfaceNames((char[][])node.superInterfaceTypes().stream().map(ASTNode::toString).map(String::toCharArray).toArray(n -> new char[n][]));
        this.infos.push(newInfo);
        this.toPopulate.put(newElement, newInfo);
        return true;
    }

    @Override
    public void endVisit(EnumDeclaration decl) {
        this.elements.pop();
        this.infos.pop();
    }

    @Override
    public boolean visit(EnumConstantDeclaration node) {
        IJavaElement parent = this.elements.peek();
        SourceField newElement = new SourceField(this.elements.peek(), node.getName().toString());
        this.elements.push(newElement);
        this.addAsChild(this.infos.peek(), newElement);
        SourceFieldWithChildrenInfo info = new SourceFieldWithChildrenInfo(new IJavaElement[0]);
        info.setTypeName(parent.getElementName().toCharArray());
        DOMToModelPopulator.setSourceRange(info, node);
        boolean isDeprecated = this.isNodeDeprecated(node);
        info.setFlags(DOMToModelPopulator.toModelFlags(node.getModifiers(), isDeprecated) | 0x4000);
        info.setNameSourceStart(node.getName().getStartPosition());
        info.setNameSourceEnd(node.getName().getStartPosition() + node.getName().getLength() - 1);
        this.infos.push(info);
        this.toPopulate.put(newElement, info);
        return true;
    }

    @Override
    public void endVisit(EnumConstantDeclaration decl) {
        this.elements.pop();
        this.infos.pop();
    }

    @Override
    public boolean visit(RecordDeclaration node) {
        SourceType newElement = new SourceType(this.elements.peek(), node.getName().toString());
        this.elements.push(newElement);
        this.addAsChild(this.infos.peek(), newElement);
        SourceTypeElementInfo newInfo = new SourceTypeElementInfo();
        DOMToModelPopulator.setSourceRange(newInfo, node);
        char[][] categories = this.getCategories(node);
        newInfo.addCategories(newElement, categories);
        newInfo.setSuperclassName(Record.class.getName().toCharArray());
        newInfo.setSuperInterfaceNames((char[][])node.superInterfaceTypes().stream().map(ASTNode::toString).map(String::toCharArray).toArray(n -> new char[n][]));
        JavaElementInfo toPopulateCategories = this.infos.peek();
        while (toPopulateCategories != null) {
            if (!(toPopulateCategories instanceof SourceTypeElementInfo)) break;
            SourceTypeElementInfo parentTypeInfo = (SourceTypeElementInfo)toPopulateCategories;
            parentTypeInfo.addCategories(newElement, categories);
            toPopulateCategories = (JavaElementInfo)parentTypeInfo.getEnclosingType();
        }
        boolean isDeprecated = this.isNodeDeprecated(node);
        newInfo.setFlags(DOMToModelPopulator.toModelFlags(node.getModifiers(), isDeprecated) | 0x1000000);
        newInfo.setHandle(newElement);
        newInfo.setNameSourceStart(node.getName().getStartPosition());
        newInfo.setNameSourceEnd(node.getName().getStartPosition() + node.getName().getLength() - 1);
        this.infos.push(newInfo);
        this.toPopulate.put(newElement, newInfo);
        return true;
    }

    @Override
    public void endVisit(RecordDeclaration decl) {
        this.elements.pop();
        this.infos.pop();
    }

    @Override
    public boolean visit(SingleVariableDeclaration node) {
        if (node.getParent() instanceof RecordDeclaration) {
            SourceField newElement = new SourceField(this.elements.peek(), node.getName().toString()){

                @Override
                public boolean isRecordComponent() throws JavaModelException {
                    return true;
                }
            };
            this.elements.push(newElement);
            this.addAsChild(this.infos.peek(), newElement);
            SourceFieldElementInfo newInfo = new SourceFieldElementInfo();
            DOMToModelPopulator.setSourceRange(newInfo, node);
            newInfo.setNameSourceStart(node.getName().getStartPosition());
            newInfo.setNameSourceEnd(node.getName().getStartPosition() + node.getName().getLength() - 1);
            newInfo.setTypeName(node.getType().toString().toCharArray());
            newInfo.setFlags(DOMToModelPopulator.toModelFlags(node.getModifiers(), false));
            newInfo.isRecordComponent = true;
            this.infos.push(newInfo);
            this.toPopulate.put(newElement, newInfo);
        } else if (node.getParent() instanceof MethodDeclaration) {
            LocalVariable newElement = DOMToModelPopulator.toLocalVariable(node, this.elements.peek());
            this.elements.push(newElement);
            this.addAsChild(this.infos.peek(), newElement);
            AnnotatableInfo newInfo = new AnnotatableInfo();
            DOMToModelPopulator.setSourceRange(newInfo, node);
            newInfo.setNameSourceStart(node.getName().getStartPosition());
            newInfo.setNameSourceEnd(node.getName().getStartPosition() + node.getName().getLength() - 1);
            newInfo.setFlags(DOMToModelPopulator.toModelFlags(node.getModifiers(), false));
            this.infos.push(newInfo);
            this.toPopulate.put(newElement, newInfo);
        }
        return true;
    }

    @Override
    public void endVisit(SingleVariableDeclaration decl) {
        if (decl.getParent() instanceof RecordDeclaration || decl.getParent() instanceof MethodDeclaration) {
            this.elements.pop();
            this.infos.pop();
        }
    }

    @Override
    public boolean visit(MethodDeclaration method) {
        JavaElementInfo javaElementInfo;
        ASTNode aSTNode;
        if (method.getAST().apiLevel() > 2) {
            method.typeParameters().stream().map(org.eclipse.jdt.core.dom.TypeParameter::getName).map(Name::getFullyQualifiedName).forEach(this.currentTypeParameters::add);
        }
        List parameters = method.parameters();
        if (method.getAST().apiLevel() >= 16 && method.isCompactConstructor() && (parameters == null || parameters.isEmpty()) && (aSTNode = method.getParent()) instanceof RecordDeclaration) {
            RecordDeclaration parentRecord = (RecordDeclaration)aSTNode;
            parameters = parentRecord.recordComponents();
        }
        SourceMethod newElement = new SourceMethod(this.elements.peek(), method.getName().getIdentifier(), (String[])parameters.stream().map(this::createSignature).toArray(String[]::new));
        this.elements.push(newElement);
        this.addAsChild(this.infos.peek(), newElement);
        SourceMethodElementInfo info = method.isConstructor() ? new SourceConstructorWithChildrenInfo(new IJavaElement[0]) : new SourceMethodWithChildrenInfo(new IJavaElement[0]);
        info.setArgumentNames((char[][])parameters.stream().map(param -> param.getName().toString().toCharArray()).toArray(n -> new char[n][]));
        if (method.getAST().apiLevel() > 2) {
            if (method.getReturnType2() != null) {
                info.setReturnType(method.getReturnType2().toString().toCharArray());
            } else {
                info.setReturnType("void".toCharArray());
            }
        }
        if ((javaElementInfo = this.infos.peek()) instanceof SourceTypeElementInfo) {
            SourceTypeElementInfo parentInfo = (SourceTypeElementInfo)javaElementInfo;
            parentInfo.addCategories(newElement, this.getCategories(method));
        }
        if (method.getAST().apiLevel() >= 8) {
            info.setExceptionTypeNames((char[][])method.thrownExceptionTypes().stream().map(ASTNode::toString).map(String::toCharArray).toArray(n -> new char[n][]));
        }
        DOMToModelPopulator.setSourceRange(info, method);
        boolean isDeprecated = this.isNodeDeprecated(method);
        info.setFlags(DOMToModelPopulator.toModelFlags(method.getModifiers(), isDeprecated) | (method.getAST().apiLevel() > 2 && method.parameters().stream().anyMatch(SingleVariableDeclaration::isVarargs) ? 128 : 0));
        info.setNameSourceStart(method.getName().getStartPosition());
        info.setNameSourceEnd(method.getName().getStartPosition() + method.getName().getLength() - 1);
        if (method.getAST().apiLevel() >= 16 && method.isCompactConstructor()) {
            info.arguments = (ILocalVariable[])parameters.stream().map(param -> DOMToModelPopulator.toLocalVariable(param, newElement, true)).toArray(ILocalVariable[]::new);
        }
        this.infos.push(info);
        this.toPopulate.put(newElement, info);
        return true;
    }

    @Override
    public void endVisit(MethodDeclaration decl) {
        this.elements.pop();
        this.infos.pop();
        if (decl.getAST().apiLevel() > 2) {
            decl.typeParameters().stream().map(org.eclipse.jdt.core.dom.TypeParameter::getName).map(Name::getFullyQualifiedName).forEach(this.currentTypeParameters::remove);
        }
    }

    @Override
    public boolean visit(AnnotationTypeMemberDeclaration method) {
        SourceMethod newElement = new SourceMethod(this.elements.peek(), method.getName().getIdentifier(), new String[0]);
        this.elements.push(newElement);
        this.addAsChild(this.infos.peek(), newElement);
        SourceAnnotationMethodInfo info = new SourceAnnotationMethodInfo();
        info.setReturnType(method.getType().toString().toCharArray());
        DOMToModelPopulator.setSourceRange(info, method);
        ((SourceTypeElementInfo)this.infos.peek()).addCategories(newElement, this.getCategories(method));
        boolean isDeprecated = this.isNodeDeprecated(method);
        info.setFlags(DOMToModelPopulator.toModelFlags(method.getModifiers(), isDeprecated));
        info.setNameSourceStart(method.getName().getStartPosition());
        info.setNameSourceEnd(method.getName().getStartPosition() + method.getName().getLength() - 1);
        Expression defaultExpr = method.getDefault();
        if (defaultExpr != null) {
            Map.Entry<Object, Integer> value = this.memberValue(defaultExpr);
            MemberValuePair mvp = new MemberValuePair(newElement.getElementName(), value.getKey(), value.getValue());
            info.defaultValue = mvp;
            info.defaultValueStart = defaultExpr.getStartPosition();
            info.defaultValueEnd = defaultExpr.getStartPosition() + defaultExpr.getLength();
        }
        this.infos.push(info);
        this.toPopulate.put(newElement, info);
        return true;
    }

    @Override
    public void endVisit(AnnotationTypeMemberDeclaration decl) {
        this.elements.pop();
        this.infos.pop();
    }

    @Override
    public boolean visit(org.eclipse.jdt.core.dom.TypeParameter node) {
        TypeParameter newElement = new TypeParameter(this.elements.peek(), node.getName().getFullyQualifiedName());
        this.elements.push(newElement);
        this.addAsChild(this.infos.peek(), newElement);
        TypeParameterElementInfo info = new TypeParameterElementInfo();
        DOMToModelPopulator.setSourceRange(info, node);
        info.nameStart = node.getName().getStartPosition();
        info.nameEnd = node.getName().getStartPosition() + node.getName().getLength() - 1;
        info.bounds = (char[][])node.typeBounds().stream().map(ASTNode::toString).map(String::toCharArray).toArray(n -> new char[n][]);
        info.boundsSignatures = (char[][])node.typeBounds().stream().map(Util::getSignature).map(String::toCharArray).toArray(n -> new char[n][]);
        this.infos.push(info);
        this.toPopulate.put(newElement, info);
        return true;
    }

    @Override
    public void endVisit(org.eclipse.jdt.core.dom.TypeParameter typeParam) {
        this.elements.pop();
        this.infos.pop();
    }

    @Override
    public boolean visit(NormalAnnotation node) {
        JavaElement parent = this.elements.peek();
        Annotation newElement = new Annotation(parent, node.getTypeName().toString());
        this.elements.push(newElement);
        this.addAsChild(this.infos.peek(), newElement);
        if (parent instanceof LocalVariable) {
            LocalVariable variable = (LocalVariable)parent;
            variable.annotations = Arrays.copyOf(variable.annotations, variable.annotations.length + 1);
            variable.annotations[variable.annotations.length - 1] = newElement;
        }
        AnnotationInfo newInfo = new AnnotationInfo();
        DOMToModelPopulator.setSourceRange(newInfo, node);
        newInfo.nameStart = node.getTypeName().getStartPosition();
        newInfo.nameEnd = node.getTypeName().getStartPosition() + node.getTypeName().getLength() - 1;
        newInfo.members = (IMemberValuePair[])node.values().stream().map(domMemberValuePair -> {
            Map.Entry<Object, Integer> value = this.memberValue(domMemberValuePair.getValue());
            return new MemberValuePair(domMemberValuePair.getName().toString(), value.getKey(), value.getValue());
        }).toArray(IMemberValuePair[]::new);
        this.infos.push(newInfo);
        this.toPopulate.put(newElement, newInfo);
        return true;
    }

    @Override
    public void endVisit(NormalAnnotation decl) {
        this.elements.pop();
        this.infos.pop();
    }

    @Override
    public boolean visit(MarkerAnnotation node) {
        JavaElement parent = this.elements.peek();
        Annotation newElement = new Annotation(parent, node.getTypeName().toString());
        this.elements.push(newElement);
        this.addAsChild(this.infos.peek(), newElement);
        if (parent instanceof LocalVariable) {
            LocalVariable variable = (LocalVariable)parent;
            variable.annotations = Arrays.copyOf(variable.annotations, variable.annotations.length + 1);
            variable.annotations[variable.annotations.length - 1] = newElement;
        }
        AnnotationInfo newInfo = new AnnotationInfo();
        DOMToModelPopulator.setSourceRange(newInfo, node);
        newInfo.nameStart = node.getTypeName().getStartPosition();
        newInfo.nameEnd = node.getTypeName().getStartPosition() + node.getTypeName().getLength() - 1;
        newInfo.members = new IMemberValuePair[0];
        this.infos.push(newInfo);
        this.toPopulate.put(newElement, newInfo);
        return true;
    }

    @Override
    public void endVisit(MarkerAnnotation decl) {
        this.elements.pop();
        this.infos.pop();
    }

    @Override
    public boolean visit(SingleMemberAnnotation node) {
        JavaElement parent = this.elements.peek();
        Annotation newElement = new Annotation(parent, node.getTypeName().toString());
        this.elements.push(newElement);
        this.addAsChild(this.infos.peek(), newElement);
        if (parent instanceof LocalVariable) {
            LocalVariable variable = (LocalVariable)parent;
            variable.annotations = Arrays.copyOf(variable.annotations, variable.annotations.length + 1);
            variable.annotations[variable.annotations.length - 1] = newElement;
        }
        AnnotationInfo newInfo = new AnnotationInfo();
        DOMToModelPopulator.setSourceRange(newInfo, node);
        newInfo.nameStart = node.getTypeName().getStartPosition();
        newInfo.nameEnd = node.getTypeName().getStartPosition() + node.getTypeName().getLength() - 1;
        Map.Entry<Object, Integer> value = this.memberValue(node.getValue());
        newInfo.members = new IMemberValuePair[]{new MemberValuePair("value", value.getKey(), value.getValue())};
        this.infos.push(newInfo);
        this.toPopulate.put(newElement, newInfo);
        return true;
    }

    @Override
    public void endVisit(SingleMemberAnnotation decl) {
        this.elements.pop();
        this.infos.pop();
    }

    @Override
    public boolean visit(AnonymousClassDeclaration decl) {
        SourceType newElement = new SourceType(this.elements.peek(), "");
        this.elements.push(newElement);
        this.addAsChild(this.infos.peek(), newElement);
        SourceTypeElementInfo newInfo = new SourceTypeElementInfo(){

            @Override
            public boolean isAnonymousMember() {
                return true;
            }
        };
        JavaElementInfo toPopulateCategories = this.infos.peek();
        while (toPopulateCategories != null) {
            if (!(toPopulateCategories instanceof SourceTypeElementInfo)) break;
            SourceTypeElementInfo parentTypeInfo = (SourceTypeElementInfo)toPopulateCategories;
            toPopulateCategories = (JavaElementInfo)parentTypeInfo.getEnclosingType();
        }
        newInfo.setHandle(newElement);
        DOMToModelPopulator.setSourceRange(newInfo, decl);
        ASTNode aSTNode = decl.getParent();
        if (aSTNode instanceof EnumConstantDeclaration) {
            EnumConstantDeclaration enumConstantDeclaration = (EnumConstantDeclaration)aSTNode;
            DOMToModelPopulator.setSourceRange(newInfo, enumConstantDeclaration);
            newInfo.setNameSourceStart(enumConstantDeclaration.getName().getStartPosition());
            newInfo.setNameSourceEnd(enumConstantDeclaration.getName().getStartPosition() + enumConstantDeclaration.getName().getLength() - 1);
        } else {
            ASTNode aSTNode2 = decl.getParent();
            if (aSTNode2 instanceof ClassInstanceCreation) {
                ClassInstanceCreation constructorInvocation = (ClassInstanceCreation)aSTNode2;
                if (constructorInvocation.getAST().apiLevel() > 2) {
                    int length;
                    constructorInvocation.typeArguments().stream().map(SimpleType::getName).map(Name::getFullyQualifiedName).forEach(this.currentTypeParameters::add);
                    Type type = constructorInvocation.getType();
                    newInfo.setSuperclassName(type.toString().toCharArray());
                    newInfo.setNameSourceStart(type.getStartPosition());
                    newInfo.setSourceRangeStart(constructorInvocation.getStartPosition());
                    if (type instanceof ParameterizedType) {
                        ParameterizedType pType = (ParameterizedType)type;
                        length = pType.getType().getLength();
                    } else {
                        length = type.getLength();
                    }
                    newInfo.setNameSourceEnd(type.getStartPosition() + length - 1);
                } else {
                    newInfo.setNameSourceStart(constructorInvocation.getType().getStartPosition());
                    newInfo.setSourceRangeStart(constructorInvocation.getType().getStartPosition());
                    newInfo.setNameSourceEnd(constructorInvocation.getType().getStartPosition() + constructorInvocation.getType().getLength() - 1);
                }
            }
        }
        this.infos.push(newInfo);
        this.toPopulate.put(newElement, newInfo);
        return true;
    }

    @Override
    public void endVisit(AnonymousClassDeclaration decl) {
        ClassInstanceCreation constructorInvocation;
        this.elements.pop();
        this.infos.pop();
        ASTNode aSTNode = decl.getParent();
        if (aSTNode instanceof ClassInstanceCreation && (constructorInvocation = (ClassInstanceCreation)aSTNode).getAST().apiLevel() > 2) {
            constructorInvocation.typeArguments().stream().map(SimpleType::getName).map(Name::getFullyQualifiedName).forEach(this.currentTypeParameters::remove);
        }
    }

    public Map.Entry<Object, Integer> memberValue(Expression dom) {
        SimpleName name;
        if (dom == null || dom instanceof NullLiteral || dom instanceof SimpleName && ("MISSING".equals((name = (SimpleName)dom).getIdentifier()) || Arrays.equals(RecoveryScanner.FAKE_IDENTIFIER, name.getIdentifier().toCharArray()))) {
            return new AbstractMap.SimpleEntry<Object, Integer>(null, 14);
        }
        if (dom instanceof StringLiteral) {
            StringLiteral stringValue = (StringLiteral)dom;
            return new AbstractMap.SimpleEntry<Object, Integer>(stringValue.getLiteralValue(), 9);
        }
        if (dom instanceof BooleanLiteral) {
            BooleanLiteral booleanValue = (BooleanLiteral)dom;
            return new AbstractMap.SimpleEntry<Object, Integer>(booleanValue.booleanValue(), 8);
        }
        if (dom instanceof CharacterLiteral) {
            CharacterLiteral charValue = (CharacterLiteral)dom;
            return new AbstractMap.SimpleEntry<Object, Integer>(Character.valueOf(charValue.charValue()), 4);
        }
        if (dom instanceof TypeLiteral) {
            TypeLiteral typeLiteral = (TypeLiteral)dom;
            return new AbstractMap.SimpleEntry<Object, Integer>(typeLiteral.getType(), 11);
        }
        if (dom instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)dom;
            return new AbstractMap.SimpleEntry<Object, Integer>(simpleName.toString(), 13);
        }
        if (dom instanceof QualifiedName) {
            QualifiedName qualifiedName = (QualifiedName)dom;
            return new AbstractMap.SimpleEntry<Object, Integer>(qualifiedName.toString(), 12);
        }
        if (dom instanceof org.eclipse.jdt.core.dom.Annotation) {
            org.eclipse.jdt.core.dom.Annotation annotation = (org.eclipse.jdt.core.dom.Annotation)dom;
            return new AbstractMap.SimpleEntry<Object, Integer>(this.toModelAnnotation(annotation, null), 10);
        }
        if (dom instanceof ArrayInitializer) {
            ArrayInitializer arrayInitializer = (ArrayInitializer)dom;
            List<Map.Entry> values = arrayInitializer.expressions().stream().map(this::memberValue).toList();
            List<Integer> types = values.stream().map(Map.Entry::getValue).distinct().toList();
            return new AbstractMap.SimpleEntry<Object[], Integer>(values.stream().map(Map.Entry::getKey).toArray(), types.size() == 1 ? types.get(0) : 14);
        }
        if (dom instanceof NumberLiteral) {
            NumberLiteral number = (NumberLiteral)dom;
            String token = number.getToken();
            int type = this.toAnnotationValuePairType(token);
            Object value = token;
            if (type == 7 && token.endsWith("L") || type == 5 && token.endsWith("f")) {
                value = token.substring(0, token.length() - 1);
            }
            if (value instanceof String) {
                String valueString = value;
                switch (type) {
                    case 1: {
                        try {
                            value = Integer.parseInt(valueString);
                        }
                        catch (NumberFormatException e) {
                            type = 7;
                            value = Long.parseLong(valueString);
                        }
                        break;
                    }
                    case 7: {
                        value = Long.parseLong(valueString);
                        break;
                    }
                    case 3: {
                        value = Short.parseShort(valueString);
                        break;
                    }
                    case 2: {
                        value = Byte.parseByte(valueString);
                        break;
                    }
                    case 5: {
                        value = Float.valueOf(Float.parseFloat(valueString));
                        break;
                    }
                    case 6: {
                        value = Double.parseDouble(valueString);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Type not (yet?) supported");
                    }
                }
            }
            return new AbstractMap.SimpleEntry<Object, Integer>(value, type);
        }
        if (dom instanceof PrefixExpression) {
            PrefixExpression prefixExpression = (PrefixExpression)dom;
            Expression operand = prefixExpression.getOperand();
            if (!(operand instanceof NumberLiteral) && !(operand instanceof BooleanLiteral)) {
                return new AbstractMap.SimpleEntry<Object, Integer>(null, 14);
            }
            Map.Entry<Object, Integer> entry = this.memberValue(prefixExpression.getOperand());
            return new AbstractMap.SimpleEntry<Object, Integer>(prefixExpression.getOperator().toString() + String.valueOf(entry.getKey()), entry.getValue());
        }
        return new AbstractMap.SimpleEntry<Object, Integer>(null, 14);
    }

    private int toAnnotationValuePairType(String token) {
        Scanner scanner = new Scanner();
        scanner.setSource(token.toCharArray());
        try {
            int tokenType = scanner.getNextToken();
            return switch (tokenType) {
                case 60 -> 6;
                case 57 -> 1;
                case 59 -> 5;
                case 58 -> 7;
                case 5 -> {
                    switch (scanner.getNextToken()) {
                        case 60: {
                            yield 6;
                        }
                        case 57: {
                            yield 1;
                        }
                        case 59: {
                            yield 5;
                        }
                        case 58: {
                            yield 7;
                        }
                    }
                    throw new IllegalArgumentException("Invalid number literal : >" + token + "<");
                }
                default -> throw new IllegalArgumentException("Invalid number literal : >" + token + "<");
            };
        }
        catch (InvalidInputException ex) {
            ILog.get().error(ex.getMessage(), (Throwable)ex);
            return 14;
        }
    }

    private Annotation toModelAnnotation(org.eclipse.jdt.core.dom.Annotation domAnnotation, JavaElement parent) {
        IMemberValuePair[] members;
        if (domAnnotation instanceof NormalAnnotation) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)domAnnotation;
            members = (IMemberValuePair[])normalAnnotation.values().stream().map(domMemberValuePair -> {
                Map.Entry<Object, Integer> value = this.memberValue(domMemberValuePair.getValue());
                return new MemberValuePair(domMemberValuePair.getName().toString(), value.getKey(), value.getValue());
            }).toArray(IMemberValuePair[]::new);
        } else if (domAnnotation instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation single = (SingleMemberAnnotation)domAnnotation;
            Map.Entry<Object, Integer> value = this.memberValue(single.getValue());
            members = new IMemberValuePair[]{new MemberValuePair("value", value.getKey(), value.getValue())};
        } else {
            members = new IMemberValuePair[]{};
        }
        return new Annotation(parent, domAnnotation.getTypeName().toString()){

            @Override
            public IMemberValuePair[] getMemberValuePairs() {
                return members;
            }
        };
    }

    public static LocalVariable toLocalVariable(SingleVariableDeclaration parameter, JavaElement parent) {
        return DOMToModelPopulator.toLocalVariable(parameter, parent, parameter.getParent() instanceof MethodDeclaration);
    }

    private static LocalVariable toLocalVariable(SingleVariableDeclaration parameter, JavaElement parent, boolean isParameter) {
        return new LocalVariable(parent, parameter.getName().getIdentifier(), DOMToModelPopulator.getStartConsideringLeadingComments(parameter), parameter.getStartPosition() + parameter.getLength() - 1, parameter.getName().getStartPosition(), parameter.getName().getStartPosition() + parameter.getName().getLength() - 1, Util.getSignature(parameter.getType()), null, DOMToModelPopulator.toModelFlags(parameter.getModifiers(), false), isParameter);
    }

    @Override
    public boolean visit(FieldDeclaration field) {
        JavaElementInfo parentInfo = this.infos.peek();
        JavaElement parentElement = this.elements.peek();
        boolean isDeprecated = this.isNodeDeprecated(field);
        char[][] categories = this.getCategories(field);
        for (VariableDeclarationFragment fragment : field.fragments()) {
            List modifiers;
            TypeDeclaration type;
            SourceField newElement = new SourceField(parentElement, fragment.getName().toString());
            this.elements.push(newElement);
            this.addAsChild(parentInfo, newElement);
            SourceFieldWithChildrenInfo info = new SourceFieldWithChildrenInfo(new IJavaElement[0]);
            info.setTypeName(field.getType().toString().toCharArray());
            DOMToModelPopulator.setSourceRange(info, field);
            if (parentInfo instanceof SourceTypeElementInfo) {
                SourceTypeElementInfo parentTypeInfo = (SourceTypeElementInfo)parentInfo;
                parentTypeInfo.addCategories(newElement, categories);
            }
            info.setFlags(DOMToModelPopulator.toModelFlags(field.getModifiers(), isDeprecated));
            info.setNameSourceStart(fragment.getName().getStartPosition());
            info.setNameSourceEnd(fragment.getName().getStartPosition() + fragment.getName().getLength() - 1);
            Expression initializer = fragment.getInitializer();
            ASTNode aSTNode = field.getParent();
            if ((aSTNode instanceof TypeDeclaration && (type = (TypeDeclaration)aSTNode).isInterface() || Flags.isFinal(field.getModifiers())) && initializer != null && initializer.getStartPosition() >= 0) {
                info.initializationSource = Arrays.copyOfRange(this.root.getContents(), initializer.getStartPosition(), initializer.getStartPosition() + initializer.getLength());
            }
            this.infos.push(info);
            this.toPopulate.put(newElement, info);
            if (field.getAST().apiLevel() < 3 || (modifiers = field.modifiers()) == null) continue;
            modifiers.stream().filter(org.eclipse.jdt.core.dom.Annotation.class::isInstance).map(org.eclipse.jdt.core.dom.Annotation.class::cast).forEach(annotation -> annotation.accept(this));
        }
        return true;
    }

    @Override
    public void endVisit(FieldDeclaration decl) {
        int numFragments = decl.fragments().size();
        int i = 0;
        while (i < numFragments) {
            this.elements.pop();
            this.infos.pop();
            ++i;
        }
    }

    private String createSignature(SingleVariableDeclaration decl) {
        String initialSignature = Util.getSignature(decl.getType());
        int extraDimensions = decl.getExtraDimensions();
        if (decl.getAST().apiLevel() > 2 && decl.isVarargs()) {
            ++extraDimensions;
        }
        return Signature.createArraySignature(initialSignature, extraDimensions);
    }

    @Override
    public boolean visit(org.eclipse.jdt.core.dom.Initializer node) {
        Initializer newElement = new Initializer(this.elements.peek(), 1);
        this.elements.push(newElement);
        this.addAsChild(this.infos.peek(), newElement);
        InitializerWithChildrenInfo newInfo = new InitializerWithChildrenInfo(new IJavaElement[0]);
        DOMToModelPopulator.setSourceRange(newInfo, node);
        newInfo.setFlags(DOMToModelPopulator.toModelFlags(node.getModifiers(), false));
        this.infos.push(newInfo);
        this.toPopulate.put(newElement, newInfo);
        return true;
    }

    @Override
    public void endVisit(org.eclipse.jdt.core.dom.Initializer decl) {
        this.elements.pop();
        this.infos.pop();
    }

    @Override
    public boolean visit(ModuleDeclaration node) {
        SourceModule newElement = new SourceModule(this.elements.peek(), node.getName().toString());
        this.elements.push(newElement);
        this.addAsChild(this.infos.peek(), newElement);
        ModuleDescriptionInfo newInfo = new ModuleDescriptionInfo();
        newInfo.setHandle(newElement);
        newInfo.name = node.getName().toString().toCharArray();
        newInfo.setNameSourceStart(node.getName().getStartPosition());
        newInfo.setNameSourceEnd(node.getName().getStartPosition() + node.getName().getLength() - 1);
        DOMToModelPopulator.setSourceRange(newInfo, node);
        newInfo.setFlags(this.hasDeprecatedComment(node.getJavadoc()) || this.hasDeprecatedAnnotation(node.annotations()) ? 0x100000 : 0);
        List moduleStatements = node.moduleStatements();
        LinkedHashSet<ModuleDescriptionInfo.ModuleReferenceInfo> requires = new LinkedHashSet<ModuleDescriptionInfo.ModuleReferenceInfo>(moduleStatements.stream().filter(RequiresDirective.class::isInstance).map(RequiresDirective.class::cast).map(this::toModuleReferenceInfo).toList());
        char[] javaBase = CharOperation.concatWith((char[][])TypeConstants.JAVA_BASE, (char)'.');
        if (!Arrays.equals(node.getName().toString().toCharArray(), javaBase)) {
            ModuleDescriptionInfo.ModuleReferenceInfo ref = new ModuleDescriptionInfo.ModuleReferenceInfo();
            ref.name = javaBase;
            requires.add(ref);
        }
        newInfo.requires = (ModuleDescriptionInfo.ModuleReferenceInfo[])requires.toArray(ModuleDescriptionInfo.ModuleReferenceInfo[]::new);
        newInfo.exports = (ModuleDescriptionInfo.PackageExportInfo[])moduleStatements.stream().filter(ExportsDirective.class::isInstance).map(ExportsDirective.class::cast).map(this::toPackageExportInfo).toArray(ModuleDescriptionInfo.PackageExportInfo[]::new);
        newInfo.opens = (ModuleDescriptionInfo.PackageExportInfo[])moduleStatements.stream().filter(OpensDirective.class::isInstance).map(OpensDirective.class::cast).map(this::toPackageExportInfo).toArray(ModuleDescriptionInfo.PackageExportInfo[]::new);
        newInfo.usedServices = (char[][])moduleStatements.stream().filter(UsesDirective.class::isInstance).map(UsesDirective.class::cast).map(UsesDirective::getName).map(ASTNode::toString).map(String::toCharArray).toArray(n -> new char[n][]);
        newInfo.services = (ModuleDescriptionInfo.ServiceInfo[])moduleStatements.stream().filter(ProvidesDirective.class::isInstance).map(ProvidesDirective.class::cast).map(this::toServiceInfo).toArray(ModuleDescriptionInfo.ServiceInfo[]::new);
        char[][] categories = this.getCategories(node);
        newInfo.addCategories(newElement, categories);
        this.infos.push(newInfo);
        this.toPopulate.put(newElement, newInfo);
        this.unitInfo.setModule(newElement);
        try {
            this.root.getJavaProject().setModuleDescription(newElement);
        }
        catch (JavaModelException e) {
            ILog.get().error(e.getMessage(), (Throwable)((Object)e));
        }
        return true;
    }

    @Override
    public void endVisit(ModuleDeclaration decl) {
        this.elements.pop();
        this.infos.pop();
    }

    @Override
    public boolean visit(LambdaExpression node) {
        this.unitInfo.hasFunctionalTypes = true;
        return true;
    }

    @Override
    public boolean visit(CreationReference node) {
        this.unitInfo.hasFunctionalTypes = true;
        return true;
    }

    @Override
    public boolean visit(ExpressionMethodReference node) {
        this.unitInfo.hasFunctionalTypes = true;
        return true;
    }

    @Override
    public boolean visit(TypeMethodReference node) {
        this.unitInfo.hasFunctionalTypes = true;
        return true;
    }

    @Override
    public boolean visit(SuperMethodReference node) {
        this.unitInfo.hasFunctionalTypes = true;
        return true;
    }

    private ModuleDescriptionInfo.ModuleReferenceInfo toModuleReferenceInfo(RequiresDirective node) {
        ModuleDescriptionInfo.ModuleReferenceInfo res = new ModuleDescriptionInfo.ModuleReferenceInfo();
        res.modifiers = (ModuleModifier.isTransitive(node.getModifiers()) ? 32 : 0) | (ModuleModifier.isStatic(node.getModifiers()) ? 8 : 0);
        res.name = node.getName().toString().toCharArray();
        DOMToModelPopulator.setSourceRange(res, node);
        return res;
    }

    private ModuleDescriptionInfo.PackageExportInfo toPackageExportInfo(ModulePackageAccess node) {
        ModuleDescriptionInfo.PackageExportInfo res = new ModuleDescriptionInfo.PackageExportInfo();
        res.pack = node.getName().toString().toCharArray();
        DOMToModelPopulator.setSourceRange(res, node);
        List modules = node.modules();
        res.target = modules == null || modules.isEmpty() ? null : (char[][])modules.stream().map(name -> name.toString().toCharArray()).toArray(n -> new char[n][]);
        return res;
    }

    private ModuleDescriptionInfo.ServiceInfo toServiceInfo(ProvidesDirective node) {
        ModuleDescriptionInfo.ServiceInfo res = new ModuleDescriptionInfo.ServiceInfo();
        res.flags = node.getFlags();
        res.serviceName = node.getName().toString().toCharArray();
        res.implNames = (char[][])node.implementations().stream().map(ASTNode::toString).map(String::toCharArray).toArray(n -> new char[n][]);
        DOMToModelPopulator.setSourceRange(res, node);
        return res;
    }

    private boolean hasDeprecatedComment(Javadoc javadoc) {
        return javadoc != null && javadoc.tags().stream().anyMatch(tag -> "@deprecated".equals(((AbstractTagElement)tag).getTagName()));
    }

    private boolean hasDeprecatedAnnotation(List<IExtendedModifier> modifiers) {
        return modifiers != null && modifiers.stream().anyMatch(modifier -> {
            if (!(modifier instanceof org.eclipse.jdt.core.dom.Annotation)) return false;
            org.eclipse.jdt.core.dom.Annotation annotation = (org.eclipse.jdt.core.dom.Annotation)modifier;
            if (Deprecated.class.getName().equals(annotation.getTypeName().toString())) return true;
            if (!Deprecated.class.getSimpleName().equals(annotation.getTypeName().toString())) return false;
            if (this.hasAlternativeDeprecated()) return false;
            return true;
        });
    }

    private boolean isNodeDeprecated(BodyDeclaration node) {
        if (this.hasDeprecatedComment(node.getJavadoc())) {
            return true;
        }
        if (node.getAST().apiLevel() <= 2) {
            return false;
        }
        return this.hasDeprecatedAnnotation(node.modifiers());
    }

    private boolean hasAlternativeDeprecated() {
        if (this.alternativeDeprecated != null) {
            return this.alternativeDeprecated;
        }
        if (this.importContainer != null) {
            try {
                IJavaElement[] importElements;
                IJavaElement[] iJavaElementArray = importElements = this.importContainer.getChildren();
                int n = importElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement child = iJavaElementArray[n2];
                    IImportDeclaration importDeclaration = (IImportDeclaration)child;
                    if (!importDeclaration.isOnDemand() && importDeclaration.getElementName().endsWith("Deprecated")) {
                        this.alternativeDeprecated = true;
                        return this.alternativeDeprecated;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        this.alternativeDeprecated = false;
        return this.alternativeDeprecated;
    }

    private char[][] getCategories(ASTNode node) {
        Javadoc javadoc = this.javadoc(node);
        if (javadoc != null) {
            char[][] categories = (char[][])javadoc.tags().stream().filter(tag -> "@category".equals(tag.getTagName()) && tag.fragments().size() > 0).map(tag -> (ASTNode)tag.fragments().get(0)).map(fragment -> {
                String fragmentString;
                int firstAsterix = (fragmentString = fragment.toString()).indexOf(42);
                return fragmentString.substring(0, firstAsterix != -1 ? firstAsterix : fragmentString.length());
            }).flatMap(fragment -> Stream.of(fragment.split("\\s+"))).filter(category -> category.length() > 0).map(category -> category.toCharArray()).toArray(n -> new char[n][]);
            return (char[][])(categories.length > 0 ? categories : null);
        }
        return null;
    }

    private static void setSourceRange(SourceRefElementInfo info, ASTNode node) {
        info.setSourceRangeStart(DOMToModelPopulator.getStartConsideringLeadingComments(node));
        info.setSourceRangeEnd(node.getStartPosition() + node.getLength() - 1);
    }

    private static int getStartConsideringLeadingComments(ASTNode node) {
        int index;
        int start = node.getStartPosition();
        org.eclipse.jdt.core.dom.CompilationUnit unit = DOMToModelPopulator.domUnit(node);
        if (unit != null && (index = unit.firstLeadingCommentIndex(node)) >= 0 && index <= unit.getCommentList().size()) {
            Comment comment = (Comment)unit.getCommentList().get(index);
            start = comment.getStartPosition();
        }
        return start;
    }

    private static org.eclipse.jdt.core.dom.CompilationUnit domUnit(ASTNode node) {
        while (node != null && !(node instanceof org.eclipse.jdt.core.dom.CompilationUnit)) {
            node = node.getParent();
        }
        return (org.eclipse.jdt.core.dom.CompilationUnit)node;
    }

    private static int toModelFlags(int domModifiers, boolean isDeprecated) {
        int res = 0;
        if (Modifier.isAbstract(domModifiers)) {
            res |= 0x400;
        }
        if (Modifier.isDefault(domModifiers)) {
            res |= 0x10000;
        }
        if (Modifier.isFinal(domModifiers)) {
            res |= 0x10;
        }
        if (Modifier.isNative(domModifiers)) {
            res |= 0x100;
        }
        if (Modifier.isNonSealed(domModifiers)) {
            res |= 0x4000000;
        }
        if (Modifier.isPrivate(domModifiers)) {
            res |= 2;
        }
        if (Modifier.isProtected(domModifiers)) {
            res |= 4;
        }
        if (Modifier.isPublic(domModifiers)) {
            res |= 1;
        }
        if (Modifier.isSealed(domModifiers)) {
            res |= 0x10000000;
        }
        if (Modifier.isStatic(domModifiers)) {
            res |= 8;
        }
        if (Modifier.isStrictfp(domModifiers)) {
            res |= 0x800;
        }
        if (Modifier.isSynchronized(domModifiers)) {
            res |= 0x20;
        }
        if (Modifier.isTransient(domModifiers)) {
            res |= 0x80;
        }
        if (Modifier.isVolatile(domModifiers)) {
            res |= 0x40;
        }
        if (isDeprecated) {
            res |= 0x100000;
        }
        return res;
    }

    private Javadoc javadoc(ASTNode node) {
        FieldDeclaration field;
        EnumDeclaration enumType;
        TypeDeclaration type;
        ModuleDeclaration module;
        BodyDeclaration body;
        if (node instanceof BodyDeclaration && (body = (BodyDeclaration)node).getJavadoc() != null) {
            return body.getJavadoc();
        }
        if (node instanceof ModuleDeclaration && (module = (ModuleDeclaration)node).getJavadoc() != null) {
            return module.getJavadoc();
        }
        if (node instanceof TypeDeclaration && (type = (TypeDeclaration)node).getJavadoc() != null) {
            return type.getJavadoc();
        }
        if (node instanceof EnumDeclaration && (enumType = (EnumDeclaration)node).getJavadoc() != null) {
            return enumType.getJavadoc();
        }
        if (node instanceof FieldDeclaration && (field = (FieldDeclaration)node).getJavadoc() != null) {
            return field.getJavadoc();
        }
        org.eclipse.jdt.core.dom.CompilationUnit unit = DOMToModelPopulator.domUnit(node);
        int commentIndex = unit.firstLeadingCommentIndex(node);
        if (commentIndex >= 0) {
            int i = commentIndex;
            while (i < unit.getCommentList().size()) {
                Javadoc javadoc;
                Comment comment = (Comment)unit.getCommentList().get(i);
                if (comment.getStartPosition() > node.getStartPosition()) {
                    return null;
                }
                if (comment instanceof Javadoc && (javadoc = (Javadoc)comment).getStartPosition() <= node.getStartPosition()) {
                    return javadoc;
                }
                ++i;
            }
        }
        return null;
    }
}

