/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.MacInstalledJREs;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;

public class DetectVMInstallationsJob
extends Job {
    private static final String ENV_CI = "CI";
    private static final String PROPERTY_DETECT_VM_INSTALLATIONS_JOB_DISABLED = "DetectVMInstallationsJob.disabled";
    private static final Object FAMILY = DetectVMInstallationsJob.class;

    public DetectVMInstallationsJob() {
        super(LaunchingMessages.lookupInstalledJVMs);
    }

    public IStatus run(IProgressMonitor monitor) {
        SubMonitor subMon;
        StandardVMType standardType = (StandardVMType)JavaRuntime.getVMInstallType("org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
        Collection<File> candidates = this.computeCandidateVMs(standardType);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        Set<File> knownVMs = DetectVMInstallationsJob.knownVMs();
        candidates.removeIf(knownVMs::contains);
        ArrayList<VMStandin> systemVMs = Collections.EMPTY_LIST;
        if (Platform.OS.isMac()) {
            try {
                systemVMs = new ArrayList<VMStandin>(Arrays.asList(MacInstalledJREs.getInstalledJREs(monitor)));
                systemVMs.removeIf(t -> knownVMs.contains(t.getInstallLocation()));
                for (VMStandin systemVM : systemVMs) {
                    candidates.removeIf(t -> t.equals(systemVM.getInstallLocation()));
                }
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
        monitor.beginTask(LaunchingMessages.lookupInstalledJVMs, candidates.size() + systemVMs.size());
        for (File f : candidates) {
            IVMInstall2 vm;
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)f.getAbsolutePath(), (int)1);
            VMStandin workingCopy = new VMStandin(standardType, f.getAbsolutePath());
            workingCopy.setInstallLocation(f);
            Object name = f.getName();
            int i = 2;
            while (this.isDuplicateName((String)name)) {
                name = f.getName() + "(" + i++ + ")";
            }
            workingCopy.setName((String)name);
            IVMInstall install = workingCopy.convertToRealVM();
            if (!(install instanceof IVMInstall2) || (vm = (IVMInstall2)((Object)install)).getJavaVersion() == null) {
                standardType.disposeVMInstall(install.getId());
            }
            subMon.done();
        }
        for (VMStandin systemVM : systemVMs) {
            IVMInstall2 vm;
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)systemVM.getInstallLocation().getAbsolutePath(), (int)1);
            Object name = systemVM.getName();
            int i = 2;
            while (this.isDuplicateName((String)name)) {
                name = systemVM.getName() + "(" + i++ + ")";
            }
            systemVM.setName((String)name);
            IVMInstall install = systemVM.convertToRealVM();
            if (!(install instanceof IVMInstall2) || (vm = (IVMInstall2)((Object)install)).getJavaVersion() == null) {
                standardType.disposeVMInstall(install.getId());
            }
            subMon.done();
        }
        return Status.OK_STATUS;
    }

    private boolean isDuplicateName(String name) {
        return Stream.of(JavaRuntime.getVMInstallTypes()).flatMap(vmType -> Arrays.stream(vmType.getVMInstalls())).map(IVMInstall::getName).anyMatch(name::equals);
    }

    private Collection<File> computeCandidateVMs(StandardVMType standardType) {
        String jdkHome;
        HashSet<File> rootDirectories = new HashSet<File>();
        if (Platform.OS.isWindows()) {
            this.computeWindowsCandidates(rootDirectories);
        } else {
            rootDirectories.add(new File("/usr/lib/jvm"));
        }
        rootDirectories.add(new File(System.getProperty("user.home"), ".sdkman/candidates/java"));
        rootDirectories.add(new File(DetectVMInstallationsJob.miseDataDir(), "installs/java"));
        Set directories = rootDirectories.stream().filter(File::isDirectory).map(dir -> dir.listFiles(File::isDirectory)).flatMap(Arrays::stream).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new));
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome != null) {
            directories.add(new File(javaHome));
        }
        if ((jdkHome = System.getenv("JDK_HOME")) != null) {
            directories.add(new File(jdkHome));
        }
        System.getenv().entrySet().forEach(entry -> {
            if (((String)entry.getKey()).startsWith("JAVA_HOME_")) {
                directories.add(new File((String)entry.getValue()));
            }
        });
        return directories.stream().filter(Objects::nonNull).filter(File::isDirectory).map(t -> {
            try {
                return t.getCanonicalFile();
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull).filter(location -> standardType.validateInstallLocation((File)location).isOK()).collect(Collectors.toCollection(HashSet::new));
    }

    private void computeWindowsCandidates(Collection<File> rootDirectories) {
        List<String> progFiles = List.of("ProgramFiles", "ProgramFiles(x86)");
        List<String> subDirs = List.of("Eclipse Adoptium", "RedHat", "Java", "Axiom", "Zulu", "BellSoft", "Microsoft", "Amazon Corretto");
        rootDirectories.addAll(progFiles.stream().map(name -> System.getenv(name)).filter(Objects::nonNull).distinct().flatMap(progFilesDir -> subDirs.stream().map(subDir -> new File((String)progFilesDir, (String)subDir))).collect(Collectors.toList()));
    }

    private static File miseDataDir() {
        String miseDataDir = System.getenv("MISE_DATA_DIR");
        return miseDataDir != null ? new File(miseDataDir) : new File(DetectVMInstallationsJob.xdgDataHome(), "mise");
    }

    private static File xdgDataHome() {
        String xdgDataHome = System.getenv("XDG_DATA_HOME");
        if (Platform.OS.isWindows()) {
            if (xdgDataHome == null) {
                xdgDataHome = System.getenv("LOCALAPPDATA");
            }
            if (xdgDataHome == null) {
                return new File(System.getProperty("user.home"), "AppData/Local");
            }
        } else if (xdgDataHome == null) {
            return new File(System.getProperty("user.home"), ".local/share");
        }
        return new File(xdgDataHome);
    }

    private static Set<File> knownVMs() {
        return Stream.of(JavaRuntime.getVMInstallTypes()).map(IVMInstallType::getVMInstalls).flatMap(Arrays::stream).map(IVMInstall::getInstallLocation).filter(Objects::nonNull).map(t -> {
            try {
                return t.getCanonicalFile();
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public boolean belongsTo(Object family) {
        return family.equals(FAMILY);
    }

    public static void initialize() {
        IEclipsePreferences defaultNode;
        boolean defaultValue;
        if (Boolean.getBoolean(PROPERTY_DETECT_VM_INSTALLATIONS_JOB_DISABLED)) {
            return;
        }
        if (System.getProperty(PROPERTY_DETECT_VM_INSTALLATIONS_JOB_DISABLED) == null && Boolean.parseBoolean(System.getenv(ENV_CI))) {
            return;
        }
        IEclipsePreferences instanceNode = InstanceScope.INSTANCE.getNode(LaunchingPlugin.getDefault().getBundle().getSymbolicName());
        if (instanceNode.getBoolean("detectVMsAtStartup", defaultValue = (defaultNode = DefaultScope.INSTANCE.getNode(LaunchingPlugin.getDefault().getBundle().getSymbolicName())).getBoolean("detectVMsAtStartup", true))) {
            new DetectVMInstallationsJob().schedule();
        }
    }
}

