/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.SynchronizationResult;
import org.eclipse.buildship.core.internal.DefaultGradleBuild;
import org.eclipse.buildship.core.internal.operation.ToolingApiJob;
import org.eclipse.buildship.core.internal.workspace.NewProjectHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.gradle.tooling.CancellationTokenSource;

public final class SynchronizationJob
extends ToolingApiJob<Void> {
    private final Iterable<GradleBuild> gradleBuilds;
    private final NewProjectHandler newProjectHandler;

    public SynchronizationJob(GradleBuild gradleBuild) {
        this(NewProjectHandler.NO_OP, (Iterable<GradleBuild>)ImmutableList.of((Object)gradleBuild));
    }

    public SynchronizationJob(NewProjectHandler newProjectHandler, GradleBuild gradleBuild) {
        this(newProjectHandler, (Iterable<GradleBuild>)ImmutableList.of((Object)gradleBuild));
    }

    public SynchronizationJob(NewProjectHandler newProjectHandler, Iterable<GradleBuild> gradleBuilds) {
        super("Synchronize Gradle projects with workspace");
        this.newProjectHandler = newProjectHandler;
        this.gradleBuilds = ImmutableSet.copyOf(gradleBuilds);
        this.setUser(true);
    }

    public Iterable<GradleBuild> getGradleBuilds() {
        return this.gradleBuilds;
    }

    @Override
    public Void runInToolingApi(CancellationTokenSource tokenSource, IProgressMonitor monitor) throws Exception {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(ImmutableSet.copyOf(this.gradleBuilds).size() + 1));
        for (GradleBuild build : this.gradleBuilds) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            SynchronizationResult result = ((DefaultGradleBuild)build).synchronize(this.newProjectHandler, tokenSource, (IProgressMonitor)progress.newChild(1));
            if (!(result.getStatus().getException() instanceof Exception)) continue;
            throw (Exception)result.getStatus().getException();
        }
        return null;
    }

    public boolean shouldSchedule() {
        for (Job job : Job.getJobManager().find((Object)"org.eclipse.buildship.core.jobs")) {
            if (!(job instanceof SynchronizationJob) || !this.isCoveredBy((SynchronizationJob)job)) continue;
            return false;
        }
        return true;
    }

    private boolean isCoveredBy(SynchronizationJob other) {
        return Objects.equal(this.gradleBuilds, other.gradleBuilds) && (this.newProjectHandler == NewProjectHandler.NO_OP || Objects.equal((Object)this.newProjectHandler, (Object)other.newProjectHandler));
    }
}

