/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gradle.semantictokens;

import com.microsoft.gradle.semantictokens.TokenType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class SemanticToken {
    private final TokenType tokenType;
    private final int tokenModifiers;
    private final int line;
    private final int column;
    private final int length;

    public SemanticToken(int line, int column, int length, TokenType tokenType, int tokenModifiers) {
        this.line = line;
        this.column = column;
        this.length = length;
        this.tokenType = tokenType;
        this.tokenModifiers = tokenModifiers;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public int getTokenModifiers() {
        return this.tokenModifiers;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLength() {
        return this.length;
    }

    public static List<Integer> encodedTokens(List<SemanticToken> tokens) {
        tokens.sort(new Comparator<SemanticToken>(){

            @Override
            public int compare(SemanticToken a, SemanticToken b) {
                int lineResult = Integer.valueOf(a.getLine()).compareTo(b.getLine());
                if (lineResult == 0) {
                    return Integer.valueOf(a.getColumn()).compareTo(b.getColumn());
                }
                return lineResult;
            }
        });
        int numTokens = tokens.size();
        ArrayList<Integer> data = new ArrayList<Integer>(numTokens * 5);
        int currentLine = 0;
        int currentColumn = 0;
        for (int i = 0; i < numTokens; ++i) {
            SemanticToken token = tokens.get(i);
            int line = token.getLine() - 1;
            int column = token.getColumn() - 1;
            if (line < 0 || column < 0) continue;
            int deltaLine = line - currentLine;
            if (deltaLine != 0) {
                currentLine = line;
                currentColumn = 0;
            }
            int deltaColumn = column - currentColumn;
            currentColumn = column;
            if (deltaLine == 0 && deltaColumn == 0 && i != 0) continue;
            int tokenTypeIndex = token.getTokenType().ordinal();
            int tokenModifiers = token.getTokenModifiers();
            data.add(deltaLine);
            data.add(deltaColumn);
            data.add(token.getLength());
            data.add(tokenTypeIndex);
            data.add(tokenModifiers);
        }
        return data;
    }
}

