"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendVarSetFormatToHex = exports.sendVarInfoPathExpression = exports.sendVarEvaluateExpression = exports.sendVarAssign = exports.sendVarDelete = exports.sendVarUpdate = exports.sendVarListChildren = exports.sendVarCreate = exports.MIVarPrintValues = void 0;
var MIVarPrintValues;
(function (MIVarPrintValues) {
    MIVarPrintValues["no"] = "0";
    MIVarPrintValues["all"] = "1";
    MIVarPrintValues["simple"] = "2";
})(MIVarPrintValues = exports.MIVarPrintValues || (exports.MIVarPrintValues = {}));
function quote(expression) {
    return `"${expression}"`;
}
function sendVarCreate(gdb, params) {
    var _a, _b;
    let command = '-var-create';
    if (((_a = params.frameRef) === null || _a === void 0 ? void 0 : _a.threadId) !== undefined) {
        command += ` --thread ${params.frameRef.threadId}`;
    }
    if (((_b = params.frameRef) === null || _b === void 0 ? void 0 : _b.frameId) !== undefined) {
        command += ` --frame ${params.frameRef.frameId}`;
    }
    command += ` ${params.name ? params.name : '-'}`;
    if (params.frameAddr) {
        command += ` ${params.frameAddr}`;
    }
    else if (params.frame) {
        switch (params.frame) {
            default:
            case 'current':
                command += ' *';
                break;
            case 'floating':
                command += ' @';
                break;
        }
    }
    else {
        command += ' *';
    }
    command += ` ${quote(params.expression)}`;
    return gdb.sendCommand(command);
}
exports.sendVarCreate = sendVarCreate;
function sendVarListChildren(gdb, params) {
    let command = '-var-list-children';
    if (params.printValues) {
        command += ` ${params.printValues}`;
    }
    command += ` ${params.name}`;
    if (params.from && params.to) {
        command += ` ${params.from} ${params.to}`;
    }
    return gdb.sendCommand(command);
}
exports.sendVarListChildren = sendVarListChildren;
function sendVarUpdate(gdb, params) {
    let command = '-var-update';
    if (params.printValues) {
        command += ` ${params.printValues}`;
    }
    else {
        command += ` ${MIVarPrintValues.all}`;
    }
    if (params.name) {
        command += ` ${params.name}`;
    }
    else {
        command += ' *';
    }
    return gdb.sendCommand(command);
}
exports.sendVarUpdate = sendVarUpdate;
function sendVarDelete(gdb, params) {
    const command = `-var-delete ${params.varname}`;
    return gdb.sendCommand(command);
}
exports.sendVarDelete = sendVarDelete;
function sendVarAssign(gdb, params) {
    const command = `-var-assign ${params.varname} ${params.expression}`;
    return gdb.sendCommand(command);
}
exports.sendVarAssign = sendVarAssign;
function sendVarEvaluateExpression(gdb, params) {
    const command = `-var-evaluate-expression ${params.varname}`;
    return gdb.sendCommand(command);
}
exports.sendVarEvaluateExpression = sendVarEvaluateExpression;
function sendVarInfoPathExpression(gdb, name) {
    const command = `-var-info-path-expression ${name}`;
    return gdb.sendCommand(command);
}
exports.sendVarInfoPathExpression = sendVarInfoPathExpression;
function sendVarSetFormatToHex(gdb, name) {
    const command = `-var-set-format ${name} hexadecimal`;
    return gdb.sendCommand(command);
}
exports.sendVarSetFormatToHex = sendVarSetFormatToHex;
//# sourceMappingURL=var.js.map