"use strict";
/*********************************************************************
 * Copyright (c) 2023 Kichwa Coders Canada Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const os = require("os");
const utils_1 = require("./utils");
describe('stderr', function () {
    let dc;
    const program = path.join(utils_1.testProgramsDir, 'stderr');
    const source = path.join(utils_1.testProgramsDir, 'stderr.c');
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            dc = yield (0, utils_1.standardBeforeEach)();
        });
    });
    afterEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            yield dc.stop();
        });
    });
    it('receives stderr from inferior as output events', function () {
        return __awaiter(this, void 0, void 0, function* () {
            if (utils_1.isRemoteTest) {
                // remote tests the inferior stdout/err comes out the remote end, so
                // no output events from the adapter
                this.skip();
            }
            yield dc.hitBreakpoint((0, utils_1.fillDefaults)(this.test, {
                program: program,
            }), {
                path: source,
                line: 5,
            });
            const stderr = dc.waitForOutputEvent('stderr', `STDERR Here I am${os.platform() === 'win32' ? '\r\n' : '\n'}`);
            const scope = yield (0, utils_1.getScopes)(dc);
            yield Promise.all([
                dc.continueRequest({ threadId: scope.thread.id }),
                stderr,
            ]);
        });
    });
});
//# sourceMappingURL=stderr.spec.js.map