"use strict";
/*********************************************************************
 * Copyright (c) 2025 Arm Ltd
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const utils_1 = require("./utils");
describe('custom reset', function () {
    let dc;
    const emptyProgram = path.join(utils_1.testProgramsDir, 'empty');
    const commands = ['print 42'];
    const expectedResult = '$1 = 42\n';
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            dc = yield (0, utils_1.standardBeforeEach)('debugTargetAdapter.js');
            yield dc.launchRequest((0, utils_1.fillDefaults)(this.currentTest, {
                program: emptyProgram,
                customResetCommands: commands,
            }));
        });
    });
    afterEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            yield dc.stop();
        });
    });
    it('tests sending custom reset commands', function () {
        return __awaiter(this, void 0, void 0, function* () {
            if (!utils_1.isRemoteTest) {
                // command is implemented in the remote adapter but not in the local adapter
                // so skip this test if not running remote
                this.skip();
            }
            const event = dc.waitForOutputEvent('stdout', expectedResult);
            yield dc.customRequest('cdt-gdb-adapter/customReset');
            yield event;
        });
    });
});
//# sourceMappingURL=custom-reset.spec.js.map