"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GDBBackendFactory = void 0;
/*********************************************************************
 * Copyright (c) 2024 Renesas Electronics Corporation and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
const logger_1 = require("@vscode/debugadapter/lib/logger");
const GDBFileSystemProcessManager_1 = require("../processManagers/GDBFileSystemProcessManager");
const GDBPTYProcessManager_1 = require("../processManagers/GDBPTYProcessManager");
const compareVersions_1 = require("../../util/compareVersions");
const GDBBackend_1 = require("../../gdb/GDBBackend");
class GDBBackendFactory {
    constructor() {
        this.logger = logger_1.logger;
    }
    createGDBManager(session, args) {
        return __awaiter(this, void 0, void 0, function* () {
            const defaultProcessManager = new GDBFileSystemProcessManager_1.GDBFileSystemProcessManager();
            if (args.openGdbConsole) {
                const version = yield defaultProcessManager.getVersion(args);
                if (!session.supportsGdbConsole) {
                    logger_1.logger.warn('cdt-gdb-adapter: openGdbConsole is not supported on this platform');
                }
                else if ((0, compareVersions_1.compareVersions)(version, '7.12') < 0) {
                    logger_1.logger.warn(`cdt-gdb-adapter: new-ui command not detected (${args.gdb || 'gdb'})`);
                }
                else {
                    logger_1.logger.verbose('cdt-gdb-adapter: spawning gdb console in client terminal');
                    return new GDBPTYProcessManager_1.GDBPTYProcessManager(session);
                }
            }
            return defaultProcessManager;
        });
    }
    createBackend(session, manager, args) {
        return __awaiter(this, void 0, void 0, function* () {
            return new GDBBackend_1.GDBBackend(manager);
        });
    }
}
exports.GDBBackendFactory = GDBBackendFactory;
//# sourceMappingURL=GDBBackendFactory.js.map