"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_terminal_lib_browser_terminal-frontend-module_js"],{

/***/ "../../node_modules/@theia/terminal/lib/browser/base/terminal-service.js":
/*!*******************************************************************************!*\
  !*** ../../node_modules/@theia/terminal/lib/browser/base/terminal-service.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TerminalService = void 0;
/**
 * Service manipulating terminal widgets.
 */
exports.TerminalService = Symbol('TerminalService');


/***/ }),

/***/ "../../node_modules/@theia/terminal/lib/browser/search/terminal-search-container.js":
/*!******************************************************************************************!*\
  !*** ../../node_modules/@theia/terminal/lib/browser/search/terminal-search-container.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2019 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createTerminalSearchFactory = void 0;
const terminal_search_widget_1 = __webpack_require__(/*! ./terminal-search-widget */ "../../node_modules/@theia/terminal/lib/browser/search/terminal-search-widget.js");
const xterm_1 = __webpack_require__(/*! xterm */ "../../node_modules/xterm/lib/xterm.js");
function createTerminalSearchFactory(container) {
    container.bind(terminal_search_widget_1.TerminalSearchWidget).toSelf().inSingletonScope();
    return (terminal) => {
        container.bind(xterm_1.Terminal).toConstantValue(terminal);
        return container.get(terminal_search_widget_1.TerminalSearchWidget);
    };
}
exports.createTerminalSearchFactory = createTerminalSearchFactory;


/***/ }),

/***/ "../../node_modules/@theia/terminal/lib/browser/terminal-contribution.js":
/*!*******************************************************************************!*\
  !*** ../../node_modules/@theia/terminal/lib/browser/terminal-contribution.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2019 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TerminalContribution = void 0;
const terminal_widget_impl_1 = __webpack_require__(/*! ./terminal-widget-impl */ "../../node_modules/@theia/terminal/lib/browser/terminal-widget-impl.js");
Object.defineProperty(exports, "TerminalContribution", ({ enumerable: true, get: function () { return terminal_widget_impl_1.TerminalContribution; } }));


/***/ }),

/***/ "../../node_modules/@theia/terminal/lib/browser/terminal-file-link-provider.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@theia/terminal/lib/browser/terminal-file-link-provider.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2019 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LocalFileLinkProvider = exports.FileDiffPostLinkProvider = exports.FileDiffPreLinkProvider = exports.FileLinkProvider = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
const terminal_widget_impl_1 = __webpack_require__(/*! ./terminal-widget-impl */ "../../node_modules/@theia/terminal/lib/browser/terminal-widget-impl.js");
const file_search_service_1 = __webpack_require__(/*! @theia/file-search/lib/common/file-search-service */ "../../node_modules/@theia/file-search/lib/common/file-search-service.js");
const browser_2 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
let FileLinkProvider = class FileLinkProvider {
    async provideLinks(line, terminal) {
        const links = [];
        const regExp = await this.createRegExp();
        let regExpResult;
        while (regExpResult = regExp.exec(line)) {
            const match = regExpResult[0];
            if (await this.isValidFile(match, terminal)) {
                links.push({
                    startIndex: regExp.lastIndex - match.length,
                    length: match.length,
                    handle: () => this.open(match, terminal)
                });
            }
        }
        return links;
    }
    async createRegExp() {
        const baseLocalLinkClause = core_1.OS.backend.isWindows ? winLocalLinkClause : unixLocalLinkClause;
        return new RegExp(`${baseLocalLinkClause}(${lineAndColumnClause})`, 'g');
    }
    async isValidFile(match, terminal) {
        try {
            const toOpen = await this.toURI(match, await this.getCwd(terminal));
            if (toOpen) {
                // TODO: would be better to ask the opener service, but it returns positively even for unknown files.
                return this.isValidFileURI(toOpen);
            }
        }
        catch (err) {
            console.trace('Error validating ' + match, err);
        }
        return false;
    }
    async isValidFileURI(uri) {
        try {
            const stat = await this.fileService.resolve(uri);
            return !stat.isDirectory;
        }
        catch { }
        return false;
    }
    async toURI(match, cwd) {
        const path = await this.extractPath(match);
        if (!path) {
            return;
        }
        const pathObj = new core_1.Path(path);
        return pathObj.isAbsolute ? cwd.withPath(path) : cwd.resolve(path);
    }
    async getCwd(terminal) {
        if (terminal instanceof terminal_widget_impl_1.TerminalWidgetImpl) {
            return terminal.cwd;
        }
        return terminal.lastCwd;
    }
    async extractPath(link) {
        const matches = (await this.createRegExp()).exec(link);
        if (!matches) {
            return undefined;
        }
        return matches[1];
    }
    async open(match, terminal) {
        const toOpen = await this.toURI(match, await this.getCwd(terminal));
        if (!toOpen) {
            return;
        }
        const position = await this.extractPosition(match);
        return this.openURI(toOpen, position);
    }
    async openURI(toOpen, position) {
        let options = {};
        if (position) {
            options = { selection: { start: position } };
        }
        try {
            const opener = await this.openerService.getOpener(toOpen, options);
            opener.open(toOpen, options);
        }
        catch (err) {
            console.error('Cannot open link ' + toOpen, err);
        }
    }
    async extractPosition(link) {
        const matches = (await this.createRegExp()).exec(link);
        const info = { line: 1, character: 1 };
        if (!matches) {
            return info;
        }
        const lineAndColumnMatchIndex = this.getLineAndColumnMatchIndex();
        for (let i = 0; i < lineAndColumnClause.length; i++) {
            const lineMatchIndex = lineAndColumnMatchIndex + (lineAndColumnClauseGroupCount * i);
            const rowNumber = matches[lineMatchIndex];
            if (rowNumber) {
                info.line = parseInt(rowNumber, 10) - 1;
                const columnNumber = matches[lineMatchIndex + 2];
                if (columnNumber) {
                    info.character = parseInt(columnNumber, 10) - 1;
                }
                break;
            }
        }
        return info;
    }
    getLineAndColumnMatchIndex() {
        return core_1.OS.backend.isWindows ? winLineAndColumnMatchIndex : unixLineAndColumnMatchIndex;
    }
};
exports.FileLinkProvider = FileLinkProvider;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.OpenerService),
    tslib_1.__metadata("design:type", Object)
], FileLinkProvider.prototype, "openerService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.QuickInputService),
    tslib_1.__metadata("design:type", Object)
], FileLinkProvider.prototype, "quickInputService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], FileLinkProvider.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_search_service_1.FileSearchService),
    tslib_1.__metadata("design:type", Object)
], FileLinkProvider.prototype, "searchService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.WorkspaceService),
    tslib_1.__metadata("design:type", browser_2.WorkspaceService)
], FileLinkProvider.prototype, "workspaceService", void 0);
exports.FileLinkProvider = FileLinkProvider = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], FileLinkProvider);
let FileDiffPreLinkProvider = class FileDiffPreLinkProvider extends FileLinkProvider {
    async createRegExp() {
        return /^--- a\/(\S*)/g;
    }
};
exports.FileDiffPreLinkProvider = FileDiffPreLinkProvider;
exports.FileDiffPreLinkProvider = FileDiffPreLinkProvider = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], FileDiffPreLinkProvider);
let FileDiffPostLinkProvider = class FileDiffPostLinkProvider extends FileLinkProvider {
    async createRegExp() {
        return /^\+\+\+ b\/(\S*)/g;
    }
};
exports.FileDiffPostLinkProvider = FileDiffPostLinkProvider;
exports.FileDiffPostLinkProvider = FileDiffPostLinkProvider = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], FileDiffPostLinkProvider);
let LocalFileLinkProvider = class LocalFileLinkProvider extends FileLinkProvider {
    async createRegExp() {
        // match links that might not start with a separator, e.g. 'foo.bar', but don't match single words e.g. 'foo'
        const baseLocalUnixLinkClause = '((' + pathPrefix + '|' +
            '(' + excludedPathCharactersClause + '+(' + pathSeparatorClause + '|' + '\\.' + ')' + excludedPathCharactersClause + '+))' +
            '(' + pathSeparatorClause + '(' + excludedPathCharactersClause + ')+)*)';
        const baseLocalWindowsLinkClause = '((' + winPathPrefix + '|' +
            '(' + winExcludedPathCharactersClause + '+(' + winPathSeparatorClause + '|' + '\\.' + ')' + winExcludedPathCharactersClause + '+))' +
            '(' + winPathSeparatorClause + '(' + winExcludedPathCharactersClause + ')+)*)';
        const baseLocalLinkClause = core_1.OS.backend.isWindows ? baseLocalWindowsLinkClause : baseLocalUnixLinkClause;
        return new RegExp(`${baseLocalLinkClause}(${lineAndColumnClause})`, 'g');
    }
    async provideLinks(line, terminal) {
        const links = [];
        const regExp = await this.createRegExp();
        let regExpResult;
        while (regExpResult = regExp.exec(line)) {
            const match = regExpResult[0];
            const searchTerm = await this.extractPath(match);
            if (searchTerm) {
                links.push({
                    startIndex: regExp.lastIndex - match.length,
                    length: match.length,
                    handle: async () => {
                        const fileUri = await this.isValidWorkspaceFile(searchTerm, terminal);
                        if (fileUri) {
                            const position = await this.extractPosition(match);
                            this.openURI(fileUri, position);
                        }
                        else {
                            this.quickInputService.open(match);
                        }
                    }
                });
            }
        }
        return links;
    }
    getLineAndColumnMatchIndex() {
        return core_1.OS.backend.isWindows ? 14 : 12;
    }
    async isValidWorkspaceFile(searchTerm, terminal) {
        if (!searchTerm) {
            return undefined;
        }
        const cwd = await this.getCwd(terminal);
        // remove any leading ./, ../ etc. as they can't be searched
        searchTerm = searchTerm.replace(/^(\.+[\\/])+/, '');
        const workspaceRoots = this.workspaceService.tryGetRoots().map(root => root.resource.toString());
        // try and find a matching file in the workspace
        const files = (await this.searchService.find(searchTerm, {
            rootUris: [cwd.toString(), ...workspaceRoots],
            fuzzyMatch: true,
            limit: 1
        }));
        // checks if the string ends in a separator + searchTerm
        const regex = new RegExp(`[\\\\|\\/]${searchTerm}$`);
        if (files.length && regex.test(files[0])) {
            const fileUri = new uri_1.default(files[0]);
            const valid = await this.isValidFileURI(fileUri);
            if (valid) {
                return fileUri;
            }
        }
    }
};
exports.LocalFileLinkProvider = LocalFileLinkProvider;
exports.LocalFileLinkProvider = LocalFileLinkProvider = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], LocalFileLinkProvider);
// The following regular expressions are taken from:
// https://github.com/microsoft/vscode/blob/b118105bf28d773fbbce683f7230d058be2f89a7/src/vs/workbench/contrib/terminal/browser/links/terminalLocalLinkDetector.ts#L34-L58
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
const pathPrefix = '(\\.\\.?|\\~)';
const pathSeparatorClause = '\\/';
// '":; are allowed in paths but they are often separators so ignore them
// Also disallow \\ to prevent a catastrophic backtracking case #24795
const excludedPathCharactersClause = '[^\\0\\s!`&*()\\[\\]\'":;\\\\]';
/** A regex that matches paths in the form /foo, ~/foo, ./foo, ../foo, foo/bar */
const unixLocalLinkClause = '((' + pathPrefix + '|(' + excludedPathCharactersClause + ')+)?(' + pathSeparatorClause + '(' + excludedPathCharactersClause + ')+)+)';
const winDrivePrefix = '(?:\\\\\\\\\\?\\\\)?[a-zA-Z]:';
const winPathPrefix = '(' + winDrivePrefix + '|\\.\\.?|\\~)';
const winPathSeparatorClause = '(\\\\|\\/)';
const winExcludedPathCharactersClause = '[^\\0<>\\?\\|\\/\\s!`&*()\\[\\]\'":;]';
/** A regex that matches paths in the form \\?\c:\foo c:\foo, ~\foo, .\foo, ..\foo, foo\bar */
const winLocalLinkClause = '((' + winPathPrefix + '|(' + winExcludedPathCharactersClause + ')+)?(' + winPathSeparatorClause + '(' + winExcludedPathCharactersClause + ')+)+)';
/** As xterm reads from DOM, space in that case is non-breaking char ASCII code - 160, replacing space with nonBreakingSpace or space ASCII code - 32. */
const lineAndColumnClause = [
    // "(file path)", line 45 [see #40468]
    '((\\S*)[\'"], line ((\\d+)( column (\\d+))?))',
    // "(file path)",45 [see #78205]
    '((\\S*)[\'"],((\\d+)(:(\\d+))?))',
    // (file path) on line 8, column 13
    '((\\S*) on line ((\\d+)(, column (\\d+))?))',
    // (file path):line 8, column 13
    '((\\S*):line ((\\d+)(, column (\\d+))?))',
    // (file path)(45), (file path) (45), (file path)(45,18), (file path) (45,18), (file path)(45, 18), (file path) (45, 18), also with []
    '(([^\\s\\(\\)]*)(\\s?[\\(\\[](\\d+)(,\\s?(\\d+))?)[\\)\\]])',
    // (file path):336, (file path):336:9
    '(([^:\\s\\(\\)<>\'\"\\[\\]]*)(:(\\d+))?(:(\\d+))?)'
].join('|').replace(/ /g, `[${'\u00A0'} ]`);
// Changing any regex may effect this value, hence changes this as well if required.
const winLineAndColumnMatchIndex = 12;
const unixLineAndColumnMatchIndex = 11;
// Each line and column clause have 6 groups (ie no. of expressions in round brackets)
const lineAndColumnClauseGroupCount = 6;


/***/ }),

/***/ "../../node_modules/@theia/terminal/lib/browser/terminal-frontend-module.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@theia/terminal/lib/browser/terminal-frontend-module.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
__webpack_require__(/*! ../../src/browser/style/terminal.css */ "../../node_modules/@theia/terminal/src/browser/style/terminal.css");
__webpack_require__(/*! xterm/css/xterm.css */ "../../node_modules/xterm/css/xterm.css");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const tab_bar_toolbar_1 = __webpack_require__(/*! @theia/core/lib/browser/shell/tab-bar-toolbar */ "../../node_modules/@theia/core/lib/browser/shell/tab-bar-toolbar/index.js");
const terminal_frontend_contribution_1 = __webpack_require__(/*! ./terminal-frontend-contribution */ "../../node_modules/@theia/terminal/lib/browser/terminal-frontend-contribution.js");
const terminal_widget_impl_1 = __webpack_require__(/*! ./terminal-widget-impl */ "../../node_modules/@theia/terminal/lib/browser/terminal-widget-impl.js");
const terminal_widget_1 = __webpack_require__(/*! ./base/terminal-widget */ "../../node_modules/@theia/terminal/lib/browser/base/terminal-widget.js");
const terminal_protocol_1 = __webpack_require__(/*! ../common/terminal-protocol */ "../../node_modules/@theia/terminal/lib/common/terminal-protocol.js");
const terminal_watcher_1 = __webpack_require__(/*! ../common/terminal-watcher */ "../../node_modules/@theia/terminal/lib/common/terminal-watcher.js");
const shell_terminal_protocol_1 = __webpack_require__(/*! ../common/shell-terminal-protocol */ "../../node_modules/@theia/terminal/lib/common/shell-terminal-protocol.js");
const terminal_service_1 = __webpack_require__(/*! ./base/terminal-service */ "../../node_modules/@theia/terminal/lib/browser/base/terminal-service.js");
const terminal_preferences_1 = __webpack_require__(/*! ./terminal-preferences */ "../../node_modules/@theia/terminal/lib/browser/terminal-preferences.js");
const terminal_contribution_1 = __webpack_require__(/*! ./terminal-contribution */ "../../node_modules/@theia/terminal/lib/browser/terminal-contribution.js");
const terminal_search_widget_1 = __webpack_require__(/*! ./search/terminal-search-widget */ "../../node_modules/@theia/terminal/lib/browser/search/terminal-search-widget.js");
const terminal_quick_open_service_1 = __webpack_require__(/*! ./terminal-quick-open-service */ "../../node_modules/@theia/terminal/lib/browser/terminal-quick-open-service.js");
const terminal_search_container_1 = __webpack_require__(/*! ./search/terminal-search-container */ "../../node_modules/@theia/terminal/lib/browser/search/terminal-search-container.js");
const terminal_copy_on_selection_handler_1 = __webpack_require__(/*! ./terminal-copy-on-selection-handler */ "../../node_modules/@theia/terminal/lib/browser/terminal-copy-on-selection-handler.js");
const color_application_contribution_1 = __webpack_require__(/*! @theia/core/lib/browser/color-application-contribution */ "../../node_modules/@theia/core/lib/browser/color-application-contribution.js");
const terminal_theme_service_1 = __webpack_require__(/*! ./terminal-theme-service */ "../../node_modules/@theia/terminal/lib/browser/terminal-theme-service.js");
const quick_access_1 = __webpack_require__(/*! @theia/core/lib/browser/quick-input/quick-access */ "../../node_modules/@theia/core/lib/browser/quick-input/quick-access.js");
const terminal_link_provider_1 = __webpack_require__(/*! ./terminal-link-provider */ "../../node_modules/@theia/terminal/lib/browser/terminal-link-provider.js");
const terminal_url_link_provider_1 = __webpack_require__(/*! ./terminal-url-link-provider */ "../../node_modules/@theia/terminal/lib/browser/terminal-url-link-provider.js");
const terminal_file_link_provider_1 = __webpack_require__(/*! ./terminal-file-link-provider */ "../../node_modules/@theia/terminal/lib/browser/terminal-file-link-provider.js");
const terminal_profile_service_1 = __webpack_require__(/*! ./terminal-profile-service */ "../../node_modules/@theia/terminal/lib/browser/terminal-profile-service.js");
exports["default"] = new inversify_1.ContainerModule(bind => {
    (0, terminal_preferences_1.bindTerminalPreferences)(bind);
    bind(terminal_widget_1.TerminalWidget).to(terminal_widget_impl_1.TerminalWidgetImpl).inTransientScope();
    bind(terminal_watcher_1.TerminalWatcher).toSelf().inSingletonScope();
    let terminalNum = 0;
    bind(browser_1.WidgetFactory).toDynamicValue(ctx => ({
        id: terminal_widget_impl_1.TERMINAL_WIDGET_FACTORY_ID,
        createWidget: (options) => {
            const child = new inversify_1.Container({ defaultScope: 'Singleton' });
            child.parent = ctx.container;
            const counter = terminalNum++;
            const domId = options.id || 'terminal-' + counter;
            const widgetOptions = {
                title: `${common_1.nls.localizeByDefault('Terminal')} ${counter}`,
                useServerTitle: true,
                destroyTermOnClose: true,
                ...options
            };
            child.bind(terminal_widget_1.TerminalWidgetOptions).toConstantValue(widgetOptions);
            child.bind('terminal-dom-id').toConstantValue(domId);
            child.bind(terminal_search_widget_1.TerminalSearchWidgetFactory).toDynamicValue(context => (0, terminal_search_container_1.createTerminalSearchFactory)(context.container));
            return child.get(terminal_widget_1.TerminalWidget);
        }
    }));
    bind(terminal_quick_open_service_1.TerminalQuickOpenService).toSelf().inSingletonScope();
    bind(terminal_copy_on_selection_handler_1.TerminalCopyOnSelectionHandler).toSelf().inSingletonScope();
    bind(terminal_quick_open_service_1.TerminalQuickOpenContribution).toSelf().inSingletonScope();
    for (const identifier of [common_1.CommandContribution, quick_access_1.QuickAccessContribution]) {
        bind(identifier).toService(terminal_quick_open_service_1.TerminalQuickOpenContribution);
    }
    bind(terminal_theme_service_1.TerminalThemeService).toSelf().inSingletonScope();
    bind(terminal_frontend_contribution_1.TerminalFrontendContribution).toSelf().inSingletonScope();
    bind(terminal_service_1.TerminalService).toService(terminal_frontend_contribution_1.TerminalFrontendContribution);
    for (const identifier of [common_1.CommandContribution, common_1.MenuContribution, browser_1.KeybindingContribution, tab_bar_toolbar_1.TabBarToolbarContribution, color_application_contribution_1.ColorContribution]) {
        bind(identifier).toService(terminal_frontend_contribution_1.TerminalFrontendContribution);
    }
    bind(terminal_protocol_1.ITerminalServer).toDynamicValue(ctx => {
        const connection = ctx.container.get(browser_1.WebSocketConnectionProvider);
        const terminalWatcher = ctx.container.get(terminal_watcher_1.TerminalWatcher);
        return connection.createProxy(terminal_protocol_1.terminalPath, terminalWatcher.getTerminalClient());
    }).inSingletonScope();
    bind(shell_terminal_protocol_1.ShellTerminalServerProxy).toDynamicValue(ctx => {
        const connection = ctx.container.get(browser_1.WebSocketConnectionProvider);
        const terminalWatcher = ctx.container.get(terminal_watcher_1.TerminalWatcher);
        return connection.createProxy(shell_terminal_protocol_1.shellTerminalPath, terminalWatcher.getTerminalClient());
    }).inSingletonScope();
    bind(shell_terminal_protocol_1.IShellTerminalServer).toService(shell_terminal_protocol_1.ShellTerminalServerProxy);
    (0, core_1.bindContributionProvider)(bind, terminal_contribution_1.TerminalContribution);
    // terminal link provider contribution point
    (0, core_1.bindContributionProvider)(bind, terminal_link_provider_1.TerminalLinkProvider);
    bind(terminal_link_provider_1.TerminalLinkProviderContribution).toSelf().inSingletonScope();
    bind(terminal_contribution_1.TerminalContribution).toService(terminal_link_provider_1.TerminalLinkProviderContribution);
    bind(terminal_link_provider_1.XtermLinkFactory).toFactory(terminal_link_provider_1.createXtermLinkFactory);
    // default terminal link provider
    bind(terminal_url_link_provider_1.UrlLinkProvider).toSelf().inSingletonScope();
    bind(terminal_link_provider_1.TerminalLinkProvider).toService(terminal_url_link_provider_1.UrlLinkProvider);
    bind(terminal_file_link_provider_1.FileLinkProvider).toSelf().inSingletonScope();
    bind(terminal_link_provider_1.TerminalLinkProvider).toService(terminal_file_link_provider_1.FileLinkProvider);
    bind(terminal_file_link_provider_1.FileDiffPreLinkProvider).toSelf().inSingletonScope();
    bind(terminal_link_provider_1.TerminalLinkProvider).toService(terminal_file_link_provider_1.FileDiffPreLinkProvider);
    bind(terminal_file_link_provider_1.FileDiffPostLinkProvider).toSelf().inSingletonScope();
    bind(terminal_link_provider_1.TerminalLinkProvider).toService(terminal_file_link_provider_1.FileDiffPostLinkProvider);
    bind(terminal_file_link_provider_1.LocalFileLinkProvider).toSelf().inSingletonScope();
    bind(terminal_link_provider_1.TerminalLinkProvider).toService(terminal_file_link_provider_1.LocalFileLinkProvider);
    bind(terminal_profile_service_1.ContributedTerminalProfileStore).to(terminal_profile_service_1.DefaultProfileStore).inSingletonScope();
    bind(terminal_profile_service_1.UserTerminalProfileStore).to(terminal_profile_service_1.DefaultProfileStore).inSingletonScope();
    bind(terminal_profile_service_1.TerminalProfileService).toDynamicValue(ctx => {
        const userStore = ctx.container.get(terminal_profile_service_1.UserTerminalProfileStore);
        const contributedStore = ctx.container.get(terminal_profile_service_1.ContributedTerminalProfileStore);
        return new terminal_profile_service_1.DefaultTerminalProfileService(userStore, contributedStore);
    }).inSingletonScope();
    bind(browser_1.FrontendApplicationContribution).toService(terminal_frontend_contribution_1.TerminalFrontendContribution);
});


/***/ }),

/***/ "../../node_modules/@theia/terminal/lib/browser/terminal-quick-open-service.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@theia/terminal/lib/browser/terminal-quick-open-service.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2019 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var TerminalQuickOpenService_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TerminalQuickOpenContribution = exports.TerminalQuickOpenService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const terminal_service_1 = __webpack_require__(/*! ./base/terminal-service */ "../../node_modules/@theia/terminal/lib/browser/base/terminal-service.js");
const terminal_frontend_contribution_1 = __webpack_require__(/*! ./terminal-frontend-contribution */ "../../node_modules/@theia/terminal/lib/browser/terminal-frontend-contribution.js");
const quick_input_service_1 = __webpack_require__(/*! @theia/core/lib/browser/quick-input/quick-input-service */ "../../node_modules/@theia/core/lib/browser/quick-input/quick-input-service.js");
let TerminalQuickOpenService = TerminalQuickOpenService_1 = class TerminalQuickOpenService {
    open() {
        var _a;
        (_a = this.quickInputService) === null || _a === void 0 ? void 0 : _a.open(TerminalQuickOpenService_1.PREFIX);
    }
    async getPicks(filter, token) {
        const items = [];
        // Get the sorted list of currently opened terminal widgets that aren't hidden from users
        const widgets = this.terminalService.all.filter(widget => !widget.hiddenFromUser)
            .sort((a, b) => this.compareItems(a, b));
        for (const widget of widgets) {
            items.push(this.toItem(widget));
        }
        // Append a quick open item to create a new terminal.
        items.push({
            label: common_1.nls.localizeByDefault('Create New Terminal'),
            iconClasses: (0, browser_1.codiconArray)('add'),
            execute: () => this.doCreateNewTerminal()
        });
        return (0, quick_input_service_1.filterItems)(items, filter);
    }
    registerQuickAccessProvider() {
        this.quickAccessRegistry.registerQuickAccessProvider({
            getInstance: () => this,
            prefix: TerminalQuickOpenService_1.PREFIX,
            placeholder: '',
            helpEntries: [{ description: common_1.nls.localizeByDefault('Show All Opened Terminals'), needsEditor: false }]
        });
    }
    /**
     * Compare two terminal widgets by label. If labels are identical, compare by the widget id.
     * @param a `TerminalWidget` for comparison
     * @param b `TerminalWidget` for comparison
     */
    compareItems(a, b) {
        const normalize = (str) => str.trim().toLowerCase();
        if (normalize(a.title.label) !== normalize(b.title.label)) {
            return normalize(a.title.label).localeCompare(normalize(b.title.label));
        }
        else {
            return normalize(a.id).localeCompare(normalize(b.id));
        }
    }
    doCreateNewTerminal() {
        this.commandService.executeCommand(terminal_frontend_contribution_1.TerminalCommands.NEW.id);
    }
    /**
     * Convert the terminal widget to the quick pick item.
     * @param {TerminalWidget} widget - the terminal widget.
     * @returns quick pick item.
     */
    toItem(widget) {
        return {
            label: widget.title.label,
            description: widget.id,
            ariaLabel: widget.title.label,
            execute: () => this.terminalService.open(widget)
        };
    }
};
exports.TerminalQuickOpenService = TerminalQuickOpenService;
TerminalQuickOpenService.PREFIX = 'term ';
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.QuickInputService),
    (0, inversify_1.optional)(),
    tslib_1.__metadata("design:type", Object)
], TerminalQuickOpenService.prototype, "quickInputService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.QuickAccessRegistry),
    tslib_1.__metadata("design:type", Object)
], TerminalQuickOpenService.prototype, "quickAccessRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.CommandService),
    tslib_1.__metadata("design:type", Object)
], TerminalQuickOpenService.prototype, "commandService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(terminal_service_1.TerminalService),
    tslib_1.__metadata("design:type", Object)
], TerminalQuickOpenService.prototype, "terminalService", void 0);
exports.TerminalQuickOpenService = TerminalQuickOpenService = TerminalQuickOpenService_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], TerminalQuickOpenService);
/**
 * TODO: merge it to TerminalFrontendContribution.
 */
let TerminalQuickOpenContribution = class TerminalQuickOpenContribution {
    registerQuickAccessProvider() {
        this.terminalQuickOpenService.registerQuickAccessProvider();
    }
    registerCommands(commands) {
        commands.registerCommand(terminal_frontend_contribution_1.TerminalCommands.SHOW_ALL_OPENED_TERMINALS, {
            execute: () => this.terminalQuickOpenService.open()
        });
    }
};
exports.TerminalQuickOpenContribution = TerminalQuickOpenContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(TerminalQuickOpenService),
    tslib_1.__metadata("design:type", TerminalQuickOpenService)
], TerminalQuickOpenContribution.prototype, "terminalQuickOpenService", void 0);
exports.TerminalQuickOpenContribution = TerminalQuickOpenContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], TerminalQuickOpenContribution);


/***/ }),

/***/ "../../node_modules/@theia/terminal/lib/browser/terminal-url-link-provider.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@theia/terminal/lib/browser/terminal-url-link-provider.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2022 STMicroelectronics and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UrlLinkProvider = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
let UrlLinkProvider = class UrlLinkProvider {
    constructor() {
        this.urlRegExp = /https?:\/\/(www\.)?[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,4}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)/g;
        this.localhostRegExp = /(https?:\/\/)?(localhost|127\.0\.0\.1|0\.0\.0\.0)(:[0-9]{1,5})?([-a-zA-Z0-9@:%_\+.~#?&//=]*)/g;
    }
    async provideLinks(line, terminal) {
        return [...this.matchUrlLinks(line), ...this.matchLocalhostLinks(line)];
    }
    matchUrlLinks(line) {
        const links = [];
        let regExpResult;
        while (regExpResult = this.urlRegExp.exec(line)) {
            const match = regExpResult[0];
            links.push({
                startIndex: this.urlRegExp.lastIndex - match.length,
                length: match.length,
                handle: () => (0, browser_1.open)(this.openerService, new uri_1.default(match)).then()
            });
        }
        return links;
    }
    matchLocalhostLinks(line) {
        const links = [];
        let regExpResult;
        while (regExpResult = this.localhostRegExp.exec(line)) {
            const match = regExpResult[0];
            links.push({
                startIndex: this.localhostRegExp.lastIndex - match.length,
                length: match.length,
                handle: async () => {
                    const uri = match.startsWith('http') ? match : `http://${match}`;
                    (0, browser_1.open)(this.openerService, new uri_1.default(uri));
                }
            });
        }
        return links;
    }
};
exports.UrlLinkProvider = UrlLinkProvider;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.OpenerService),
    tslib_1.__metadata("design:type", Object)
], UrlLinkProvider.prototype, "openerService", void 0);
exports.UrlLinkProvider = UrlLinkProvider = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], UrlLinkProvider);


/***/ }),

/***/ "../../node_modules/@theia/terminal/lib/common/shell-terminal-protocol.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/terminal/lib/common/shell-terminal-protocol.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2017 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EnvironmentVariableMutatorType = exports.NO_ROOT_URI = exports.ShellTerminalServerProxy = exports.shellTerminalPath = exports.IShellTerminalServer = void 0;
exports.IShellTerminalServer = Symbol('IShellTerminalServer');
exports.shellTerminalPath = '/services/shell-terminal';
;
exports.ShellTerminalServerProxy = Symbol('ShellTerminalServerProxy');
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
// some code copied and modified from https://github.com/microsoft/vscode/blob/1.49.0/src/vs/workbench/contrib/terminal/common/environmentVariable.ts
exports.NO_ROOT_URI = '<none>';
var EnvironmentVariableMutatorType;
(function (EnvironmentVariableMutatorType) {
    EnvironmentVariableMutatorType[EnvironmentVariableMutatorType["Replace"] = 1] = "Replace";
    EnvironmentVariableMutatorType[EnvironmentVariableMutatorType["Append"] = 2] = "Append";
    EnvironmentVariableMutatorType[EnvironmentVariableMutatorType["Prepend"] = 3] = "Prepend";
})(EnvironmentVariableMutatorType || (exports.EnvironmentVariableMutatorType = EnvironmentVariableMutatorType = {}));
;


/***/ }),

/***/ "../../node_modules/@theia/terminal/src/browser/style/terminal.css":
/*!*************************************************************************!*\
  !*** ../../node_modules/@theia/terminal/src/browser/style/terminal.css ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_cjs_js_terminal_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../css-loader/dist/cjs.js!./terminal.css */ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/terminal/src/browser/style/terminal.css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_css_loader_dist_cjs_js_terminal_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_css_loader_dist_cjs_js_terminal_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/index.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-commands */ "../../node_modules/@theia/workspace/lib/browser/workspace-commands.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./canonical-uri-service */ "../../node_modules/@theia/workspace/lib/browser/canonical-uri-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-frontend-contribution */ "../../node_modules/@theia/workspace/lib/browser/workspace-frontend-contribution.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-frontend-module */ "../../node_modules/@theia/workspace/lib/browser/workspace-frontend-module.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-preferences */ "../../node_modules/@theia/workspace/lib/browser/workspace-preferences.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-trust-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-trust-service.js"), exports);


/***/ }),

/***/ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/terminal/src/browser/style/terminal.css":
/*!*******************************************************************************************************************!*\
  !*** ../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/terminal/src/browser/style/terminal.css ***!
  \*******************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/sourceMaps.js */ "../../node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/api.js */ "../../node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
 ********************************************************************************/

.terminal-container {
  width: 100%;
  height: 100%;
  padding: var(--theia-code-padding);
  background: var(--theia-terminal-background);
}

.xterm .xterm-screen canvas {
  /* fix random 1px white border on terminal in Firefox. See https://github.com/eclipse-theia/theia/issues/4665 */
  border: 1px solid var(--theia-terminal-background);
}

.terminal-container .xterm .xterm-helper-textarea {
  /* fix secondary cursor-like issue. See https://github.com/eclipse-theia/theia/issues/8158 */
  opacity: 0 !important;
}
`, "",{"version":3,"sources":["webpack://./../../node_modules/@theia/terminal/src/browser/style/terminal.css"],"names":[],"mappings":"AAAA;;;;;;;;;;;;;;iFAciF;;AAEjF;EACE,WAAW;EACX,YAAY;EACZ,kCAAkC;EAClC,4CAA4C;AAC9C;;AAEA;EACE,+GAA+G;EAC/G,kDAAkD;AACpD;;AAEA;EACE,4FAA4F;EAC5F,qBAAqB;AACvB","sourcesContent":["/********************************************************************************\n * Copyright (C) 2017 TypeFox and others.\n *\n * This program and the accompanying materials are made available under the\n * terms of the Eclipse Public License v. 2.0 which is available at\n * http://www.eclipse.org/legal/epl-2.0.\n *\n * This Source Code may also be made available under the following Secondary\n * Licenses when the conditions for such availability set forth in the Eclipse\n * Public License v. 2.0 are satisfied: GNU General Public License, version 2\n * with the GNU Classpath Exception which is available at\n * https://www.gnu.org/software/classpath/license.html.\n *\n * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0\n ********************************************************************************/\n\n.terminal-container {\n  width: 100%;\n  height: 100%;\n  padding: var(--theia-code-padding);\n  background: var(--theia-terminal-background);\n}\n\n.xterm .xterm-screen canvas {\n  /* fix random 1px white border on terminal in Firefox. See https://github.com/eclipse-theia/theia/issues/4665 */\n  border: 1px solid var(--theia-terminal-background);\n}\n\n.terminal-container .xterm .xterm-helper-textarea {\n  /* fix secondary cursor-like issue. See https://github.com/eclipse-theia/theia/issues/8158 */\n  opacity: 0 !important;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/xterm/css/xterm.css":
/*!****************************************************************************************!*\
  !*** ../../node_modules/css-loader/dist/cjs.js!../../node_modules/xterm/css/xterm.css ***!
  \****************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../css-loader/dist/runtime/sourceMaps.js */ "../../node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../css-loader/dist/runtime/api.js */ "../../node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/**
 * Copyright (c) 2014 The xterm.js authors. All rights reserved.
 * Copyright (c) 2012-2013, Christopher Jeffrey (MIT License)
 * https://github.com/chjj/term.js
 * @license MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * Originally forked from (with the author's permission):
 *   Fabrice Bellard's javascript vt100 for jslinux:
 *   http://bellard.org/jslinux/
 *   Copyright (c) 2011 Fabrice Bellard
 *   The original design remains. The terminal itself
 *   has been extended to include xterm CSI codes, among
 *   other features.
 */

/**
 *  Default styles for xterm.js
 */

.xterm {
    cursor: text;
    position: relative;
    user-select: none;
    -ms-user-select: none;
    -webkit-user-select: none;
}

.xterm.focus,
.xterm:focus {
    outline: none;
}

.xterm .xterm-helpers {
    position: absolute;
    top: 0;
    /**
     * The z-index of the helpers must be higher than the canvases in order for
     * IMEs to appear on top.
     */
    z-index: 5;
}

.xterm .xterm-helper-textarea {
    padding: 0;
    border: 0;
    margin: 0;
    /* Move textarea out of the screen to the far left, so that the cursor is not visible */
    position: absolute;
    opacity: 0;
    left: -9999em;
    top: 0;
    width: 0;
    height: 0;
    z-index: -5;
    /** Prevent wrapping so the IME appears against the textarea at the correct position */
    white-space: nowrap;
    overflow: hidden;
    resize: none;
}

.xterm .composition-view {
    /* TODO: Composition position got messed up somewhere */
    background: #000;
    color: #FFF;
    display: none;
    position: absolute;
    white-space: nowrap;
    z-index: 1;
}

.xterm .composition-view.active {
    display: block;
}

.xterm .xterm-viewport {
    /* On OS X this is required in order for the scroll bar to appear fully opaque */
    background-color: #000;
    overflow-y: scroll;
    cursor: default;
    position: absolute;
    right: 0;
    left: 0;
    top: 0;
    bottom: 0;
}

.xterm .xterm-screen {
    position: relative;
}

.xterm .xterm-screen canvas {
    position: absolute;
    left: 0;
    top: 0;
}

.xterm .xterm-scroll-area {
    visibility: hidden;
}

.xterm-char-measure-element {
    display: inline-block;
    visibility: hidden;
    position: absolute;
    top: 0;
    left: -9999em;
    line-height: normal;
}

.xterm.enable-mouse-events {
    /* When mouse events are enabled (eg. tmux), revert to the standard pointer cursor */
    cursor: default;
}

.xterm.xterm-cursor-pointer,
.xterm .xterm-cursor-pointer {
    cursor: pointer;
}

.xterm.column-select.focus {
    /* Column selection mode */
    cursor: crosshair;
}

.xterm .xterm-accessibility,
.xterm .xterm-message {
    position: absolute;
    left: 0;
    top: 0;
    bottom: 0;
    right: 0;
    z-index: 10;
    color: transparent;
    pointer-events: none;
}

.xterm .live-region {
    position: absolute;
    left: -9999px;
    width: 1px;
    height: 1px;
    overflow: hidden;
}

.xterm-dim {
    /* Dim should not apply to background, so the opacity of the foreground color is applied
     * explicitly in the generated class and reset to 1 here */
    opacity: 1 !important;
}

.xterm-underline-1 { text-decoration: underline; }
.xterm-underline-2 { text-decoration: double underline; }
.xterm-underline-3 { text-decoration: wavy underline; }
.xterm-underline-4 { text-decoration: dotted underline; }
.xterm-underline-5 { text-decoration: dashed underline; }

.xterm-overline {
    text-decoration: overline;
}

.xterm-overline.xterm-underline-1 { text-decoration: overline underline; }
.xterm-overline.xterm-underline-2 { text-decoration: overline double underline; }
.xterm-overline.xterm-underline-3 { text-decoration: overline wavy underline; }
.xterm-overline.xterm-underline-4 { text-decoration: overline dotted underline; }
.xterm-overline.xterm-underline-5 { text-decoration: overline dashed underline; }

.xterm-strikethrough {
    text-decoration: line-through;
}

.xterm-screen .xterm-decoration-container .xterm-decoration {
	z-index: 6;
	position: absolute;
}

.xterm-screen .xterm-decoration-container .xterm-decoration.xterm-decoration-top-layer {
	z-index: 7;
}

.xterm-decoration-overview-ruler {
    z-index: 8;
    position: absolute;
    top: 0;
    right: 0;
    pointer-events: none;
}

.xterm-decoration-top {
    z-index: 2;
    position: relative;
}
`, "",{"version":3,"sources":["webpack://./../../node_modules/xterm/css/xterm.css"],"names":[],"mappings":"AAAA;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;EA+BE;;AAEF;;EAEE;;AAEF;IACI,YAAY;IACZ,kBAAkB;IAClB,iBAAiB;IACjB,qBAAqB;IACrB,yBAAyB;AAC7B;;AAEA;;IAEI,aAAa;AACjB;;AAEA;IACI,kBAAkB;IAClB,MAAM;IACN;;;MAGE;IACF,UAAU;AACd;;AAEA;IACI,UAAU;IACV,SAAS;IACT,SAAS;IACT,uFAAuF;IACvF,kBAAkB;IAClB,UAAU;IACV,aAAa;IACb,MAAM;IACN,QAAQ;IACR,SAAS;IACT,WAAW;IACX,sFAAsF;IACtF,mBAAmB;IACnB,gBAAgB;IAChB,YAAY;AAChB;;AAEA;IACI,uDAAuD;IACvD,gBAAgB;IAChB,WAAW;IACX,aAAa;IACb,kBAAkB;IAClB,mBAAmB;IACnB,UAAU;AACd;;AAEA;IACI,cAAc;AAClB;;AAEA;IACI,gFAAgF;IAChF,sBAAsB;IACtB,kBAAkB;IAClB,eAAe;IACf,kBAAkB;IAClB,QAAQ;IACR,OAAO;IACP,MAAM;IACN,SAAS;AACb;;AAEA;IACI,kBAAkB;AACtB;;AAEA;IACI,kBAAkB;IAClB,OAAO;IACP,MAAM;AACV;;AAEA;IACI,kBAAkB;AACtB;;AAEA;IACI,qBAAqB;IACrB,kBAAkB;IAClB,kBAAkB;IAClB,MAAM;IACN,aAAa;IACb,mBAAmB;AACvB;;AAEA;IACI,oFAAoF;IACpF,eAAe;AACnB;;AAEA;;IAEI,eAAe;AACnB;;AAEA;IACI,0BAA0B;IAC1B,iBAAiB;AACrB;;AAEA;;IAEI,kBAAkB;IAClB,OAAO;IACP,MAAM;IACN,SAAS;IACT,QAAQ;IACR,WAAW;IACX,kBAAkB;IAClB,oBAAoB;AACxB;;AAEA;IACI,kBAAkB;IAClB,aAAa;IACb,UAAU;IACV,WAAW;IACX,gBAAgB;AACpB;;AAEA;IACI;8DAC0D;IAC1D,qBAAqB;AACzB;;AAEA,qBAAqB,0BAA0B,EAAE;AACjD,qBAAqB,iCAAiC,EAAE;AACxD,qBAAqB,+BAA+B,EAAE;AACtD,qBAAqB,iCAAiC,EAAE;AACxD,qBAAqB,iCAAiC,EAAE;;AAExD;IACI,yBAAyB;AAC7B;;AAEA,oCAAoC,mCAAmC,EAAE;AACzE,oCAAoC,0CAA0C,EAAE;AAChF,oCAAoC,wCAAwC,EAAE;AAC9E,oCAAoC,0CAA0C,EAAE;AAChF,oCAAoC,0CAA0C,EAAE;;AAEhF;IACI,6BAA6B;AACjC;;AAEA;CACC,UAAU;CACV,kBAAkB;AACnB;;AAEA;CACC,UAAU;AACX;;AAEA;IACI,UAAU;IACV,kBAAkB;IAClB,MAAM;IACN,QAAQ;IACR,oBAAoB;AACxB;;AAEA;IACI,UAAU;IACV,kBAAkB;AACtB","sourcesContent":["/**\n * Copyright (c) 2014 The xterm.js authors. All rights reserved.\n * Copyright (c) 2012-2013, Christopher Jeffrey (MIT License)\n * https://github.com/chjj/term.js\n * @license MIT\n *\n * Permission is hereby granted, free of charge, to any person obtaining a copy\n * of this software and associated documentation files (the \"Software\"), to deal\n * in the Software without restriction, including without limitation the rights\n * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell\n * copies of the Software, and to permit persons to whom the Software is\n * furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\n * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN\n * THE SOFTWARE.\n *\n * Originally forked from (with the author's permission):\n *   Fabrice Bellard's javascript vt100 for jslinux:\n *   http://bellard.org/jslinux/\n *   Copyright (c) 2011 Fabrice Bellard\n *   The original design remains. The terminal itself\n *   has been extended to include xterm CSI codes, among\n *   other features.\n */\n\n/**\n *  Default styles for xterm.js\n */\n\n.xterm {\n    cursor: text;\n    position: relative;\n    user-select: none;\n    -ms-user-select: none;\n    -webkit-user-select: none;\n}\n\n.xterm.focus,\n.xterm:focus {\n    outline: none;\n}\n\n.xterm .xterm-helpers {\n    position: absolute;\n    top: 0;\n    /**\n     * The z-index of the helpers must be higher than the canvases in order for\n     * IMEs to appear on top.\n     */\n    z-index: 5;\n}\n\n.xterm .xterm-helper-textarea {\n    padding: 0;\n    border: 0;\n    margin: 0;\n    /* Move textarea out of the screen to the far left, so that the cursor is not visible */\n    position: absolute;\n    opacity: 0;\n    left: -9999em;\n    top: 0;\n    width: 0;\n    height: 0;\n    z-index: -5;\n    /** Prevent wrapping so the IME appears against the textarea at the correct position */\n    white-space: nowrap;\n    overflow: hidden;\n    resize: none;\n}\n\n.xterm .composition-view {\n    /* TODO: Composition position got messed up somewhere */\n    background: #000;\n    color: #FFF;\n    display: none;\n    position: absolute;\n    white-space: nowrap;\n    z-index: 1;\n}\n\n.xterm .composition-view.active {\n    display: block;\n}\n\n.xterm .xterm-viewport {\n    /* On OS X this is required in order for the scroll bar to appear fully opaque */\n    background-color: #000;\n    overflow-y: scroll;\n    cursor: default;\n    position: absolute;\n    right: 0;\n    left: 0;\n    top: 0;\n    bottom: 0;\n}\n\n.xterm .xterm-screen {\n    position: relative;\n}\n\n.xterm .xterm-screen canvas {\n    position: absolute;\n    left: 0;\n    top: 0;\n}\n\n.xterm .xterm-scroll-area {\n    visibility: hidden;\n}\n\n.xterm-char-measure-element {\n    display: inline-block;\n    visibility: hidden;\n    position: absolute;\n    top: 0;\n    left: -9999em;\n    line-height: normal;\n}\n\n.xterm.enable-mouse-events {\n    /* When mouse events are enabled (eg. tmux), revert to the standard pointer cursor */\n    cursor: default;\n}\n\n.xterm.xterm-cursor-pointer,\n.xterm .xterm-cursor-pointer {\n    cursor: pointer;\n}\n\n.xterm.column-select.focus {\n    /* Column selection mode */\n    cursor: crosshair;\n}\n\n.xterm .xterm-accessibility,\n.xterm .xterm-message {\n    position: absolute;\n    left: 0;\n    top: 0;\n    bottom: 0;\n    right: 0;\n    z-index: 10;\n    color: transparent;\n    pointer-events: none;\n}\n\n.xterm .live-region {\n    position: absolute;\n    left: -9999px;\n    width: 1px;\n    height: 1px;\n    overflow: hidden;\n}\n\n.xterm-dim {\n    /* Dim should not apply to background, so the opacity of the foreground color is applied\n     * explicitly in the generated class and reset to 1 here */\n    opacity: 1 !important;\n}\n\n.xterm-underline-1 { text-decoration: underline; }\n.xterm-underline-2 { text-decoration: double underline; }\n.xterm-underline-3 { text-decoration: wavy underline; }\n.xterm-underline-4 { text-decoration: dotted underline; }\n.xterm-underline-5 { text-decoration: dashed underline; }\n\n.xterm-overline {\n    text-decoration: overline;\n}\n\n.xterm-overline.xterm-underline-1 { text-decoration: overline underline; }\n.xterm-overline.xterm-underline-2 { text-decoration: overline double underline; }\n.xterm-overline.xterm-underline-3 { text-decoration: overline wavy underline; }\n.xterm-overline.xterm-underline-4 { text-decoration: overline dotted underline; }\n.xterm-overline.xterm-underline-5 { text-decoration: overline dashed underline; }\n\n.xterm-strikethrough {\n    text-decoration: line-through;\n}\n\n.xterm-screen .xterm-decoration-container .xterm-decoration {\n\tz-index: 6;\n\tposition: absolute;\n}\n\n.xterm-screen .xterm-decoration-container .xterm-decoration.xterm-decoration-top-layer {\n\tz-index: 7;\n}\n\n.xterm-decoration-overview-ruler {\n    z-index: 8;\n    position: absolute;\n    top: 0;\n    right: 0;\n    pointer-events: none;\n}\n\n.xterm-decoration-top {\n    z-index: 2;\n    position: relative;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "../../node_modules/xterm/css/xterm.css":
/*!**********************************************!*\
  !*** ../../node_modules/xterm/css/xterm.css ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_cjs_js_xterm_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../css-loader/dist/cjs.js!./xterm.css */ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/xterm/css/xterm.css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_css_loader_dist_cjs_js_xterm_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_css_loader_dist_cjs_js_xterm_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_terminal_lib_browser_terminal-frontend-module_js.js.map