"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_ai-llamafile_lib_browser_llamafile-frontend-module_js"],{

/***/ "../../node_modules/@theia/ai-core/lib/browser/ai-command-handler-factory.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/browser/ai-command-handler-factory.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AICommandHandlerFactory = void 0;
exports.AICommandHandlerFactory = Symbol('AICommandHandlerFactory');


/***/ }),

/***/ "../../node_modules/@theia/ai-llamafile/lib/browser/llamafile-command-contribution.js":
/*!********************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-llamafile/lib/browser/llamafile-command-contribution.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LlamafileCommandContribution = exports.StopLlamafileCommand = exports.StartLlamafileCommand = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const ai_command_handler_factory_1 = __webpack_require__(/*! @theia/ai-core/lib/browser/ai-command-handler-factory */ "../../node_modules/@theia/ai-core/lib/browser/ai-command-handler-factory.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const llamafile_manager_1 = __webpack_require__(/*! ../common/llamafile-manager */ "../../node_modules/@theia/ai-llamafile/lib/common/llamafile-manager.js");
const llamafile_preferences_1 = __webpack_require__(/*! ./llamafile-preferences */ "../../node_modules/@theia/ai-llamafile/lib/browser/llamafile-preferences.js");
exports.StartLlamafileCommand = {
    id: 'llamafile.start',
    label: core_1.nls.localize('theia/ai/llamaFile/start', 'Start Llamafile'),
};
exports.StopLlamafileCommand = {
    id: 'llamafile.stop',
    label: core_1.nls.localize('theia/ai/llamaFile/stop', 'Stop Llamafile'),
};
let LlamafileCommandContribution = class LlamafileCommandContribution {
    registerCommands(commandRegistry) {
        commandRegistry.registerCommand(exports.StartLlamafileCommand, this.commandHandlerFactory({
            execute: async () => {
                try {
                    const llamaFiles = this.preferenceService.get(llamafile_preferences_1.PREFERENCE_LLAMAFILE);
                    if (llamaFiles === undefined || llamaFiles.length === 0) {
                        this.messageService.error(core_1.nls.localize('theia/ai/llamafile/error/noConfigured', 'No Llamafiles configured.'));
                        return;
                    }
                    const options = llamaFiles.map(llamaFile => ({ label: llamaFile.name }));
                    const result = await this.quickInputService.showQuickPick(options);
                    if (result === undefined) {
                        return;
                    }
                    this.llamafileManager.startServer(result.label);
                }
                catch (error) {
                    console.error('Something went wrong during the llamafile start.', error);
                    this.messageService.error(core_1.nls.localize('theia/ai/llamafile/error/startFailed', 'Something went wrong during the llamafile start: {0}.\nFor more information, see the console.', error.message));
                }
            }
        }));
        commandRegistry.registerCommand(exports.StopLlamafileCommand, this.commandHandlerFactory({
            execute: async () => {
                try {
                    const llamaFiles = await this.llamafileManager.getStartedLlamafiles();
                    if (llamaFiles === undefined || llamaFiles.length === 0) {
                        this.messageService.error(core_1.nls.localize('theia/ai/llamafile/error/noRunning', 'No Llamafiles running.'));
                        return;
                    }
                    const options = llamaFiles.map(llamaFile => ({ label: llamaFile }));
                    const result = await this.quickInputService.showQuickPick(options);
                    if (result === undefined) {
                        return;
                    }
                    this.llamafileManager.stopServer(result.label);
                }
                catch (error) {
                    console.error('Something went wrong during the llamafile stop.', error);
                    this.messageService.error(core_1.nls.localize('theia/ai/llamafile/error/stopFailed', 'Something went wrong during the llamafile stop: {0}.\nFor more information, see the console.', error.message));
                }
            }
        }));
    }
};
exports.LlamafileCommandContribution = LlamafileCommandContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.QuickInputService),
    tslib_1.__metadata("design:type", Object)
], LlamafileCommandContribution.prototype, "quickInputService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_command_handler_factory_1.AICommandHandlerFactory),
    tslib_1.__metadata("design:type", Function)
], LlamafileCommandContribution.prototype, "commandHandlerFactory", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], LlamafileCommandContribution.prototype, "preferenceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.MessageService),
    tslib_1.__metadata("design:type", core_1.MessageService)
], LlamafileCommandContribution.prototype, "messageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(llamafile_manager_1.LlamafileManager),
    tslib_1.__metadata("design:type", Object)
], LlamafileCommandContribution.prototype, "llamafileManager", void 0);
exports.LlamafileCommandContribution = LlamafileCommandContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], LlamafileCommandContribution);


/***/ }),

/***/ "../../node_modules/@theia/ai-llamafile/lib/browser/llamafile-frontend-application-contribution.js":
/*!*********************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-llamafile/lib/browser/llamafile-frontend-application-contribution.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LlamafileFrontendApplicationContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const llamafile_manager_1 = __webpack_require__(/*! ../common/llamafile-manager */ "../../node_modules/@theia/ai-llamafile/lib/common/llamafile-manager.js");
const llamafile_preferences_1 = __webpack_require__(/*! ./llamafile-preferences */ "../../node_modules/@theia/ai-llamafile/lib/browser/llamafile-preferences.js");
let LlamafileFrontendApplicationContribution = class LlamafileFrontendApplicationContribution {
    constructor() {
        this._knownLlamaFiles = new Map();
    }
    onStart() {
        this.preferenceService.ready.then(() => {
            const llamafiles = this.preferenceService.get(llamafile_preferences_1.PREFERENCE_LLAMAFILE, []);
            const validLlamafiles = llamafiles.filter(LlamafileEntry.is);
            const LlamafileModelDescriptions = this.getLLamaFileModelDescriptions(validLlamafiles);
            this.llamafileManager.addLanguageModels(LlamafileModelDescriptions);
            validLlamafiles.forEach(model => this._knownLlamaFiles.set(model.name, model));
            this.preferenceService.onPreferenceChanged(event => {
                if (event.preferenceName === llamafile_preferences_1.PREFERENCE_LLAMAFILE) {
                    const newModels = event.newValue.filter((llamafileEntry) => LlamafileEntry.is(llamafileEntry));
                    this.handleLlamaFilePreferenceChange(newModels);
                }
            });
        });
    }
    getLLamaFileModelDescriptions(llamafiles) {
        return llamafiles.map(llamafile => ({
            name: llamafile.name,
            uri: llamafile.uri,
            port: llamafile.port
        }));
    }
    handleLlamaFilePreferenceChange(newModels) {
        const llamafilesToAdd = newModels.filter(llamafile => !this._knownLlamaFiles.has(llamafile.name) ||
            !LlamafileEntry.equals(this._knownLlamaFiles.get(llamafile.name), llamafile));
        const llamafileIdsToRemove = [...this._knownLlamaFiles.values()].filter(llamafile => !newModels.find(newModel => LlamafileEntry.equals(newModel, llamafile)))
            .map(llamafile => llamafile.name);
        this.llamafileManager.removeLanguageModels(llamafileIdsToRemove);
        llamafileIdsToRemove.forEach(id => this._knownLlamaFiles.delete(id));
        this.llamafileManager.addLanguageModels(this.getLLamaFileModelDescriptions(llamafilesToAdd));
        llamafilesToAdd.forEach(model => this._knownLlamaFiles.set(model.name, model));
    }
};
exports.LlamafileFrontendApplicationContribution = LlamafileFrontendApplicationContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], LlamafileFrontendApplicationContribution.prototype, "preferenceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(llamafile_manager_1.LlamafileManager),
    tslib_1.__metadata("design:type", Object)
], LlamafileFrontendApplicationContribution.prototype, "llamafileManager", void 0);
exports.LlamafileFrontendApplicationContribution = LlamafileFrontendApplicationContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], LlamafileFrontendApplicationContribution);
var LlamafileEntry;
(function (LlamafileEntry) {
    function equals(a, b) {
        return (a.name === b.name &&
            a.uri === b.uri &&
            a.port === b.port);
    }
    LlamafileEntry.equals = equals;
    function is(entry) {
        return (typeof entry === 'object' &&
            // eslint-disable-next-line no-null/no-null
            entry !== null &&
            'name' in entry && typeof entry.name === 'string' &&
            'uri' in entry && typeof entry.uri === 'string' &&
            'port' in entry && typeof entry.port === 'number');
    }
    LlamafileEntry.is = is;
})(LlamafileEntry || (LlamafileEntry = {}));


/***/ }),

/***/ "../../node_modules/@theia/ai-llamafile/lib/browser/llamafile-frontend-module.js":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-llamafile/lib/browser/llamafile-frontend-module.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const output_channel_1 = __webpack_require__(/*! @theia/output/lib/browser/output-channel */ "../../node_modules/@theia/output/lib/browser/output-channel.js");
const llamafile_manager_1 = __webpack_require__(/*! ../common/llamafile-manager */ "../../node_modules/@theia/ai-llamafile/lib/common/llamafile-manager.js");
const llamafile_command_contribution_1 = __webpack_require__(/*! ./llamafile-command-contribution */ "../../node_modules/@theia/ai-llamafile/lib/browser/llamafile-command-contribution.js");
const llamafile_frontend_application_contribution_1 = __webpack_require__(/*! ./llamafile-frontend-application-contribution */ "../../node_modules/@theia/ai-llamafile/lib/browser/llamafile-frontend-application-contribution.js");
const llamafile_preferences_1 = __webpack_require__(/*! ./llamafile-preferences */ "../../node_modules/@theia/ai-llamafile/lib/browser/llamafile-preferences.js");
exports["default"] = new inversify_1.ContainerModule(bind => {
    bind(browser_1.FrontendApplicationContribution).to(llamafile_frontend_application_contribution_1.LlamafileFrontendApplicationContribution).inSingletonScope();
    bind(core_1.CommandContribution).to(llamafile_command_contribution_1.LlamafileCommandContribution).inSingletonScope();
    bind(llamafile_manager_1.LlamafileManager).toDynamicValue(ctx => {
        const connection = ctx.container.get(browser_1.RemoteConnectionProvider);
        const outputChannelManager = ctx.container.get(output_channel_1.OutputChannelManager);
        const client = {
            error: (llamafileName, message) => {
                const channel = outputChannelManager.getChannel(`${llamafileName}-llamafile`);
                channel.appendLine(message, output_channel_1.OutputChannelSeverity.Error);
            },
            log: (llamafileName, message) => {
                const channel = outputChannelManager.getChannel(`${llamafileName}-llamafile`);
                channel.appendLine(message, output_channel_1.OutputChannelSeverity.Info);
            }
        };
        return connection.createProxy(llamafile_manager_1.LlamafileManagerPath, client);
    }).inSingletonScope();
    (0, llamafile_preferences_1.bindAILlamafilePreferences)(bind);
});


/***/ }),

/***/ "../../node_modules/@theia/ai-llamafile/lib/browser/llamafile-preferences.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-llamafile/lib/browser/llamafile-preferences.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.bindAILlamafilePreferences = exports.aiLlamafilePreferencesSchema = exports.PREFERENCE_LLAMAFILE = exports.AI_LLAMAFILE_PREFERENCES_TITLE = void 0;
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
exports.AI_LLAMAFILE_PREFERENCES_TITLE = core_1.nls.localize('theia/ai/llamaFile/prefs/title', '✨ AI LlamaFile');
exports.PREFERENCE_LLAMAFILE = 'ai-features.llamafile.llamafiles';
exports.aiLlamafilePreferencesSchema = {
    type: 'object',
    properties: {
        [exports.PREFERENCE_LLAMAFILE]: {
            title: exports.AI_LLAMAFILE_PREFERENCES_TITLE,
            markdownDescription: core_1.nls.localize('theia/ai/llamaFile/prefs/mdDescription', 'This setting allows you to configure and manage LlamaFile models in Theia IDE.\
            \n\
            Each entry requires a user-friendly `name`, the file `uri` pointing to your LlamaFile, and the `port` on which it will run.\
            \n\
            To start a LlamaFile, use the "Start LlamaFile" command, which enables you to select the desired model.\
            \n\
            If you edit an entry (e.g., change the port), any running instance will stop, and you will need to manually start it again.\
            \n\
            [Learn more about configuring and managing LlamaFiles in the Theia IDE documentation](https://theia-ide.org/docs/user_ai/#llamafile-models).'),
            type: 'array',
            default: [],
            items: {
                type: 'object',
                properties: {
                    name: {
                        type: 'string',
                        description: core_1.nls.localize('theia/ai/llamaFile/prefs/name/description', 'The model name to use for this Llamafile.')
                    },
                    uri: {
                        type: 'string',
                        description: core_1.nls.localize('theia/ai/llamaFile/prefs/uri/description', 'The file uri to the Llamafile.')
                    },
                    port: {
                        type: 'number',
                        description: core_1.nls.localize('theia/ai/llamaFile/prefs/port/description', 'The port to use to start the server.')
                    }
                }
            }
        }
    }
};
function bindAILlamafilePreferences(bind) {
    bind(browser_1.PreferenceContribution).toConstantValue({ schema: exports.aiLlamafilePreferencesSchema });
}
exports.bindAILlamafilePreferences = bindAILlamafilePreferences;


/***/ }),

/***/ "../../node_modules/@theia/ai-llamafile/lib/common/llamafile-manager.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@theia/ai-llamafile/lib/common/llamafile-manager.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LlamafileManagerPath = exports.LlamafileManager = void 0;
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
exports.LlamafileManager = Symbol('LlamafileManager');
exports.LlamafileManagerPath = '/services/llamafilemanager';


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_ai-llamafile_lib_browser_llamafile-frontend-module_js.js.map