/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.load;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.tmf.core.Tracer;
import org.eclipse.linuxtools.tmf.ui.TmfUiPlugin;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.SDView;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.load.IUml2SDLoader;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;

public class LoadersManager {
    public static final String LOADER_TAG = "uml2SDLoader";
    public static final String LOADER_PREFIX = "uml2SDLoader.";
    private static LoadersManager loadersManager;
    protected HashMap<String, IUml2SDLoader> fViewLoaderMap = new HashMap();
    protected HashMap<String, ArrayList<IConfigurationElement>> fViewLoadersList = new HashMap();

    private LoadersManager() {
    }

    public static LoadersManager getInstance() {
        if (loadersManager == null) {
            loadersManager = new LoadersManager();
        }
        return loadersManager;
    }

    public IUml2SDLoader createLoader(String className, SDView view) {
        if (view == null) {
            return null;
        }
        String viewId = view.getViewSite().getId();
        List<IConfigurationElement> loaderElements = this.getLoaderConfigurationElements(viewId);
        IConfigurationElement ce = this.getLoaderConfigurationElement(className, loaderElements);
        if (ce != null) {
            this.createLoaderForView(viewId, ce);
            IUml2SDLoader loader = this.fViewLoaderMap.get(viewId);
            if (loader != null) {
                loader.setViewer(view);
                return loader;
            }
        }
        return null;
    }

    public void resetLoader(String viewId) {
        IUml2SDLoader loader = this.fViewLoaderMap.get(viewId);
        if (loader != null) {
            loader.dispose();
        }
        this.fViewLoaderMap.put(viewId, null);
    }

    public IUml2SDLoader getCurrentLoader(String viewId) {
        return this.getCurrentLoader(viewId, null);
    }

    public IUml2SDLoader getCurrentLoader(String viewId, SDView view) {
        block7: {
            if (viewId == null) {
                return null;
            }
            IWorkbenchPage persp = TmfUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            SDView sdView = view;
            try {
                if (sdView != null) break block7;
                IViewReference viewref = persp.findViewReference(viewId);
                if (viewref != null) {
                    sdView = (SDView)viewref.getView(false);
                }
                if (sdView != null) break block7;
                return null;
            }
            catch (Exception e) {
                if (Tracer.isErrorTraced()) {
                    Tracer.traceError((String)("Exception during getCurrentLoder(): " + e));
                }
                return null;
            }
        }
        IUml2SDLoader loader = this.fViewLoaderMap.get(viewId);
        if (loader == null) {
            this.createLastLoaderIfAny(viewId);
            loader = this.fViewLoaderMap.get(viewId);
        }
        return loader;
    }

    public String getSavedLoader(String viewId) {
        IPreferenceStore p = TmfUiPlugin.getDefault().getPreferenceStore();
        return p.getString(LOADER_PREFIX + viewId);
    }

    public void saveLastLoader(String id, String id2) {
        IPreferenceStore p = TmfUiPlugin.getDefault().getPreferenceStore();
        p.setValue(LOADER_PREFIX + id2, id);
    }

    private void setCurrentLoader(IUml2SDLoader loader, String id) {
        if (id == null) {
            return;
        }
        IUml2SDLoader currentLoader = this.fViewLoaderMap.get(id);
        if (currentLoader != null && currentLoader != loader) {
            if (loader != null) {
                IWorkbenchPage persp = TmfUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    SDView sdview = null;
                    IViewReference viewref = persp.findViewReference(id);
                    if (viewref != null) {
                        sdview = (SDView)viewref.getView(false);
                    }
                    if (sdview != null) {
                        sdview.resetProviders();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            currentLoader.dispose();
        }
        this.fViewLoaderMap.put(id, loader);
        if (loader != null) {
            this.saveLastLoader(loader.getClass().getName(), id);
        }
    }

    private void createLastLoaderIfAny(String viewId) {
        List<IConfigurationElement> loaderElements;
        String loaderName = this.getSavedLoader(viewId);
        IConfigurationElement ce = this.getLoaderConfigurationElement(loaderName, loaderElements = this.getLoaderConfigurationElements(viewId));
        if (ce == null) {
            ce = this.getDefaultLoader(loaderElements);
        }
        if (ce != null) {
            this.createLoaderForView(viewId, ce);
        }
    }

    private List<IConfigurationElement> getLoaderConfigurationElements(String viewId) {
        List list = this.fViewLoadersList.get(viewId);
        if (list != null) {
            return list;
        }
        ArrayList<IConfigurationElement> ret = new ArrayList<IConfigurationElement>();
        IExtensionPoint iep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.linuxtools.tmf.ui", LOADER_TAG);
        if (iep == null) {
            return ret;
        }
        IExtension[] ie = iep.getExtensions();
        if (ie == null) {
            return ret;
        }
        int i = 0;
        while (i < ie.length) {
            IConfigurationElement[] c = ie[i].getConfigurationElements();
            int j = 0;
            while (j < c.length) {
                if (viewId.equals(c[j].getAttribute("view"))) {
                    ret.add(c[j]);
                }
                ++j;
            }
            ++i;
        }
        this.fViewLoadersList.put(viewId, ret);
        return ret;
    }

    private IConfigurationElement getLoaderConfigurationElement(String loaderClassName, List<IConfigurationElement> loaderElements) {
        if (loaderClassName != null && loaderClassName.length() > 0) {
            for (IConfigurationElement ce : loaderElements) {
                if (!ce.getAttribute("class").equals(loaderClassName)) continue;
                return ce;
            }
        }
        return null;
    }

    private IConfigurationElement getDefaultLoader(List<IConfigurationElement> loaderElements) {
        for (IConfigurationElement ce : loaderElements) {
            if (!Boolean.valueOf(ce.getAttribute("default")).booleanValue()) continue;
            return ce;
        }
        return null;
    }

    private void createLoaderForView(String viewId, IConfigurationElement ce) {
        try {
            Object obj = ce.createExecutableExtension("class");
            IUml2SDLoader l = (IUml2SDLoader)obj;
            if (viewId != null) {
                this.setCurrentLoader(l, viewId);
            }
        }
        catch (CoreException e4) {
            System.err.println("Error 'uml2SDLoader' Extension point :" + (Object)((Object)e4));
        }
        catch (Exception e5) {
            e5.printStackTrace();
            System.err.println("Error 'uml2SDLoader' Extension point :" + e5);
        }
    }
}

