/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.filter;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.linuxtools.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.linuxtools.tmf.core.filter.model.TmfFilterRootNode;
import org.eclipse.linuxtools.tmf.core.filter.xml.TmfFilterXMLParser;
import org.eclipse.linuxtools.tmf.core.filter.xml.TmfFilterXMLWriter;
import org.eclipse.linuxtools.tmf.ui.TmfUiPlugin;
import org.xml.sax.SAXException;

public class FilterManager {
    private static final String SAVED_FILTERS_FILE_NAME = "saved_filters.xml";
    private static final String SAVED_FILTERS_PATH_NAME = TmfUiPlugin.getDefault().getStateLocation().addTrailingSeparator().append("saved_filters.xml").toString();
    private static ITmfFilterTreeNode fRoot = new TmfFilterRootNode();

    static {
        try {
            fRoot = new TmfFilterXMLParser(SAVED_FILTERS_PATH_NAME).getTree();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ITmfFilterTreeNode[] getSavedFilters() {
        return fRoot.clone().getChildren();
    }

    public static void setSavedFilters(ITmfFilterTreeNode[] filters) {
        fRoot = new TmfFilterRootNode();
        ITmfFilterTreeNode[] iTmfFilterTreeNodeArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfFilterTreeNode filter = iTmfFilterTreeNodeArray[n2];
            fRoot.addChild(filter.clone());
            ++n2;
        }
        try {
            TmfFilterXMLWriter writerXML = new TmfFilterXMLWriter(fRoot);
            writerXML.saveTree(SAVED_FILTERS_PATH_NAME);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }
}

