/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui.editor.outline;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.linuxtools.rpm.ui.editor.SpecfileEditor;
import org.eclipse.linuxtools.rpm.ui.editor.outline.ContainsFilter;
import org.eclipse.linuxtools.rpm.ui.editor.outline.SpecfileContentProvider;
import org.eclipse.linuxtools.rpm.ui.editor.outline.SpecfileLabelProvider;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileElement;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.texteditor.ITextEditor;

public class SpecfileQuickOutlineDialog
extends PopupDialog {
    TreeViewer treeViewer;
    private Text filterText;
    private SpecfileEditor editor;
    private ContainsFilter treeViewerFilter;

    public SpecfileQuickOutlineDialog(Shell parent, int shellStyle, SpecfileEditor editor) {
        super(parent, shellStyle, true, true, true, true, true, null, null);
        this.editor = editor;
        this.create();
    }

    public void setSize(int width, int height) {
        this.getShell().setSize(width, height);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
            this.filterText.setFocus();
        } else {
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public void dispose() {
        this.close();
    }

    protected Control createDialogArea(Composite parent) {
        this.createUIWidgetTreeViewer(parent);
        this.createUIListenersTreeViewer();
        return this.treeViewer.getControl();
    }

    protected Control createTitleControl(Composite parent) {
        this.filterText = new Text(parent, 0);
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(-1, Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1)).applyTo((Control)this.filterText);
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    SpecfileQuickOutlineDialog.this.gotoSelectedElement();
                } else if (e.keyCode == 0x1000002) {
                    SpecfileQuickOutlineDialog.this.treeViewer.getTree().setFocus();
                } else if (e.keyCode == 0x1000001) {
                    SpecfileQuickOutlineDialog.this.treeViewer.getTree().setFocus();
                } else if (e.character == '\u001b') {
                    SpecfileQuickOutlineDialog.this.dispose();
                }
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String filterTextInput = ((Text)e.widget).getText().toLowerCase();
                SpecfileQuickOutlineDialog.this.treeViewerFilter.setLookFor(filterTextInput);
                SpecfileQuickOutlineDialog.this.stringMatcherUpdated();
            }
        });
        return this.filterText;
    }

    private void stringMatcherUpdated() {
        this.treeViewer.getControl().setRedraw(false);
        this.treeViewer.refresh();
        this.treeViewer.expandAll();
        this.treeViewer.getTree().select(this.treeViewer.getTree().getItem(0));
        this.treeViewer.getControl().setRedraw(true);
    }

    private void createUIWidgetTreeViewer(Composite parent) {
        Tree widget = new Tree(parent, 768);
        GridData data = new GridData(1808);
        data.heightHint = widget.getItemHeight() * 12;
        widget.setLayoutData((Object)data);
        this.treeViewer = new TreeViewer(widget);
        this.treeViewerFilter = new ContainsFilter();
        this.treeViewer.addFilter((ViewerFilter)this.treeViewerFilter);
        SpecfileContentProvider fOutlineContentProvider = new SpecfileContentProvider((ITextEditor)this.editor);
        this.treeViewer.setContentProvider((IContentProvider)fOutlineContentProvider);
        SpecfileLabelProvider fTreeLabelProvider = new SpecfileLabelProvider();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)fTreeLabelProvider);
        this.treeViewer.setAutoExpandLevel(-1);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setInput((Object)fOutlineContentProvider);
    }

    private void createUIListenersTreeViewer() {
        Tree tree = this.treeViewer.getTree();
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SpecfileQuickOutlineDialog.this.gotoSelectedElement();
            }
        });
    }

    private void gotoSelectedElement() {
        SpecfileElement curElement = (SpecfileElement)this.getSelectedElement();
        if (curElement == null) {
            return;
        }
        this.dispose();
        this.editor.setHighlightRange(curElement.getLineStartPosition(), 1, true);
    }

    private Object getSelectedElement() {
        if (this.treeViewer == null) {
            return null;
        }
        return ((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
    }
}

