/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.build.internal.core.scannerconfig.jobs;

import java.util.List;
import java.util.Properties;
import org.eclipse.cdt.build.core.scannerconfig.CfgInfoContext;
import org.eclipse.cdt.make.core.scannerconfig.IExternalScannerInfoProvider;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector2;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCProfileInstance;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;

public class CfgSCJobsUtil {
    public static SCProfileInstance getProviderScannerInfo(final IProject project, final CfgInfoContext context, SCProfileInstance profileInstance, final IScannerConfigBuilderInfo2 buildInfo, final Properties env, final IProgressMonitor monitor) {
        final RC rc = new RC(false);
        if (profileInstance == null) {
            profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(project, context.toInfoContext(), buildInfo.getSelectedProfileId());
        }
        final IScannerInfoCollector collector = profileInstance.getScannerInfoCollector();
        List providerIds = buildInfo.getProviderIdList();
        int i = 0;
        while (i < providerIds.size()) {
            IExternalScannerInfoProvider esiProvider;
            final String providerId = (String)providerIds.get(i);
            if (buildInfo.isProviderOutputParserEnabled(providerId) && (esiProvider = profileInstance.createExternalScannerInfoProvider(providerId)) != null) {
                ISafeRunnable runnable = new ISafeRunnable(){

                    public void run() {
                        esiProvider.invokeProvider(monitor, (IResource)project, context.toInfoContext(), providerId, buildInfo, collector, env);
                        rc.set(true);
                    }

                    public void handleException(Throwable exception) {
                        rc.set(false);
                        ManagedBuilderCorePlugin.log(exception);
                    }
                };
                Platform.run((ISafeRunnable)runnable);
            }
            ++i;
        }
        if (rc.get()) {
            return profileInstance;
        }
        return null;
    }

    public static boolean updateScannerConfiguration(IProject project, IScannerConfigBuilderInfo2 buildInfo, IProgressMonitor monitor) {
        return CfgSCJobsUtil.updateScannerConfiguration(project, null, null, buildInfo, monitor);
    }

    public static boolean updateScannerConfiguration(IProject project, CfgInfoContext context, SCProfileInstance profileInstance, IScannerConfigBuilderInfo2 buildInfo, final IProgressMonitor monitor) {
        IScannerInfoCollector collector;
        final RC rc = new RC(false);
        if (profileInstance == null) {
            profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(project, context.toInfoContext(), buildInfo.getSelectedProfileId());
        }
        if ((collector = profileInstance.getScannerInfoCollector()) instanceof IScannerInfoCollector2) {
            final IScannerInfoCollector2 collector2 = (IScannerInfoCollector2)collector;
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    collector2.updateScannerConfiguration(monitor);
                    rc.set(true);
                }

                public void handleException(Throwable exception) {
                    rc.set(false);
                    ManagedBuilderCorePlugin.log(exception);
                }
            };
            Platform.run((ISafeRunnable)runnable);
        }
        return rc.get();
    }

    public static SCProfileInstance readBuildOutputFile(final IProject project, final CfgInfoContext context, final IScannerConfigBuilderInfo2 buildInfo, final Properties env, final IProgressMonitor monitor) {
        final RC rc = new RC(false);
        SCProfileInstance profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(project, context.toInfoContext(), buildInfo.getSelectedProfileId());
        final IScannerInfoCollector collector = profileInstance.getScannerInfoCollector();
        final IExternalScannerInfoProvider esiProvider = profileInstance.createBuildOutputProvider();
        if (buildInfo.isBuildOutputFileActionEnabled()) {
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() {
                    esiProvider.invokeProvider(monitor, (IResource)project, context.toInfoContext(), null, buildInfo, collector, env);
                    rc.set(true);
                }

                public void handleException(Throwable exception) {
                    rc.set(false);
                    ManagedBuilderCorePlugin.log(exception);
                }
            };
            Platform.run((ISafeRunnable)runnable);
        }
        if (rc.get()) {
            return profileInstance;
        }
        return null;
    }

    private static class RC {
        private boolean rc;

        public RC(boolean init) {
            this.rc = init;
        }

        public boolean get() {
            return this.rc;
        }

        public void set(boolean rc) {
            this.rc = rc;
        }

        public String toString() {
            return this.rc ? "true" : "false";
        }
    }
}

