/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;

public class CompilationUnitOverrideSupport {
    public static final char SEPARATOR = '/';
    private final Map<CharBuffer, ICompilationUnit> m_overrideCompilationUnits = new HashMap<CharBuffer, ICompilationUnit>();
    private final Set<CharBuffer> m_additionalPackages = new HashSet<CharBuffer>();

    public boolean addCompilationUnit(ICompilationUnit cu) {
        char[][] packageName0 = cu.getPackageName();
        CharBuffer key = CharBuffer.wrap(CharOperation.concatWith((char[][])packageName0, (char[])cu.getMainTypeName(), (char)'/'));
        boolean updatedExistingEntry = false;
        ICompilationUnit existingIcu = this.m_overrideCompilationUnits.put(key, cu);
        if (existingIcu != null) {
            boolean bl = updatedExistingEntry = !Arrays.equals(existingIcu.getContents(), cu.getContents());
        }
        if (packageName0 != null && packageName0.length > 0) {
            for (int i = 1; i <= packageName0.length; ++i) {
                this.m_additionalPackages.add(CharBuffer.wrap(CharOperation.concatWith((char[][])CharOperation.subarray((char[][])packageName0, (int)0, (int)i), (char)'/')));
            }
        }
        return updatedExistingEntry;
    }

    public Collection<ICompilationUnit> getCompilationUnits() {
        return this.m_overrideCompilationUnits.values();
    }

    public boolean containsPackage(char[] pck) {
        return this.m_additionalPackages.contains(CharBuffer.wrap(pck));
    }

    public int size() {
        return this.m_overrideCompilationUnits.size();
    }

    public ICompilationUnit get(char[] fqn) {
        return this.m_overrideCompilationUnits.get(CharBuffer.wrap(fqn));
    }

    public void clear() {
        this.m_additionalPackages.clear();
        this.m_overrideCompilationUnits.clear();
    }
}

