/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.model.api.query;

import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.java.model.api.IMethodParameter;
import org.eclipse.scout.sdk.core.java.model.api.spliterator.WrappingSpliterator;
import org.eclipse.scout.sdk.core.java.model.spi.MethodSpi;
import org.eclipse.scout.sdk.core.model.query.AbstractQuery;

public class MethodParameterQuery
extends AbstractQuery<IMethodParameter>
implements Predicate<IMethodParameter> {
    private final MethodSpi m_method;
    private String m_name;
    private String m_dataTypeFqn;

    public MethodParameterQuery(MethodSpi method) {
        this.m_method = method;
    }

    protected MethodSpi getMethod() {
        return this.m_method;
    }

    public MethodParameterQuery withName(String name) {
        this.m_name = name;
        return this;
    }

    protected String getName() {
        return this.m_name;
    }

    public MethodParameterQuery withDataType(String dataTypeFqn) {
        this.m_dataTypeFqn = dataTypeFqn;
        return this;
    }

    protected String getDataType() {
        return this.m_dataTypeFqn;
    }

    @Override
    public boolean test(IMethodParameter p) {
        String name = this.getName();
        if (name != null && !name.equals(p.elementName())) {
            return false;
        }
        String dataTypeFqn = this.getDataType();
        return dataTypeFqn == null || dataTypeFqn.equals(p.dataType().name());
    }

    protected Stream<IMethodParameter> createStream() {
        return WrappingSpliterator.stream(this.getMethod().getParameters()).filter(this);
    }
}

