/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.ui.registry;

import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.command.internal.env.ui.widgets.INamedWidgetContributorFactory;

public class WidgetRegistry {
    private static WidgetRegistry registry_;
    private Hashtable entries_;

    private WidgetRegistry() {
    }

    public static WidgetRegistry instance() {
        if (registry_ == null) {
            registry_ = new WidgetRegistry();
            registry_.load();
        }
        return registry_;
    }

    public static void initialize() {
        registry_ = null;
    }

    public INamedWidgetContributorFactory getFactory(String id) {
        INamedWidgetContributorFactory factory = null;
        Entry entry = (Entry)this.entries_.get(id);
        if (entry != null) {
            try {
                if (entry.factory_ == null) {
                    entry.factory_ = (INamedWidgetContributorFactory)entry.element_.createExecutableExtension("class");
                }
                factory = entry.factory_;
            }
            catch (CoreException exc) {
                exc.printStackTrace();
            }
            catch (Throwable exc) {
                exc.printStackTrace();
            }
        }
        return factory;
    }

    private void load() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.wst.command.env.ui.widgetRegistry");
        this.entries_ = new Hashtable();
        int index = 0;
        while (index < elements.length) {
            if (elements[index].getName().equals("widgetFactory")) {
                Entry entry = new Entry();
                IConfigurationElement element = elements[index];
                String id = element.getAttribute("id");
                String methodId = element.getAttribute("insertBeforeCommandId");
                entry.element_ = element;
                entry.id_ = id;
                this.entries_.put(methodId, entry);
            }
            ++index;
        }
    }

    private class Entry {
        String id_;
        IConfigurationElement element_;
        INamedWidgetContributorFactory factory_;

        private Entry() {
        }
    }
}

