/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.commands;

import javax.wsdl.OperationType;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Operation;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11TopLevelElementCommand;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IMessageReference;

public class W11ReorderMessageReferencesCommand
extends W11TopLevelElementCommand {
    protected IMessageReference leftSibling;
    protected IMessageReference rightSibling;
    protected IMessageReference movingParameter;

    public W11ReorderMessageReferencesCommand(IMessageReference leftSibling, IMessageReference rightSibling, IMessageReference movingParameter) {
        super(Messages._UI_ACTION_REORDER_MESSAGE_REFERENCE, null);
        this.leftSibling = leftSibling;
        this.rightSibling = rightSibling;
        this.movingParameter = movingParameter;
    }

    @Override
    public void execute() {
        IMessageReference leftSibElement = null;
        IMessageReference movingChild = null;
        if (this.leftSibling instanceof IMessageReference) {
            leftSibElement = this.leftSibling;
        }
        if (this.movingParameter instanceof IMessageReference) {
            movingChild = this.movingParameter;
        }
        W11Operation w11Operation = (W11Operation)movingChild.getOwnerOperation();
        Operation operation = (Operation)w11Operation.getTarget();
        try {
            this.beginRecording(operation.getElement());
            if (movingChild.getKind() == 1) {
                if (leftSibElement == null) {
                    this.setInputOutputOrder(operation, true);
                } else if (leftSibElement != null && leftSibElement.getKind() == 1) {
                    if (this.rightSibling.getKind() == 2) {
                        this.setInputOutputOrder(operation, true);
                    }
                } else {
                    this.setInputOutputOrder(operation, false);
                }
            } else if (movingChild.getKind() == 2) {
                if (leftSibElement == null) {
                    this.setInputOutputOrder(operation, false);
                } else if (leftSibElement != null && leftSibElement.getKind() == 2) {
                    if (this.rightSibling.getKind() == 1) {
                        this.setInputOutputOrder(operation, false);
                    }
                } else {
                    this.setInputOutputOrder(operation, true);
                }
            }
        }
        finally {
            this.endRecording(operation.getElement());
        }
    }

    private void setInputOutputOrder(Operation operation, boolean inputFirst) {
        if (inputFirst && operation.getEInput() != null) {
            if (operation.getEOutput() != null) {
                this.setOperationStyle(operation, OperationType.REQUEST_RESPONSE);
            } else {
                this.setOperationStyle(operation, OperationType.ONE_WAY);
            }
        } else if (operation.getEOutput() != null) {
            if (operation.getEInput() != null) {
                this.setOperationStyle(operation, OperationType.SOLICIT_RESPONSE);
            } else {
                this.setOperationStyle(operation, OperationType.NOTIFICATION);
            }
        }
    }

    private void setOperationStyle(Operation operation, OperationType operationType) {
        if (operation.getStyle() == null) {
            return;
        }
        operation.setStyle(operationType);
    }
}

