/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.infer;

import org.eclipse.wst.jsdt.core.ast.IFunctionDeclaration;
import org.eclipse.wst.jsdt.core.infer.InferredMember;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;

public class InferredMethod
extends InferredMember {
    private MethodDeclaration methodDeclaration;
    public boolean isConstructor;
    public MethodBinding methodBinding;

    public InferredMethod(char[] name, IFunctionDeclaration functionDeclaration, InferredType inType) {
        this.methodDeclaration = (MethodDeclaration)functionDeclaration;
        this.name = name;
        this.inType = inType;
        this.sourceStart = this.methodDeclaration.sourceStart;
        this.sourceEnd = this.methodDeclaration.sourceEnd;
    }

    public IFunctionDeclaration getFunctionDeclaration() {
        return this.methodDeclaration;
    }

    @Override
    public StringBuffer print(int indent, StringBuffer output) {
        String modifier = this.isStatic ? "static " : "";
        InferredMethod.printIndent(indent, output).append(modifier);
        if (!this.isConstructor) {
            if (this.methodDeclaration.inferredType != null) {
                this.methodDeclaration.inferredType.dumpReference(output);
            } else {
                output.append("??");
            }
            output.append(" ");
        }
        output.append(this.name).append("(");
        if (this.methodDeclaration.arguments != null) {
            int i = 0;
            while (i < this.methodDeclaration.arguments.length) {
                InferredType argumentType;
                if (i > 0) {
                    output.append(", ");
                }
                if ((argumentType = this.methodDeclaration.arguments[i].inferredType) != null) {
                    output.append(argumentType.name).append(" ");
                }
                output.append(this.methodDeclaration.arguments[i].name);
                ++i;
            }
        }
        output.append(")");
        return output;
    }
}

