/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.api.internal;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.typescript.model.api.AbstractNodeElement;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeElement;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeElementFactory;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeModule;
import org.eclipse.scout.sdk.core.typescript.model.api.IPackageJson;
import org.eclipse.scout.sdk.core.typescript.model.api.query.NodeElementQuery;
import org.eclipse.scout.sdk.core.typescript.model.spi.ES6ClassSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.NodeElementSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.NodeModuleSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.PackageJsonSpi;
import org.eclipse.scout.sdk.core.util.Ensure;

public class NodeModuleImplementor
extends AbstractNodeElement<NodeModuleSpi>
implements INodeModule {
    private final PackageJsonSpi m_packageJson;

    public NodeModuleImplementor(NodeModuleSpi spi, PackageJsonSpi packageJson) {
        super(spi);
        this.m_packageJson = (PackageJsonSpi)Ensure.notNull((Object)packageJson);
    }

    @Override
    public IPackageJson packageJson() {
        return this.m_packageJson.api();
    }

    @Override
    public NodeElementQuery elements() {
        return new NodeElementQuery((NodeModuleSpi)this.spi());
    }

    @Override
    public Stream<IES6Class> classes() {
        return ((NodeModuleSpi)this.spi()).classes().stream().map(ES6ClassSpi::api);
    }

    @Override
    public Optional<INodeElement> export(String name) {
        return Optional.ofNullable(((NodeModuleSpi)this.spi()).exports().get(name)).map(NodeElementSpi::api);
    }

    @Override
    public Set<String> moduleExportNames() {
        return Collections.singleton(this.name());
    }

    @Override
    public String name() {
        return this.packageJson().name();
    }

    @Override
    public INodeElementFactory nodeElementFactory() {
        return ((NodeModuleSpi)this.spi()).nodeElementFactory().api();
    }

    public String toString() {
        return this.packageJson().toString();
    }
}

