/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.log;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class LogMessage {
    private final Level m_severity;
    private final String m_prefix;
    private final String m_text;
    private final List<Throwable> m_throwables;

    LogMessage(Level severity, String prefix, String text, List<Throwable> throwables) {
        this.m_severity = Ensure.notNull(severity);
        this.m_prefix = Ensure.notNull(prefix);
        this.m_text = Ensure.notNull(text);
        this.m_throwables = throwables;
    }

    public String text() {
        return this.m_text;
    }

    public Stream<Throwable> throwables() {
        return this.m_throwables.stream();
    }

    public List<Throwable> throwableList() {
        return Collections.unmodifiableList(this.m_throwables);
    }

    public Optional<Throwable> firstThrowable() {
        return this.throwables().findFirst();
    }

    public Level severity() {
        return this.m_severity;
    }

    public String prefix() {
        return this.m_prefix;
    }

    public String all() {
        StringBuilder logContent = new StringBuilder(this.prefix()).append(this.text());
        if (!this.m_throwables.isEmpty()) {
            Iterator<Throwable> iterator = this.m_throwables.iterator();
            Throwable t = iterator.next();
            logContent.append(System.lineSeparator()).append(Strings.fromThrowable(t));
            while (iterator.hasNext()) {
                t = iterator.next();
                logContent.append(System.lineSeparator()).append(Strings.fromThrowable(t));
            }
        }
        return logContent.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogMessage that = (LogMessage)o;
        return this.m_severity.equals(that.m_severity) && this.m_prefix.equals(that.m_prefix) && this.m_text.equals(that.m_text) && this.m_throwables.equals(that.m_throwables);
    }

    public int hashCode() {
        return Objects.hash(this.m_severity, this.m_prefix, this.m_text, this.m_throwables);
    }

    public String toString() {
        return LogMessage.class.getSimpleName() + ": " + this.m_prefix + this.m_text;
    }
}

