/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.model.js.prop;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.s.model.js.ScoutJsCoreConstants;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataTypeVisitor;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeModule;
import org.eclipse.scout.sdk.core.util.visitor.IBreadthFirstVisitor;
import org.eclipse.scout.sdk.core.util.visitor.TreeVisitResult;

public class ScoutJsCoreDataTypesUnwrapVisitor
implements IDataTypeVisitor {
    private final IBreadthFirstVisitor<IDataType> m_wrappedVisitor;

    public ScoutJsCoreDataTypesUnwrapVisitor(IBreadthFirstVisitor<IDataType> wrappedVisitor) {
        this.m_wrappedVisitor = wrappedVisitor;
    }

    public TreeVisitResult visit(IDataType element, int level, int index) {
        return ScoutJsCoreDataTypesUnwrapVisitor.unwrap(element).map(l -> this.m_wrappedVisitor.visit(l, level, index)).orElse(TreeVisitResult.SKIP_SUBTREE);
    }

    public Stream<IDataType> childTypes(IDataType parent) {
        return ScoutJsCoreDataTypesUnwrapVisitor.unwrappedChildren(parent);
    }

    public static Optional<IDataType> unwrap(IDataType element) {
        if (element == null) {
            return Optional.empty();
        }
        if (element.flavor() == IDataType.DataTypeFlavor.Array) {
            return element.childTypes().findAny().flatMap(ScoutJsCoreDataTypesUnwrapVisitor::unwrap).map(unwrapped -> unwrapped.createArrayType(element.arrayDimension()));
        }
        if (!(element instanceof IES6Class)) {
            return Optional.of(element);
        }
        IES6Class clazz = (IES6Class)element;
        IES6Class rawClass = clazz.withoutTypeArguments();
        INodeModule containingModule = rawClass.containingModule();
        if (!"@eclipse-scout/core".equals(containingModule.name())) {
            return Optional.of(element);
        }
        String className = rawClass.name();
        if (ScoutJsCoreConstants.CLASS_NAMES_MODEL_TYPES.contains(className)) {
            return clazz.typeArguments().findFirst();
        }
        if ("StatusOrModel".equals(className)) {
            return containingModule.export("Status").map(s -> (IDataType)s);
        }
        if ("LookupCallOrModel".equals(className)) {
            return containingModule.export("LookupCall").map(s -> (IDataType)s);
        }
        return Optional.of(element);
    }

    public static Stream<IDataType> unwrappedChildren(IDataType parent) {
        return parent.childTypes().flatMap(c -> ScoutJsCoreDataTypesUnwrapVisitor.unwrap(c).stream());
    }
}

