/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.contentassist;

import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jst.jsp.ui.internal.contentassist.JSPCompletionProposal;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class JSPMethodCompletionProposal
extends JSPCompletionProposal {
    private CompletionProposal fProposal;
    private IJavaProject fProject;
    private FormatterPrefs fFormatterPrefs;
    private static final String LPAREN = "(";
    private static final String RPAREN = ")";
    private static final String COMMA = ",";
    private static final String SPACE = " ";
    private IRegion fSelectedRegion;

    public JSPMethodCompletionProposal(CompletionProposal proposal, IJavaProject project, String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int relevance, boolean updateReplacementLengthOnValidate) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, relevance, updateReplacementLengthOnValidate);
        this.fProposal = proposal;
        this.fProject = project;
    }

    @Override
    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        Position position;
        char[][] parameters;
        Position[] positions = null;
        FormatterPrefs formatterPrefs = this.getFormatterPrefs();
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.fProposal.getName());
        if (formatterPrefs.beforeOpeningParen) {
            buffer.append(SPACE);
        }
        buffer.append(LPAREN);
        if (formatterPrefs.afterOpeningParen) {
            buffer.append(SPACE);
        }
        if (Signature.getParameterCount((char[])this.fProposal.getSignature()) > 0 && (parameters = this.fProposal.findParameterNames(null)) != null) {
            positions = new Position[parameters.length];
            int base = this.getReplacementOffset();
            int i = 0;
            while (i < parameters.length) {
                if (i != 0) {
                    if (formatterPrefs.beforeComma) {
                        buffer.append(SPACE);
                    }
                    buffer.append(COMMA);
                    if (formatterPrefs.afterComma) {
                        buffer.append(SPACE);
                    }
                }
                position = new Position(0, 0);
                position.setOffset(base + buffer.length());
                position.setLength(parameters[i].length);
                positions[i] = position;
                buffer.append(parameters[i]);
                ++i;
            }
        }
        if (formatterPrefs.beforeClosingParen) {
            buffer.append(SPACE);
        }
        buffer.append(RPAREN);
        this.setReplacementString(buffer.toString());
        super.apply(viewer, trigger, stateMask, offset);
        try {
            if (positions != null) {
                LinkedModeModel model = new LinkedModeModel();
                int i = 0;
                while (i < positions.length) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    position = positions[i];
                    group.addPosition(new LinkedPosition(viewer.getDocument(), position.getOffset(), position.getLength(), i));
                    model.addGroup(group);
                    ++i;
                }
                model.forceInstall();
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, viewer);
                ui.setExitPosition(viewer, this.getReplacementOffset() + this.getReplacementString().length(), 0, Integer.MAX_VALUE);
                ui.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(')', viewer.getDocument()));
                ui.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
                ui.setDoContextInfo(true);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    protected final FormatterPrefs getFormatterPrefs() {
        if (this.fFormatterPrefs == null) {
            this.fFormatterPrefs = new FormatterPrefs(this.fProject);
        }
        return this.fFormatterPrefs;
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion != null) {
            return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
        }
        return super.getSelection(document);
    }

    protected static final class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fExitCharacter;
        private final IDocument fDocument;

        public ExitPolicy(char exitCharacter, IDocument document) {
            this.fExitCharacter = exitCharacter;
            this.fDocument = document;
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel environment, VerifyEvent event, int offset, int length) {
            if (event.character == this.fExitCharacter) {
                if (environment.anyPositionContains(offset)) {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
                return new LinkedModeUI.ExitFlags(2, true);
            }
            switch (event.character) {
                case ';': {
                    return new LinkedModeUI.ExitFlags(0, true);
                }
                case '\r': {
                    if (offset > 0) {
                        try {
                            if (this.fDocument.getChar(offset - 1) == '{') {
                                return new LinkedModeUI.ExitFlags(1, true);
                            }
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    return null;
                }
            }
            return null;
        }
    }

    protected static final class FormatterPrefs {
        public final boolean beforeOpeningParen;
        public final boolean afterOpeningParen;
        public final boolean beforeComma;
        public final boolean afterComma;
        public final boolean beforeClosingParen;
        public final boolean inEmptyList;
        public final boolean beforeOpeningBracket;
        public final boolean afterOpeningBracket;
        public final boolean beforeTypeArgumentComma;
        public final boolean afterTypeArgumentComma;
        public final boolean beforeClosingBracket;

        FormatterPrefs(IJavaProject project) {
            this.beforeOpeningParen = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_method_invocation", false);
            this.afterOpeningParen = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_method_invocation", false);
            this.beforeComma = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_method_invocation_arguments", false);
            this.afterComma = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_method_invocation_arguments", true);
            this.beforeClosingParen = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_method_invocation", false);
            this.inEmptyList = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_method_invocation", false);
            this.beforeOpeningBracket = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_before_opening_angle_bracket_in_parameterized_type_reference", false);
            this.afterOpeningBracket = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_after_opening_angle_bracket_in_parameterized_type_reference", false);
            this.beforeTypeArgumentComma = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_parameterized_type_reference", false);
            this.afterTypeArgumentComma = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_parameterized_type_reference", true);
            this.beforeClosingBracket = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_before_closing_angle_bracket_in_parameterized_type_reference", false);
        }

        protected final boolean getCoreOption(IJavaProject project, String key, boolean def) {
            String option = this.getCoreOption(project, key);
            if ("insert".equals(option)) {
                return true;
            }
            if ("do not insert".equals(option)) {
                return false;
            }
            return def;
        }

        protected final String getCoreOption(IJavaProject project, String key) {
            if (project == null) {
                return JavaCore.getOption((String)key);
            }
            return project.getOption(key, true);
        }
    }
}

