/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.browsing;

import java.util.ArrayList;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.browsing.LogicalPackage;
import org.eclipse.dltk.ui.browsing.LogicalPackagesProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

class PackagesViewFlatContentProvider
extends LogicalPackagesProvider
implements IStructuredContentProvider {
    PackagesViewFlatContentProvider(StructuredViewer viewer) {
        super(viewer);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IModelElement) {
            IModelElement element = (IModelElement)parentElement;
            int type = element.getElementType();
            try {
                switch (type) {
                    case 2: {
                        IScriptProject project = (IScriptProject)element;
                        Object[] children = this.getPackageFragments(project.getScriptFolders());
                        if (this.isInCompoundState()) {
                            this.fMapToLogicalPackage.clear();
                            this.fMapToPackageFragments.clear();
                            return this.combineSamePackagesIntoLogialPackages((IScriptFolder[])children);
                        }
                        return children;
                    }
                    case 3: {
                        this.fMapToLogicalPackage.clear();
                        this.fMapToPackageFragments.clear();
                        IProjectFragment root = (IProjectFragment)element;
                        return root.getChildren();
                    }
                }
            }
            catch (ModelException e) {
                return NO_CHILDREN;
            }
        }
        return NO_CHILDREN;
    }

    private IScriptFolder[] getPackageFragments(IScriptFolder[] iPackageFragments) {
        ArrayList<IScriptFolder> list = new ArrayList<IScriptFolder>();
        int i = 0;
        while (i < iPackageFragments.length) {
            IProjectFragment root;
            IScriptFolder fragment = iPackageFragments[i];
            IModelElement el = fragment.getParent();
            if (!(el instanceof IProjectFragment && (root = (IProjectFragment)el).isArchive() && root.isExternal())) {
                list.add(fragment);
            }
            ++i;
        }
        return list.toArray(new IScriptFolder[list.size()]);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    @Override
    protected void processDelta(IModelElementDelta delta) throws ModelException {
        Object input;
        int kind = delta.getKind();
        IModelElement element = delta.getElement();
        if (this.isClassPathChange(delta) && (input = this.fViewer.getInput()) != null) {
            if (this.fInputIsProject && input.equals(element.getScriptProject())) {
                this.postRefresh(input);
                return;
            }
            if (!this.fInputIsProject && input.equals(element)) {
                if (element.exists()) {
                    this.postRefresh(input);
                } else {
                    this.postRemove(input);
                }
                return;
            }
        }
        if (kind == 2 && (input = this.fViewer.getInput()) != null && input.equals(element)) {
            this.postRemove(input);
            return;
        }
        if (element instanceof IScriptFolder) {
            IScriptFolder frag = (IScriptFolder)element;
            if (kind == 2) {
                this.removeElement(frag);
            } else if (kind == 1) {
                this.addElement(frag);
            } else if (kind == 4) {
                Object toBeRefreshed = element;
                IScriptFolder pkgFragment = (IScriptFolder)element;
                LogicalPackage logicalPkg = this.findLogicalPackage(pkgFragment);
                toBeRefreshed = logicalPkg != null ? this.findElementToRefresh(logicalPkg) : this.findElementToRefresh(pkgFragment);
                this.postRefresh(toBeRefreshed);
            }
            return;
        }
        this.processAffectedChildren(delta);
    }

    private Object findElementToRefresh(IScriptFolder fragment) {
        if (this.fViewer.testFindItem((Object)fragment) == null) {
            if (this.fInputIsProject) {
                return fragment.getScriptProject();
            }
            return fragment.getParent();
        }
        return fragment;
    }

    private Object findElementToRefresh(LogicalPackage logicalPackage) {
        if (this.fViewer.testFindItem((Object)logicalPackage) == null) {
            IScriptFolder fragment = logicalPackage.getScriptFolders()[0];
            return fragment.getScriptProject();
        }
        return logicalPackage;
    }

    private void processAffectedChildren(IModelElementDelta delta) throws ModelException {
        IModelElementDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            IModelElementDelta elementDelta = children[i];
            this.processDelta(elementDelta);
            ++i;
        }
    }

    private void postAdd(Object child) {
        this.postRunnable(() -> {
            Control ctrl = this.fViewer.getControl();
            if (ctrl != null && !ctrl.isDisposed()) {
                ((TableViewer)this.fViewer).add(child);
            }
        });
    }

    private void postRemove(Object object) {
        this.postRunnable(() -> {
            Control ctrl = this.fViewer.getControl();
            if (ctrl != null && !ctrl.isDisposed()) {
                ((TableViewer)this.fViewer).remove(object);
            }
        });
    }

    private void postRunnable(Runnable r) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            Display currentDisplay = Display.getCurrent();
            if (currentDisplay != null && currentDisplay.equals(ctrl.getDisplay())) {
                ctrl.getDisplay().syncExec(r);
            } else {
                ctrl.getDisplay().asyncExec(r);
            }
        }
    }

    private void removeElement(IScriptFolder frag) {
        String key = this.getKey(frag);
        LogicalPackage lp = (LogicalPackage)((Object)this.fMapToLogicalPackage.get(key));
        if (lp != null) {
            lp.remove(frag);
            if (lp.getScriptFolders().length == 1) {
                IScriptFolder fragment = lp.getScriptFolders()[0];
                this.fMapToLogicalPackage.remove(key);
                this.fMapToPackageFragments.put(key, fragment);
                this.postRemove((Object)lp);
                this.postAdd(fragment);
            }
            return;
        }
        this.fMapToPackageFragments.remove(key);
        this.postRemove(frag);
    }

    private void postRefresh(Object element) {
        this.postRunnable(() -> {
            Control ctrl = this.fViewer.getControl();
            if (ctrl != null && !ctrl.isDisposed()) {
                this.fViewer.refresh(element);
            }
        });
    }

    private void addElement(IScriptFolder frag) {
        String key = this.getKey(frag);
        LogicalPackage lp = (LogicalPackage)((Object)this.fMapToLogicalPackage.get(key));
        if (lp != null && lp.belongs(frag)) {
            lp.add(frag);
            return;
        }
        IScriptFolder fragment = (IScriptFolder)this.fMapToPackageFragments.get(key);
        if (fragment != null) {
            if (!fragment.equals(frag)) {
                lp = new LogicalPackage(fragment);
                lp.add(frag);
                this.fMapToLogicalPackage.put(key, lp);
                this.postRemove(fragment);
                this.postAdd((Object)lp);
                return;
            }
        } else {
            this.fMapToPackageFragments.put(key, frag);
            this.postAdd(frag);
        }
    }
}

