/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.ui.internal.search.dialogs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.wst.common.core.search.scope.SearchScope;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSearchListDialog;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSearchListDialogConfiguration;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentDescriptionProvider;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentList;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentSearchListProvider;

public class Test
extends ActionDelegate {
    IComponentSearchListProvider searchListProvider = new IComponentSearchListProvider(){

        @Override
        public void populateComponentList(IComponentList list, SearchScope scope, IProgressMonitor pm) {
            list.add("foo:Hello!");
            list.add("foo:Hey!");
            list.add("foo:How-are-you?");
            list.add("foo:What-is-that-smell?");
        }
    };

    public void run(IAction action) {
        try {
            ComponentSearchListDialogConfiguration configuration = new ComponentSearchListDialogConfiguration();
            configuration.setListLabelText("List:");
            configuration.setFilterLabelText("Filter:");
            configuration.setSearchListProvider(this.searchListProvider);
            configuration.setDescriptionProvider(new BaseComponentDescriptionProvider("foo"));
            Shell shell = Display.getCurrent().getActiveShell();
            ComponentSearchListDialog dialog = new ComponentSearchListDialog(shell, "test", configuration);
            dialog.setBlockOnOpen(true);
            dialog.create();
            dialog.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class BaseComponentDescriptionProvider
    extends LabelProvider
    implements IComponentDescriptionProvider {
        String prefix;

        BaseComponentDescriptionProvider(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public IFile getFile(Object component) {
            return null;
        }

        @Override
        public ILabelProvider getLabelProvider() {
            return this;
        }

        @Override
        public String getName(Object component) {
            String string = (String)component;
            return string.substring(this.prefix.length() + 1);
        }

        @Override
        public String getQualifier(Object component) {
            return this.prefix;
        }

        public String getText(Object element) {
            return this.getName(element);
        }

        @Override
        public boolean isApplicable(Object component) {
            if (component instanceof String) {
                return ((String)component).startsWith(this.prefix);
            }
            return false;
        }

        @Override
        public Image getFileIcon(Object component) {
            return null;
        }
    }
}

